/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.render;

import org.eclipse.e4.xwt.ui.editor.render.ManagerContext;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ScrollBar;

public class CanvasManager {
    private Image originalImage;
    private Canvas canvas;
    private Image displayImage;
    public int imageWidth = -1;
    public int imageHeight = -1;
    private int visibleWidth;
    private int visibleHeight;
    private ManagerContext displayMC = new ManagerContext();
    private ManagerContext imageMC = new ManagerContext();

    public CanvasManager(Canvas canvas) {
        this.canvas = canvas;
        this.initialize();
    }

    private void initialize() {
        ScrollBar scrollBar;
        this.displayMC.gc = new GC((Drawable)this.canvas);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                CanvasManager.this.handlePaint(paintEvent);
            }
        });
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                CanvasManager.this.handleResize();
            }
        });
        ScrollBar scrollBar2 = this.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.setVisible(true);
            scrollBar2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    CanvasManager.this.scrollHorizontally((ScrollBar)selectionEvent.widget);
                }
            });
        }
        if ((scrollBar = this.getVerticalBar()) != null) {
            scrollBar.setVisible(true);
            scrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    CanvasManager.this.scrollVertically((ScrollBar)selectionEvent.widget);
                }
            });
        }
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (((CanvasManager)CanvasManager.this).displayMC.gc != null) {
                    ((CanvasManager)CanvasManager.this).displayMC.gc.dispose();
                }
            }
        });
        this.handleResize();
    }

    public synchronized void setImage(Image image) {
        if (image != null) {
            this.originalImage = image;
            this.clearImage();
            this.createDisplayImage();
            this.canvas.redraw();
            this.canvas.getDisplay().update();
        }
    }

    private void createDisplayImage() {
        if (this.originalImage == null || this.originalImage.isDisposed()) {
            return;
        }
        Rectangle rectangle = this.originalImage.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Rectangle rectangle2 = this.canvas.getBounds();
        this.imageWidth = Math.max(n + 17, rectangle2.width);
        this.imageHeight = Math.max(n2 + 17, rectangle2.height);
        this.displayImage = new Image((Device)this.canvas.getDisplay(), this.imageWidth, this.imageHeight);
        this.imageMC.gc = new GC((Drawable)this.displayImage);
        this.imageMC.gc.fillRectangle(0, 0, this.imageWidth, this.imageHeight);
        this.imageMC.gc.drawImage(this.originalImage, 0, 0, n, n2, (this.imageWidth - n - 17) / 2, (this.imageHeight - n2 - 17) / 2, n, n2);
        this.handleResize();
    }

    private void clearImage() {
        if (this.displayImage != null) {
            this.displayImage.dispose();
            this.displayImage = null;
        }
        if (this.imageMC.gc != null) {
            this.imageMC.gc.dispose();
            this.imageMC.gc = null;
        }
    }

    public void dispose() {
        this.canvas = null;
        this.clearImage();
        if (this.displayMC.gc != null) {
            this.displayMC.gc.dispose();
            this.displayMC = null;
        }
        if (this.displayImage != null) {
            this.displayImage.dispose();
        }
    }

    protected void scrollVertically(ScrollBar scrollBar) {
        int n;
        int n2;
        if (this.displayImage == null) {
            return;
        }
        if (this.imageHeight > this.visibleHeight && (n2 = this.displayMC.yOffset) != (n = Math.min(scrollBar.getSelection(), this.imageHeight - this.visibleHeight))) {
            this.canvas.update();
            this.displayMC.yOffset = n;
            this.canvas.scroll(0, Math.max(n2 - n, 0), 0, Math.max(n - n2, 0), this.visibleWidth, this.visibleHeight, false);
        }
    }

    protected void scrollHorizontally(ScrollBar scrollBar) {
        int n;
        int n2;
        if (this.displayImage == null) {
            return;
        }
        if (this.imageWidth > this.visibleWidth && (n2 = this.displayMC.xOffset) != (n = Math.min(scrollBar.getSelection(), this.imageWidth - this.visibleWidth))) {
            this.canvas.update();
            this.displayMC.xOffset = n;
            this.canvas.scroll(Math.max(n2 - n, 0), 0, Math.max(n - n2, 0), 0, this.visibleWidth, this.visibleHeight, false);
        }
    }

    protected void handleResize() {
        ScrollBar scrollBar;
        this.canvas.update();
        Rectangle rectangle = this.canvas.getBounds();
        this.visibleWidth = rectangle.width;
        this.visibleHeight = rectangle.height;
        ScrollBar scrollBar2 = this.getHorizontalBar();
        if (scrollBar2 != null) {
            this.displayMC.xOffset = Math.min(scrollBar2.getSelection(), this.imageWidth - this.visibleWidth);
            if (this.imageWidth <= this.visibleWidth) {
                scrollBar2.setVisible(false);
                scrollBar2.setEnabled(false);
                scrollBar2.setSelection(0);
            } else {
                scrollBar2.setVisible(true);
                scrollBar2.setEnabled(true);
                scrollBar2.setValues(this.displayMC.xOffset, 0, this.imageWidth, this.visibleWidth, 8, this.visibleWidth);
            }
        }
        if ((scrollBar = this.getVerticalBar()) != null) {
            this.displayMC.yOffset = Math.min(scrollBar.getSelection(), this.imageHeight - this.visibleHeight);
            if (this.imageHeight <= this.visibleHeight) {
                scrollBar.setEnabled(false);
                scrollBar.setVisible(false);
                scrollBar.setSelection(0);
            } else {
                scrollBar.setEnabled(true);
                scrollBar.setVisible(true);
                scrollBar.setValues(this.displayMC.yOffset, 0, this.imageHeight, this.visibleHeight, 8, this.visibleHeight);
            }
        }
    }

    private ScrollBar getVerticalBar() {
        ScrollBar scrollBar = this.canvas.getVerticalBar();
        if (scrollBar == null) {
            scrollBar = this.canvas.getParent().getVerticalBar();
        }
        return scrollBar;
    }

    private ScrollBar getHorizontalBar() {
        ScrollBar scrollBar = this.canvas.getHorizontalBar();
        if (scrollBar == null) {
            scrollBar = this.canvas.getParent().getHorizontalBar();
        }
        return scrollBar;
    }

    private void handlePaint(PaintEvent paintEvent) {
        if (this.displayImage == null) {
            return;
        }
        int n = this.displayMC.xOffset + paintEvent.x;
        int n2 = this.displayMC.yOffset + paintEvent.y;
        n = n < 0 ? 0 : n;
        n2 = n2 < 0 ? 0 : n2;
        Rectangle rectangle = this.displayImage.getBounds();
        if (rectangle.width - n < paintEvent.width || rectangle.height - n2 < paintEvent.height) {
            this.createDisplayImage();
            this.handlePaint(paintEvent);
        } else {
            paintEvent.gc.drawImage(this.displayImage, n, n2, paintEvent.width, paintEvent.height, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
        }
    }
}

