/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.render;

import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.ui.editor.render.CanvasManager;
import org.eclipse.e4.xwt.ui.utils.ProjectContext;
import org.eclipse.e4.xwt.vex.VEXRenderer;
import org.eclipse.e4.xwt.vex.swt.ImageCapture;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWTRender
implements VEXRenderer {
    private String hostClassName;
    private CanvasManager canvasManager;
    private ProjectContext projectContext;
    private PropertyChangeListener changeListener;
    private Shell shell;
    private int time = 0;

    public XWTRender(Canvas canvas, PropertyChangeListener propertyChangeListener) {
        this.changeListener = propertyChangeListener;
        this.canvasManager = new CanvasManager(canvas);
    }

    public void dispose() {
        if (this.canvasManager != null) {
            this.canvasManager.dispose();
            this.canvasManager = null;
        }
        if (this.shell != null) {
            this.shell.dispose();
        }
    }

    public boolean updateView(String string, IFile iFile) {
        if (this.shell != null) {
            this.shell.dispose();
        }
        Control control = Display.getCurrent().getFocusControl();
        try {
            Control control2;
            ByteArrayInputStream byteArrayInputStream;
            IJavaProject iJavaProject = JavaCore.create((IProject)iFile.getProject());
            if (!iJavaProject.exists()) {
                return false;
            }
            if (this.projectContext != null) {
                this.projectContext.removePropertyChangeListener(this.changeListener);
            }
            this.projectContext = ProjectContext.getContext((IJavaProject)iJavaProject);
            XWT.setLoadingContext((ILoadingContext)this.projectContext);
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                control2 = XWT.load((InputStream)byteArrayInputStream, (URL)iFile.getLocationURI().toURL());
            }
            catch (Exception exception) {
                if (control != null) {
                    control.setFocus();
                }
                return false;
            }
            if (control2 != null) {
                Object object;
                byteArrayInputStream = new Rectangle(0, 0, 0, 0);
                Object object2 = Display.getDefault().getMonitors();
                final int n = ((Monitor[])object2).length;
                int n2 = 0;
                while (n2 < n) {
                    object = object2[n2];
                    Rectangle rectangle = object.getBounds();
                    byteArrayInputStream = byteArrayInputStream.union(rectangle);
                    ++n2;
                }
                this.shell = control2.getShell();
                this.shell.setFocus();
                this.shell.pack();
                this.shell.setLocation(((Rectangle)byteArrayInputStream).x + ((Rectangle)byteArrayInputStream).width + 200, ((Rectangle)byteArrayInputStream).y + ((Rectangle)byteArrayInputStream).height + 200);
                this.shell.open();
                object = XWT.getCLR((Widget)control2);
                if (object != null) {
                    this.hostClassName = object.getClass().getName();
                }
                ArrayList<Browser> arrayList = new ArrayList<Browser>();
                this.findBrowser(control2, arrayList);
                if (!arrayList.isEmpty()) {
                    this.time = 0;
                    n = arrayList.size();
                    object2 = new ProgressListener(){

                        public void changed(ProgressEvent progressEvent) {
                            if (XWTRender.this.canvasManager == null || XWTRender.this.shell == null || XWTRender.this.shell.isDisposed()) {
                                return;
                            }
                            Image image = ImageCapture.getImageCapture().captureImage((Control)XWTRender.this.shell);
                            XWTRender.this.canvasManager.setImage(image);
                        }

                        public void completed(ProgressEvent progressEvent) {
                            if (XWTRender.this.canvasManager == null || XWTRender.this.shell == null || XWTRender.this.shell.isDisposed()) {
                                return;
                            }
                            Image image = ImageCapture.getImageCapture().captureImage((Control)XWTRender.this.shell);
                            XWTRender.this.canvasManager.setImage(image);
                            XWTRender xWTRender = XWTRender.this;
                            xWTRender.time = xWTRender.time + 1;
                            if (XWTRender.this.time == n) {
                                XWTRender.this.shell.close();
                            }
                        }
                    };
                    for (Browser browser : arrayList) {
                        browser.addProgressListener((ProgressListener)object2);
                    }
                } else if (this.shell != null && !this.shell.isDisposed()) {
                    Image image = ImageCapture.getImageCapture().defaultCapture((Control)this.shell);
                    this.canvasManager.setImage(image);
                    this.shell.close();
                }
                this.projectContext.addPropertyChangeListener(this.changeListener);
            }
        }
        finally {
            if (control != null) {
                control.setFocus();
            }
        }
        return true;
    }

    private void findBrowser(Control control, List<Browser> list) {
        if (control instanceof Composite) {
            Control[] controlArray;
            Composite composite = (Composite)control;
            Control[] controlArray2 = controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control2 = controlArray2[n2];
                if (control2 instanceof Browser) {
                    list.add((Browser)control2);
                }
                this.findBrowser(control2, list);
                ++n2;
            }
        }
    }

    public String getHostClassName() {
        return this.hostClassName;
    }

    public void setHostClassName(String string) {
        this.hostClassName = string;
    }
}

