/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.layout;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class StackLayout_Test {
    private static Group layoutGrp;
    private static Control current;
    private static List<Control> controls;

    static {
        controls = new ArrayList<Control>();
    }

    public static void main(String[] stringArray) {
        URL uRL = StackLayout_Test.class.getResource(String.valueOf(StackLayout_Test.class.getSimpleName()) + ".xwt");
        try {
            XWT.open((URL)uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Group findGroup(Widget widget) {
        if (widget == null) {
            return null;
        }
        if (widget instanceof Composite) {
            Composite composite = (Composite)widget;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof Group && "layout".equals(((Group)control).getText())) {
                    return (Group)control;
                }
                ++n2;
            }
            return this.findGroup((Widget)composite.getParent());
        }
        if (widget instanceof Control) {
            return this.findGroup((Widget)((Control)widget).getParent());
        }
        return null;
    }

    protected void updateStackAbove(Event event) {
        Button button = (Button)event.widget;
        layoutGrp = this.findGroup((Widget)button);
        if (layoutGrp != null) {
            if (controls.isEmpty()) {
                controls.addAll(Arrays.asList(layoutGrp.getChildren()));
            }
            StackLayout stackLayout = (StackLayout)layoutGrp.getLayout();
            if (current == null) {
                current = controls.get(controls.size() - 1);
            } else {
                int n = controls.indexOf(current);
                if (n > 0) {
                    current = controls.get(n - 1);
                }
            }
            stackLayout.topControl = current;
            Label label = this.findLabel(button);
            if (label != null) {
                label.setText(((Button)current).getText());
            }
            this.layout((Composite)layoutGrp);
        }
    }

    private Label findLabel(Button button) {
        Control[] controlArray;
        Control[] controlArray2 = controlArray = button.getParent().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray2[n2];
            if (control instanceof Label) {
                return (Label)control;
            }
            ++n2;
        }
        return null;
    }

    protected void updateStackBelow(Event event) {
        Button button = (Button)event.widget;
        layoutGrp = this.findGroup((Widget)button);
        if (layoutGrp != null) {
            if (controls.isEmpty()) {
                controls.addAll(Arrays.asList(layoutGrp.getChildren()));
            }
            StackLayout stackLayout = (StackLayout)layoutGrp.getLayout();
            if (current == null) {
                current = controls.get(0);
            } else {
                int n = controls.indexOf(current);
                if (n < controls.size() - 1) {
                    current = controls.get(n + 1);
                }
            }
            stackLayout.topControl = current;
            Label label = this.findLabel(button);
            if (label != null) {
                label.setText(((Button)current).getText());
            }
            this.layout((Composite)layoutGrp);
        }
    }

    private void layout(Composite composite) {
        if (composite != null) {
            composite.layout(true, true);
            this.layout(composite.getParent());
        }
    }

    protected void updateMarginWidth(Event event) {
        Spinner spinner = (Spinner)event.widget;
        Group group = this.findGroup((Widget)spinner);
        if (group != null) {
            StackLayout stackLayout = (StackLayout)group.getLayout();
            stackLayout.marginWidth = spinner.getSelection();
            this.layout((Composite)group);
        }
    }

    protected void updateMarginHeight(Event event) {
        Spinner spinner = (Spinner)event.widget;
        Group group = this.findGroup((Widget)spinner);
        if (group != null) {
            StackLayout stackLayout = (StackLayout)group.getLayout();
            stackLayout.marginHeight = spinner.getSelection();
            this.layout((Composite)group);
        }
    }
}

