/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.swt.CSSTestCase;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ButtonTest
extends CSSTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);

    protected Button createTestButton(String string) {
        Display display = Display.getDefault();
        CSSEngine cSSEngine = this.createEngine(string, display);
        Shell shell = new Shell(display, 1264);
        FillLayout fillLayout = new FillLayout();
        shell.setLayout((Layout)fillLayout);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        Button button = new Button(composite, 0);
        button.setText("Some button text");
        cSSEngine.applyStyles((Object)shell, true);
        shell.pack();
        return button;
    }

    public void testColor() throws Exception {
        Button button = this.createTestButton("Button { background-color: #FF0000; color: #0000FF }");
        ButtonTest.assertEquals((Object)RED, (Object)button.getBackground().getRGB());
        ButtonTest.assertEquals((Object)BLUE, (Object)button.getForeground().getRGB());
    }

    public void testFontRegular() throws Exception {
        Button button = this.createTestButton("Button { font: Verdana 16px }");
        ButtonTest.assertEquals((int)1, (int)button.getFont().getFontData().length);
        FontData fontData = button.getFont().getFontData()[0];
        ButtonTest.assertEquals((String)"Verdana", (String)fontData.getName());
        ButtonTest.assertEquals((int)16, (int)fontData.getHeight());
        ButtonTest.assertEquals((int)0, (int)fontData.getStyle());
    }

    public void testFontBold() throws Exception {
        Button button = this.createTestButton("Button { font: Arial 12px; font-weight: bold }");
        ButtonTest.assertEquals((int)1, (int)button.getFont().getFontData().length);
        FontData fontData = button.getFont().getFontData()[0];
        ButtonTest.assertEquals((String)"Arial", (String)fontData.getName());
        ButtonTest.assertEquals((int)12, (int)fontData.getHeight());
        ButtonTest.assertEquals((int)1, (int)fontData.getStyle());
    }

    public void testFontItalic() throws Exception {
        Button button = this.createTestButton("Button { font-style: italic }");
        ButtonTest.assertEquals((int)1, (int)button.getFont().getFontData().length);
        FontData fontData = button.getFont().getFontData()[0];
        ButtonTest.assertEquals((int)2, (int)fontData.getStyle());
    }
}

