/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.swt.CSSTestCase;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CTabFolderTest
extends CSSTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final RGB WHITE = new RGB(255, 255, 255);
    public static CSSEngine engine;

    protected CTabFolder createTestCTabFolder(String string) {
        Display display = Display.getDefault();
        engine = this.createEngine(string, display);
        Shell shell = new Shell(display, 1264);
        FillLayout fillLayout = new FillLayout();
        shell.setLayout((Layout)fillLayout);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        CTabFolder cTabFolder = new CTabFolder(composite, 0);
        CTabItem cTabItem = new CTabItem(cTabFolder, 0);
        cTabItem.setText("A TAB ITEM");
        engine.applyStyles((Object)shell, true);
        shell.pack();
        return cTabFolder;
    }

    protected Shell createShell(String string) {
        Display display = Display.getDefault();
        engine = this.createEngine(string, display);
        Shell shell = new Shell(display, 0);
        engine.applyStyles((Object)shell, true);
        shell.pack();
        return shell;
    }

    public void testBackgroundColor() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { background-color: #0000FF }");
        CTabFolderTest.assertEquals((Object)BLUE, (Object)cTabFolder.getBackground().getRGB());
    }

    public void testTextColor() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { color: #0000FF }");
        CTabFolderTest.assertEquals((Object)BLUE, (Object)cTabFolder.getForeground().getRGB());
    }

    public void testSelectedPseudo() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { color: #FFFFFF; background-color: #0000FF }\nCTabFolder:selected { color: #FF0000;  background-color: #00FF00 }");
        CTabFolderTest.assertEquals((Object)WHITE, (Object)cTabFolder.getForeground().getRGB());
        CTabFolderTest.assertEquals((Object)BLUE, (Object)cTabFolder.getBackground().getRGB());
        CTabFolderTest.assertEquals((Object)RED, (Object)cTabFolder.getSelectionForeground().getRGB());
        CTabFolderTest.assertEquals((Object)GREEN, (Object)cTabFolder.getSelectionBackground().getRGB());
    }

    public void testFontRegular() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { font: Verdana 16px }");
        CTabFolderTest.assertEquals((int)1, (int)cTabFolder.getFont().getFontData().length);
        FontData fontData = cTabFolder.getFont().getFontData()[0];
        CTabFolderTest.assertEquals((String)"Verdana", (String)fontData.getName());
        CTabFolderTest.assertEquals((int)16, (int)fontData.getHeight());
        CTabFolderTest.assertEquals((int)0, (int)fontData.getStyle());
    }

    public void testFontBold() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { font: Arial 12px; font-weight: bold }");
        CTabFolderTest.assertEquals((int)1, (int)cTabFolder.getFont().getFontData().length);
        FontData fontData = cTabFolder.getFont().getFontData()[0];
        CTabFolderTest.assertEquals((String)"Arial", (String)fontData.getName());
        CTabFolderTest.assertEquals((int)12, (int)fontData.getHeight());
        CTabFolderTest.assertEquals((int)1, (int)fontData.getStyle());
    }

    public void testFontItalic() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { font: Arial 12px; font-style: italic }");
        CTabFolderTest.assertEquals((int)1, (int)cTabFolder.getFont().getFontData().length);
        FontData fontData = cTabFolder.getFont().getFontData()[0];
        CTabFolderTest.assertEquals((String)"Arial", (String)fontData.getName());
        CTabFolderTest.assertEquals((int)12, (int)fontData.getHeight());
        CTabFolderTest.assertEquals((int)2, (int)fontData.getStyle());
    }

    public void testBorderVisible() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { border-visible: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)cTabFolder.getBorderVisible());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)cTabFolder, "border-visible", null));
        cTabFolder.getShell().close();
        cTabFolder = this.createTestCTabFolder("CTabFolder { border-visible: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)cTabFolder.getBorderVisible());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)cTabFolder, "border-visible", null));
    }

    public void testSimple() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { simple: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)cTabFolder.getSimple());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)cTabFolder, "simple", null));
        cTabFolder.getShell().close();
        cTabFolder = this.createTestCTabFolder("CTabFolder { simple: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)cTabFolder.getSimple());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)cTabFolder, "simple", null));
    }

    public void testMaximizeVisible() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { maximize-visible: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)cTabFolder.getMaximizeVisible());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)cTabFolder, "maximize-visible", null));
        cTabFolder.getShell().close();
        cTabFolder = this.createTestCTabFolder("CTabFolder { maximize-visible: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)cTabFolder.getMaximizeVisible());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)cTabFolder, "maximize-visible", null));
    }

    public void testMinimizeVisible() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { minimize-visible: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)cTabFolder.getMinimizeVisible());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)cTabFolder, "minimize-visible", null));
        cTabFolder.getShell().close();
        cTabFolder = this.createTestCTabFolder("CTabFolder { minimize-visible: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)cTabFolder.getMinimizeVisible());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)cTabFolder, "minimize-visible", null));
    }

    public void testMRUVisible() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { mru-visible: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)cTabFolder.getMRUVisible());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)cTabFolder, "mru-visible", null));
        cTabFolder.getShell().close();
        cTabFolder = this.createTestCTabFolder("CTabFolder { mru-visible: false}");
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)cTabFolder, "mru-visible", null));
        CTabFolderTest.assertEquals((boolean)false, (boolean)cTabFolder.getMRUVisible());
    }

    public void testMaximized() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { maximized: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)cTabFolder.getMaximized());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)cTabFolder, "maximized", null));
        cTabFolder = this.createTestCTabFolder("CTabFolder { maximized: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)cTabFolder.getMaximized());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)cTabFolder, "maximized", null));
    }

    public void testMinimized() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { minimized: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)cTabFolder.getMinimized());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)cTabFolder, "minimized", null));
        cTabFolder = this.createTestCTabFolder("CTabFolder { minimized: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)cTabFolder.getMinimized());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)cTabFolder, "minimized", null));
    }

    public void testSingle() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { single: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)cTabFolder.getSingle());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)cTabFolder, "single", null));
        cTabFolder = this.createTestCTabFolder("CTabFolder { single: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)cTabFolder.getSingle());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)cTabFolder, "single", null));
    }

    public void testShowClose() throws Exception {
        CTabItem cTabItem;
        CTabItem[] cTabItemArray;
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { show-close: true}");
        CTabItem[] cTabItemArray2 = cTabItemArray = cTabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            cTabItem = cTabItemArray2[n2];
            CTabFolderTest.assertEquals((boolean)true, (boolean)cTabItem.getShowClose());
            ++n2;
        }
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)cTabFolder, "show-close", null));
        cTabFolder = this.createTestCTabFolder("CTabFolder { show-close: false}");
        cTabItemArray2 = cTabItemArray = cTabFolder.getItems();
        n = cTabItemArray.length;
        n2 = 0;
        while (n2 < n) {
            cTabItem = cTabItemArray2[n2];
            CTabFolderTest.assertEquals((boolean)false, (boolean)cTabItem.getShowClose());
            ++n2;
        }
        CTabFolderTest.assertEquals((boolean)false, (boolean)cTabFolder.getSingle());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)cTabFolder, "show-close", null));
    }

    public void testUnselectedCloseVisible() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { unselected-close-visible: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)cTabFolder.getUnselectedCloseVisible());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)cTabFolder, "unselected-close-visible", null));
        cTabFolder = this.createTestCTabFolder("CTabFolder { unselected-close-visible: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)cTabFolder.getUnselectedCloseVisible());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)cTabFolder, "unselected-close-visible", null));
    }

    public void testUnselectedImageVisible() throws Exception {
        CTabFolder cTabFolder = this.createTestCTabFolder("CTabFolder { unselected-image-visible: true}");
        CTabFolderTest.assertEquals((boolean)true, (boolean)cTabFolder.getUnselectedImageVisible());
        CTabFolderTest.assertEquals((String)"true", (String)engine.retrieveCSSProperty((Object)cTabFolder, "unselected-image-visible", null));
        cTabFolder = this.createTestCTabFolder("CTabFolder { unselected-image-visible: false}");
        CTabFolderTest.assertEquals((boolean)false, (boolean)cTabFolder.getUnselectedImageVisible());
        CTabFolderTest.assertEquals((String)"false", (String)engine.retrieveCSSProperty((Object)cTabFolder, "unselected-image-visible", null));
    }

    public void testRetrievePropertyNull() {
        Shell shell = this.createShell("Shell {color:red}");
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "border-visible", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "maximized", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "maximize-visible", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "minimize-visible", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "mru-visible", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "show-close", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "simple", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "single", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "unselected-close-visible", null));
        CTabFolderTest.assertEquals(null, (String)engine.retrieveCSSProperty((Object)shell, "unselected-image-visible", null));
    }
}

