/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.SWTElement;
import org.eclipse.e4.ui.tests.css.swt.CSSTestCase;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class IdClassLabelColorTest
extends CSSTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final String CSS_CLASS_NAME = "makeItGreenClass";
    static final String CSS_ID = "makeItBlueID";

    protected Label createTestLabel(String string) {
        Display display = Display.getDefault();
        CSSEngine cSSEngine = this.createEngine(string, display);
        Shell shell = new Shell(display, 1264);
        FillLayout fillLayout = new FillLayout();
        shell.setLayout((Layout)fillLayout);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        Label label = new Label(composite, 0);
        label.setText("Some label text");
        SWTElement.setCSSClass((Widget)label, (String)CSS_CLASS_NAME);
        SWTElement.setID((Widget)label, (String)CSS_ID);
        cSSEngine.applyStyles((Object)shell, true);
        shell.pack();
        return label;
    }

    public void testWidgetClass() throws Exception {
        Label label = this.createTestLabel("Label { background-color: #FF0000 }");
        IdClassLabelColorTest.assertEquals((Object)RED, (Object)label.getBackground().getRGB());
    }

    public void testCssClass() throws Exception {
        Label label = this.createTestLabel(".makeItGreenClass { background-color: #00FF00 }");
        IdClassLabelColorTest.assertEquals((String)SWTElement.getCSSClass((Widget)label), (String)CSS_CLASS_NAME);
        IdClassLabelColorTest.assertEquals((Object)GREEN, (Object)label.getBackground().getRGB());
    }

    public void testWidgetId() throws Exception {
        Label label = this.createTestLabel("#makeItBlueID { background-color: #0000FF }");
        IdClassLabelColorTest.assertEquals((String)SWTElement.getID((Widget)label), (String)CSS_ID);
        IdClassLabelColorTest.assertEquals((Object)BLUE, (Object)label.getBackground().getRGB());
    }
}

