/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.swt.CSSTestCase;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LabelTest
extends CSSTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);

    protected Label createTestLabel(String string) {
        Display display = Display.getDefault();
        CSSEngine cSSEngine = this.createEngine(string, display);
        Shell shell = new Shell(display, 1264);
        FillLayout fillLayout = new FillLayout();
        shell.setLayout((Layout)fillLayout);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        Label label = new Label(composite, 0);
        label.setText("Some label text");
        cSSEngine.applyStyles((Object)shell, true);
        shell.pack();
        return label;
    }

    public void testColor() throws Exception {
        Label label = this.createTestLabel("Label { background-color: #FF0000; color: #0000FF }");
        LabelTest.assertEquals((Object)RED, (Object)label.getBackground().getRGB());
        LabelTest.assertEquals((Object)BLUE, (Object)label.getForeground().getRGB());
    }

    public void testFontRegular() throws Exception {
        Label label = this.createTestLabel("Label { font: Verdana 16px }");
        LabelTest.assertEquals((int)1, (int)label.getFont().getFontData().length);
        FontData fontData = label.getFont().getFontData()[0];
        LabelTest.assertEquals((String)"Verdana", (String)fontData.getName());
        LabelTest.assertEquals((int)16, (int)fontData.getHeight());
        LabelTest.assertEquals((int)0, (int)fontData.getStyle());
    }

    public void testFontBold() throws Exception {
        Label label = this.createTestLabel("Label { font: Arial 12px; font-weight: bold }");
        LabelTest.assertEquals((int)1, (int)label.getFont().getFontData().length);
        FontData fontData = label.getFont().getFontData()[0];
        LabelTest.assertEquals((String)"Arial", (String)fontData.getName());
        LabelTest.assertEquals((int)12, (int)fontData.getHeight());
        LabelTest.assertEquals((int)1, (int)fontData.getStyle());
    }

    public void testFontItalic() throws Exception {
        Label label = this.createTestLabel("Label { font-style: italic }");
        LabelTest.assertEquals((int)1, (int)label.getFont().getFontData().length);
        FontData fontData = label.getFont().getFontData()[0];
        LabelTest.assertEquals((int)2, (int)fontData.getStyle());
    }
}

