/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.swt.CSSTestCase;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ShellTest
extends CSSTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);

    protected Shell createTestShell(String string) {
        Display display = Display.getDefault();
        CSSEngine cSSEngine = this.createEngine(string, display);
        Shell shell = new Shell(display, 1264);
        FillLayout fillLayout = new FillLayout();
        shell.setLayout((Layout)fillLayout);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new FillLayout());
        cSSEngine.applyStyles((Object)shell, true);
        shell.pack();
        return shell;
    }

    public void testColor() throws Exception {
        Shell shell = this.createTestShell("Shell { background-color: #FF0000; color: #0000FF }");
        ShellTest.assertEquals((Object)RED, (Object)shell.getBackground().getRGB());
        ShellTest.assertEquals((Object)BLUE, (Object)shell.getForeground().getRGB());
    }

    public void testFontRegular() throws Exception {
        Shell shell = this.createTestShell("Shell { font: Verdana 16px }");
        ShellTest.assertEquals((int)1, (int)shell.getFont().getFontData().length);
        FontData fontData = shell.getFont().getFontData()[0];
        ShellTest.assertEquals((String)"Verdana", (String)fontData.getName());
        ShellTest.assertEquals((int)16, (int)fontData.getHeight());
        ShellTest.assertEquals((int)0, (int)fontData.getStyle());
    }

    public void testFontBold() throws Exception {
        Shell shell = this.createTestShell("Shell { font: Arial 12px; font-weight: bold }");
        ShellTest.assertEquals((int)1, (int)shell.getFont().getFontData().length);
        FontData fontData = shell.getFont().getFontData()[0];
        ShellTest.assertEquals((String)"Arial", (String)fontData.getName());
        ShellTest.assertEquals((int)12, (int)fontData.getHeight());
        ShellTest.assertEquals((int)1, (int)fontData.getStyle());
    }

    public void testFontItalic() throws Exception {
        Shell shell = this.createTestShell("Shell { font-style: italic }");
        ShellTest.assertEquals((int)1, (int)shell.getFont().getFontData().length);
        FontData fontData = shell.getFont().getFontData()[0];
        ShellTest.assertEquals((int)2, (int)fontData.getStyle());
    }
}

