/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.swt.tools.actionscript.build.ActionScriptCompilerManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

public class ActionScriptCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.swt.tools.actionscript.core";
    public static final String PREF_ENABLE_DEBUG_CHECK = "org.eclipse.swt.tools.actionscript.core.enabledebug";
    public static final String PREF_SHOW_ACTIONSCRIPT_ERRORS = "org.eclipse.swt.tools.actionscript.core.showaserrors";
    public static final String PREF_SWC_PATH = "org.eclipse.swt.tools.actionscript.core.swcpath";
    private static ActionScriptCorePlugin plugin;
    public static final int PORT = 7777;
    public static final String LAUNCH_URL = "http://localhost:7777/actionscript?path=";
    public static boolean DEPLOY;
    public static String DEPLOY_URL;
    public static boolean CROSS_DOMAIN;
    public static String CROSS_DOMAIN_URL;
    public static boolean THEME;
    public static String THEME_URL;
    ActionScriptCompilerManager manager;

    static {
        DEPLOY = false;
        DEPLOY_URL = "";
        CROSS_DOMAIN = false;
        CROSS_DOMAIN_URL = "";
        THEME = false;
        THEME_URL = "";
    }

    public ActionScriptCompilerManager getManager() {
        return this.manager;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.manager = new ActionScriptCompilerManager();
        this.startJCL();
        this.startJetty();
    }

    void startJetty() throws Exception {
        Hashtable<String, Constable> hashtable = new Hashtable<String, Constable>();
        hashtable.put("http.port", new Integer(7777));
        hashtable.put("http.enabled", new Boolean(true));
        Logger.getLogger("org.mortbay").setLevel(Level.WARNING);
        JettyConfigurator.startServer((String)PLUGIN_ID, hashtable);
        ActionScriptCorePlugin.checkBundle();
    }

    void startJCL() {
        File file = this.getJCLLocation().toFile();
        System.err.println("startJCL: " + file);
        if (!file.exists()) {
            System.err.println("finished extraction: " + ActionScriptCorePlugin.extract(file.getAbsolutePath(), "jre/actionscriptJCL.jar"));
        }
    }

    static boolean extract(String string, String string2) {
        System.err.println("extract: " + string + ", " + string2);
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        File file = new File(string);
        try {
            if (!file.exists()) {
                System.err.println("extract: does not exist");
                inputStream = ActionScriptCorePlugin.class.getResourceAsStream("/" + string2);
                System.err.println("extract: is == " + inputStream);
                if (inputStream != null) {
                    int n;
                    byte[] byArray = new byte[4096];
                    fileOutputStream = new FileOutputStream(string);
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.close();
                    inputStream.close();
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            ActionScriptCorePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Failed to copy out JCL jar", throwable));
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            return false;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
        JettyConfigurator.stopServer((String)PLUGIN_ID);
        this.manager.stop();
    }

    public static ActionScriptCorePlugin getDefault() {
        return plugin;
    }

    public IPath getJCLLocation() {
        IPath iPath = ActionScriptCorePlugin.getDefault().getStateLocation();
        return iPath.append("actionscriptJCL.jar");
    }

    private static void checkBundle() throws InvalidSyntaxException, BundleException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.equinox.http.registry");
        if (bundle.getState() == 4) {
            bundle.start(1);
        }
    }
}

