/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.swt.tools.actionscript.ActionScriptCorePlugin;
import org.eclipse.swt.tools.actionscript.build.IActionScriptConsole;

public class ActionScriptCompilerManager {
    IActionScriptConsole console;
    Pattern errorPattern = Pattern.compile("\\((\\d+)\\)\\: col\\: (\\d+) (.*): ((.*))");
    ActionScriptCompilerReader output_reader;
    ActionScriptCompilerReader error_reader;
    ActionScriptCompilerWriter writer;
    String result;
    boolean outOfMemory;
    int currentJob;
    StringBuffer resultBuffer = new StringBuffer();
    Process fcsh;

    public ActionScriptCompilerManager() {
        this.reset();
    }

    public synchronized void reset() {
        this.stop();
        String string = String.valueOf(System.getProperty("flex.sdk")) + File.separator + "bin" + File.separator + "fcsh.exe";
        try {
            this.fcsh = DebugPlugin.exec((String[])new String[]{string}, null);
            this.output_reader = new ActionScriptCompilerReader(this, this.fcsh.getInputStream(), false);
            this.writer = new ActionScriptCompilerWriter(this.fcsh);
            this.error_reader = new ActionScriptCompilerReader(this, this.fcsh.getErrorStream(), true);
            this.output_reader.startUp();
            this.error_reader.startUp();
            this.writer.startUp();
        }
        catch (CoreException coreException) {
            ActionScriptCorePlugin.getDefault().getLog().log(coreException.getStatus());
            coreException.printStackTrace();
        }
    }

    public synchronized void stop() {
        if (this.fcsh != null) {
            this.fcsh.destroy();
        }
        if (this.output_reader != null) {
            this.output_reader = null;
        }
        if (this.writer != null) {
            this.writer = null;
        }
        if (this.error_reader != null) {
            this.error_reader = null;
        }
    }

    public synchronized String sendCommand(String string) {
        this.result = null;
        this.outOfMemory = false;
        this.resultBuffer = new StringBuffer();
        this.writer.sendCommand(string);
        if (this.console != null) {
            this.appendToConsole(string, false);
            this.appendToConsole(System.getProperty("line.separator"), false);
        }
        while (this.result == null) {
            try {
                this.wait();
                if (!this.outOfMemory) continue;
                return null;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return this.result;
    }

    public synchronized void appendLine(String string, boolean bl) {
        this.resultBuffer.append(string);
        this.appendToConsole(string, bl);
        if (bl) {
            this.outOfMemory = this.checkOutOfMemory(string);
            if (this.outOfMemory) {
                this.endCommand();
            } else {
                this.parseErrorOutput(string);
            }
        }
    }

    private boolean checkOutOfMemory(String string) {
        if (string.startsWith("java.lang.OutOfMemory")) {
            this.reset();
            return true;
        }
        return false;
    }

    synchronized void appendToConsole(String string, boolean bl) {
        if (this.console != null) {
            this.console.appendText(string, bl);
        }
    }

    public synchronized void endCommand() {
        this.result = this.resultBuffer.toString();
        this.notifyAll();
    }

    public void setConsole(IActionScriptConsole iActionScriptConsole) {
        this.console = iActionScriptConsole;
    }

    void parseErrorOutput(String string) {
        String string2;
        IResource iResource;
        IWorkspaceRoot iWorkspaceRoot;
        String string3;
        String string4;
        Matcher matcher = this.errorPattern.matcher(string);
        if (matcher.find() && (string4 = string.substring(0, matcher.start())).startsWith(string3 = (iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).getLocation().toOSString()) && (iResource = iWorkspaceRoot.findMember(string2 = string4.substring(string3.length()))) != null) {
            try {
                IMarker iMarker = iResource.createMarker("org.eclipse.core.resources.problemmarker");
                iMarker.setAttribute("message", (Object)("[AS]: " + matcher.group(4)));
                iMarker.setAttribute("severity", matcher.group(3).equals("Error") ? 2 : 1);
                iMarker.setAttribute("lineNumber", Integer.parseInt(matcher.group(1)));
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }

    class ActionScriptCompilerReader
    implements Runnable {
        Thread fcshThread;
        BufferedReader reader;
        ActionScriptCompilerManager manager;
        boolean isErrorStream;

        public ActionScriptCompilerReader(ActionScriptCompilerManager actionScriptCompilerManager2, InputStream inputStream, boolean bl) {
            this.manager = actionScriptCompilerManager2;
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
            this.isErrorStream = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.fcshThread != null) {
                ActionScriptCompilerReader actionScriptCompilerReader = this;
                synchronized (actionScriptCompilerReader) {
                    try {
                        int n;
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((n = this.reader.read()) != -1) {
                            stringBuffer.append((char)n);
                            if (n == 10) {
                                this.manager.appendLine(stringBuffer.toString(), this.isErrorStream);
                            } else {
                                if (stringBuffer.indexOf("(fcsh) ") != 0) continue;
                                this.manager.appendLine(stringBuffer.toString(), this.isErrorStream);
                                this.manager.endCommand();
                            }
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }

        public void startUp() {
            this.fcshThread = new Thread((Runnable)this, "Flex Compiler Shell Reader Thread");
            this.fcshThread.setDaemon(true);
            this.fcshThread.setPriority(4);
            this.fcshThread.start();
        }
    }

    class ActionScriptCompilerWriter
    implements Runnable {
        Thread fcshThread;
        Process fcshProcess;
        PrintWriter writer;
        LinkedList jobs = new LinkedList();

        public ActionScriptCompilerWriter(Process process) {
            this.fcshProcess = process;
            this.writer = new PrintWriter(new OutputStreamWriter(process.getOutputStream()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.fcshThread != null) {
                ActionScriptCompilerWriter actionScriptCompilerWriter = this;
                synchronized (actionScriptCompilerWriter) {
                    try {
                        if (this.jobs.isEmpty()) {
                            Thread.sleep(50L);
                        } else {
                            String string = (String)this.jobs.removeFirst();
                            this.writer.println(string);
                            this.writer.flush();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }

        public void startUp() {
            this.fcshThread = new Thread((Runnable)this, "Flex Compiler Shell Writer Thread");
            this.fcshThread.setDaemon(true);
            this.fcshThread.setPriority(4);
            this.fcshThread.start();
        }

        public void sendCommand(String string) {
            this.jobs.add(string);
        }
    }
}

