/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.build;

import flash.tools.debugger.Bootstrap;
import flash.tools.debugger.IDebuggerCallbacks;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SessionManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.tools.actionscript.ActionScriptCorePlugin;
import org.eclipse.swt.tools.actionscript.build.ActionScriptVMInstallType;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptDebugEventDispatcher;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptDebugTarget;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptDebuggerCallbacks;

public class ActionScriptLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public static final String ACTIONSCRIPT_APP = "org.eclipse.swt.tools.actionscript.core.actionscriptApplication";
    public static final String ATTR_PROJECT_NAME = IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME;
    public static final String ATTR_MAIN_TYPE_NAME = IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME;
    public static final String ATTR_OUTPUT_DIR_NAME = "org.eclipse.swt.tools.actionscript.core.outputDirName";
    public static final String ATTR_STATIC_LINK_OPTION = "org.eclipse.swt.tools.actionscript.core.linkOption";
    public static final String ATTR_COMPILE_ID = "org.eclipse.swt.tools.actionscript.core.compileId";
    public static final String ATTR_THEME_OPTION = "org.eclipse.swt.tools.actionscript.core.themeOption";
    public static final String ATTR_THEME_PATH = "org.eclipse.swt.tools.actionscript.core.themePath";

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        String string2 = iLaunchConfiguration.getAttribute(ATTR_PROJECT_NAME, "");
        String string3 = iLaunchConfiguration.getAttribute(ATTR_MAIN_TYPE_NAME, "");
        String string4 = iLaunchConfiguration.getAttribute(ATTR_OUTPUT_DIR_NAME, "");
        boolean bl = iLaunchConfiguration.getAttribute(ATTR_STATIC_LINK_OPTION, false);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = (IProject)iWorkspaceRoot.findMember(string2);
        if (iProject == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Problem Launching : Project doesn't exist"));
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        IType iType = iJavaProject.findType(string3);
        if (iType == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Problem Launching : Main class doesn't exist"));
        }
        ActionScriptCorePlugin.DEPLOY = false;
        ActionScriptCorePlugin.CROSS_DOMAIN = false;
        ActionScriptCorePlugin.THEME = iLaunchConfiguration.getAttribute(ATTR_THEME_OPTION, false);
        if (ActionScriptCorePlugin.THEME) {
            ActionScriptCorePlugin.THEME_URL = iLaunchConfiguration.getAttribute(ATTR_THEME_PATH, "");
        }
        this.generateSWFFiles(iJavaProject, string3, string4);
        this.buildSWF(iJavaProject, string3, string4, iLaunchConfiguration, bl);
        File file = new File(String.valueOf(iJavaProject.getProject().getLocation().toOSString()) + File.separator + string4);
        String string5 = String.valueOf(file.getAbsolutePath()) + File.separator + this.getClassName(string3) + ".html";
        IVMInstall iVMInstall = JavaRuntime.computeVMInstall((ILaunchConfiguration)iLaunchConfiguration);
        IVMInstallType iVMInstallType = iVMInstall.getVMInstallType();
        if (iVMInstallType instanceof ActionScriptVMInstallType) {
            ActionScriptVMInstallType actionScriptVMInstallType = (ActionScriptVMInstallType)iVMInstallType;
            String string6 = actionScriptVMInstallType.getExecutable(iVMInstall.getInstallLocation());
            if (string6 != null) {
                String string7 = "http://localhost:7777/actionscript?path=" + new Path(string5).toPortableString();
                if (string.equals("debug")) {
                    SessionManager sessionManager = Bootstrap.sessionManager();
                    sessionManager.setDebuggerCallbacks((IDebuggerCallbacks)new ActionScriptDebuggerCallbacks(iVMInstallType.getName(), string6));
                    try {
                        sessionManager.startListening();
                        Session session = sessionManager.launch(string7, null, true, null);
                        session.bind();
                        session.resume();
                        ActionScriptDebugTarget actionScriptDebugTarget = new ActionScriptDebugTarget(session, iLaunch, string3, string6);
                        iLaunch.addDebugTarget((IDebugTarget)actionScriptDebugTarget);
                        iLaunch.addProcess((IProcess)actionScriptDebugTarget.process);
                        new ActionScriptDebugEventDispatcher(actionScriptDebugTarget).schedule();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    catch (PlayerDebugException playerDebugException) {
                        playerDebugException.printStackTrace();
                    }
                } else {
                    Process process = DebugPlugin.exec((String[])new String[]{string6, string7}, (File)file);
                    DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)string3);
                }
                return;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Unable to find SWF VM."));
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Invalid JRE type for ActionScript application."));
    }

    public void generateSWF(IJavaProject iJavaProject, String string, String string2, ILaunchConfiguration iLaunchConfiguration, boolean bl) throws CoreException {
        this.buildSWF(iJavaProject, string, string2, iLaunchConfiguration, bl);
    }

    void buildSWF(IJavaProject iJavaProject, String string, String string2, ILaunchConfiguration iLaunchConfiguration, boolean bl) throws CoreException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("mxmlc -debug=");
            IPreferencesService iPreferencesService = Platform.getPreferencesService();
            boolean bl2 = iPreferencesService.getBoolean("org.eclipse.swt.tools.actionscript.core", "org.eclipse.swt.tools.actionscript.core.enabledebug", false, null);
            stringBuffer.append((Object)bl2);
            stringBuffer.append(" ");
            stringBuffer.append("-use-network=true");
            if (!bl) {
                stringBuffer.append(" -runtime-shared-library-path=");
                object6 = System.getProperty("flex.sdk");
                object5 = new Path(String.valueOf(object6) + "/frameworks/libs/framework.swc").toOSString();
                stringBuffer.append((String)object5);
                String string3 = this.findRSL((String)object6, ".swf");
                object4 = this.findRSL((String)object6, ".swz");
                if (object4 != null) {
                    stringBuffer.append(",");
                    stringBuffer.append(ActionScriptCorePlugin.DEPLOY ? ActionScriptCorePlugin.DEPLOY_URL : "http://localhost:7777/actionscript?path=");
                    stringBuffer.append(((String)object4).replace(File.separatorChar, '/'));
                    stringBuffer.append(",");
                }
                stringBuffer.append(",");
                stringBuffer.append(ActionScriptCorePlugin.DEPLOY ? "" : "http://localhost:7777/actionscript?path=");
                stringBuffer.append(string3.replace(File.separatorChar, '/'));
                if (ActionScriptCorePlugin.CROSS_DOMAIN) {
                    stringBuffer.append(",");
                    stringBuffer.append(ActionScriptCorePlugin.CROSS_DOMAIN_URL);
                }
            }
            object6 = iJavaProject.getProject();
            object5 = iJavaProject.getRawClasspath();
            int n = 0;
            while (n < ((IClasspathEntry[])object5).length) {
                object4 = object5[n];
                if (object4.getEntryKind() == 5 && object4.getPath().toPortableString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                    object3 = iJavaProject.getProject().getWorkspace().getRoot();
                    object2 = (IProject)object3.findMember("org.eclipse.swt.e4.jcl");
                    if (object2 != null && object2.isOpen()) {
                        this.appendLibrary(stringBuffer, bl, (IProject)object2, (IProject)object6, string2);
                    } else {
                        this.appendLibrary(stringBuffer, bl, ActionScriptCorePlugin.getDefault().getJCLLocation(), (IProject)object6, string2);
                    }
                }
                ++n;
            }
            n = 0;
            while (n < ((IClasspathEntry[])object5).length) {
                object4 = object5[n];
                object3 = object4.getPath();
                int n2 = object4.getEntryKind();
                switch (n2) {
                    case 3: {
                        break;
                    }
                    case 2: {
                        object = object6.getWorkspace().getRoot();
                        IClasspathEntry[] iClasspathEntryArray = (IClasspathEntry[])object.findMember(object3);
                        this.appendLibrary(stringBuffer, bl, (IProject)iClasspathEntryArray, (IProject)object6, string2);
                        break;
                    }
                    case 4: {
                        object = JavaCore.getResolvedClasspathEntry((IClasspathEntry)object4);
                        this.appendLibrary(stringBuffer, bl, object.getPath(), (IProject)object6, string2);
                        break;
                    }
                    case 1: {
                        this.appendLibrary(stringBuffer, bl, (IPath)object3, (IProject)object6, string2);
                        break;
                    }
                    case 5: {
                        if (object3.toPortableString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) break;
                        object = JavaCore.getClasspathContainer((IPath)object3, (IJavaProject)iJavaProject);
                        IClasspathEntry[] iClasspathEntryArray = object.getClasspathEntries();
                        int n3 = 0;
                        while (n3 < iClasspathEntryArray.length) {
                            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n3];
                            if (iClasspathEntry.getEntryKind() == 2) {
                                IWorkspaceRoot iWorkspaceRoot = iJavaProject.getProject().getWorkspace().getRoot();
                                IProject iProject = (IProject)iWorkspaceRoot.findMember(iClasspathEntry.getPath());
                                this.appendLibrary(stringBuffer, bl, iProject, (IProject)object6, string2);
                            } else {
                                this.appendLibrary(stringBuffer, bl, iClasspathEntryArray[n3].getPath(), (IProject)object6, string2);
                            }
                            ++n3;
                        }
                        break;
                    }
                }
                ++n;
            }
            this.appendLibrary(stringBuffer, bl, (IProject)object6, (IProject)object6, string2);
            if (ActionScriptCorePlugin.THEME) {
                stringBuffer.append(" ");
                stringBuffer.append("-theme=");
                stringBuffer.append(ActionScriptCorePlugin.THEME_URL);
            }
            stringBuffer.append(" ");
            if (ActionScriptCorePlugin.DEPLOY) {
                stringBuffer.append(String.valueOf(string2) + File.separator);
            } else {
                stringBuffer.append(String.valueOf(object6.getLocation().toOSString()) + File.separator + string2 + File.separator);
            }
            String string4 = this.getClassName(string);
            stringBuffer.append(string4);
            stringBuffer.append("M.mxml");
            int n4 = 0;
            object3 = null;
            do {
                object2 = stringBuffer.toString();
                if (iLaunchConfiguration == null || (object = iLaunchConfiguration.getAttribute(ATTR_COMPILE_ID, null)) == null || !this.parseInfo((String)(object3 = ActionScriptCorePlugin.getDefault().getManager().sendCommand("info " + object))).equals(object2)) continue;
                object2 = "compile " + object;
            } while ((object3 = ActionScriptCorePlugin.getDefault().getManager().sendCommand((String)object2)) == null && n4++ < 3);
            if (object3 == null) {
                throw new Exception("Out of Memory");
            }
            object2 = this.parseID((String)object3);
            if (iLaunchConfiguration != null && object2 != null) {
                object = iLaunchConfiguration.getWorkingCopy();
                object.setAttribute(ATTR_COMPILE_ID, (String)object2);
                iLaunchConfiguration = object.doSave();
            }
            if (!ActionScriptCorePlugin.DEPLOY) {
                object6.findMember((IPath)new Path(String.valueOf(string2) + File.separator + string4 + "M.mxml")).delete(true, null);
                object6.findMember((IPath)new Path(string2)).refreshLocal(2, null);
            }
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Problem compiling SWC", (Throwable)exception));
        }
    }

    void appendLibrary(StringBuffer stringBuffer, boolean bl, IPath iPath, IProject iProject, String string) throws CoreException, IOException {
        File file;
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        String string2 = iPreferencesService.getString("org.eclipse.swt.tools.actionscript.core", "org.eclipse.swt.tools.actionscript.core.swcpath", null, null);
        if (string2 == null || string2.length() == 0) {
            return;
        }
        String string3 = iPath.lastSegment();
        int n = string3.lastIndexOf(46);
        if (n != -1) {
            string3 = string3.substring(0, n);
        }
        if ((file = new File(String.valueOf(string2) + File.separator + string3 + ".swc")).exists()) {
            stringBuffer.append(bl ? " -library-path+=" : " -runtime-shared-library-path+=");
            String string4 = file.getAbsolutePath();
            stringBuffer.append(string4);
            if (!bl) {
                String string5 = String.valueOf(iProject.getLocation().toOSString()) + File.separator + string + File.separator + string3 + ".swf";
                this.extractSWF(string4, string, String.valueOf(string3) + ".swf", iProject);
                stringBuffer.append(",");
                stringBuffer.append(ActionScriptCorePlugin.DEPLOY ? ActionScriptCorePlugin.DEPLOY_URL : "http://localhost:7777/actionscript?path=");
                stringBuffer.append(new Path(string5).toPortableString());
            }
        }
    }

    void appendLibrary(StringBuffer stringBuffer, boolean bl, IProject iProject, IProject iProject2, String string) throws CoreException, IOException {
        stringBuffer.append(bl ? " -library-path+=" : " -runtime-shared-library-path+=");
        String string2 = String.valueOf(iProject.getLocation().toOSString()) + File.separator + ".buildas" + File.separator + iProject.getName() + ".swc";
        stringBuffer.append(string2);
        if (!bl) {
            String string3 = String.valueOf(iProject2.getLocation().toOSString()) + File.separator + string + File.separator + iProject.getName() + ".swf";
            this.extractSWF(string2, string, String.valueOf(iProject.getName()) + ".swf", iProject2);
            stringBuffer.append(",");
            if (ActionScriptCorePlugin.DEPLOY) {
                stringBuffer.append(String.valueOf(iProject.getName()) + ".swf");
            } else {
                stringBuffer.append("http://localhost:7777/actionscript?path=");
                stringBuffer.append(new Path(string3).toPortableString());
            }
            if (ActionScriptCorePlugin.CROSS_DOMAIN) {
                stringBuffer.append(",");
                stringBuffer.append(ActionScriptCorePlugin.CROSS_DOMAIN_URL);
            }
        }
    }

    private void extractSWF(String string, String string2, String string3, IProject iProject) throws CoreException, IOException {
        InputStream inputStream = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(string);
            ZipEntry zipEntry = zipFile.getEntry("library.swf");
            inputStream = zipFile.getInputStream(zipEntry);
            if (ActionScriptCorePlugin.DEPLOY) {
                ActionScriptLaunchConfigurationDelegate.exportFile(string2, string3, inputStream);
            } else {
                ActionScriptLaunchConfigurationDelegate.createFile(iProject, string2, string3, inputStream);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    static void exportFile(String string, String string2, InputStream inputStream) {
        FileOutputStream fileOutputStream = null;
        String string3 = String.valueOf(string) + File.separator + string2;
        File file = new File(string3);
        try {
            if (file.exists()) {
                file.delete();
            }
            if (inputStream != null) {
                int n;
                byte[] byArray = new byte[4096];
                fileOutputStream = new FileOutputStream(string3);
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                inputStream.close();
            }
        }
        catch (Throwable throwable) {
            ActionScriptCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Failed to export file", throwable));
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String findRSL(String string, String string2) {
        File[] fileArray = new File(String.valueOf(string) + "/frameworks/rsls").listFiles();
        int n = 0;
        while (n < fileArray.length) {
            String string3 = fileArray[n].getName();
            if (string3.startsWith("framework_") && string3.endsWith(string2)) {
                if (ActionScriptCorePlugin.DEPLOY) {
                    return fileArray[n].getAbsolutePath().substring(fileArray[n].getAbsolutePath().lastIndexOf(File.separatorChar) + 1);
                }
                return fileArray[n].getAbsolutePath();
            }
            ++n;
        }
        return null;
    }

    public void generateSWFFiles(IJavaProject iJavaProject, String string, String string2) throws CoreException {
        IProject iProject = iJavaProject.getProject();
        this.buildMXMLFile(iProject, string, string2);
        this.buildHTMLFile(iProject, string, string2);
    }

    String getClassName(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    void buildMXMLFile(IProject iProject, String string, String string2) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = System.getProperty("line.separator");
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuffer.append(string3);
        stringBuffer.append("<mx:Application xmlns:mx=\"http://www.adobe.com/2006/mxml\"  width=\"100%\" height=\"100%\" creationComplete=\"startUp();\">");
        if (ActionScriptCorePlugin.THEME) {
            stringBuffer.append(string3);
            stringBuffer.append("\t");
            stringBuffer.append("<mx:Style source=\"");
            stringBuffer.append(ActionScriptCorePlugin.THEME_URL);
            stringBuffer.append("\"/>");
        }
        stringBuffer.append(string3);
        stringBuffer.append("\t");
        stringBuffer.append("<mx:Script><![CDATA[");
        stringBuffer.append(string3);
        stringBuffer.append("\t\t");
        stringBuffer.append("import ");
        stringBuffer.append(string);
        stringBuffer.append(";");
        stringBuffer.append(string3);
        stringBuffer.append("\t\t");
        stringBuffer.append("import java.lang.JavaArray;");
        stringBuffer.append(string3);
        stringBuffer.append("\t\t");
        stringBuffer.append("import java.lang.System;");
        stringBuffer.append(string3);
        stringBuffer.append(string3);
        stringBuffer.append("\t\t");
        stringBuffer.append("private function startUp():void {");
        stringBuffer.append(string3);
        stringBuffer.append("\t\t\t");
        stringBuffer.append("java.lang.System.currentTimeMillis__();");
        stringBuffer.append(string3);
        stringBuffer.append("\t\t\t");
        stringBuffer.append("var result: JavaArray = new JavaArray(\"[Ljava/lang/String;\").lengths(0);");
        stringBuffer.append(string3);
        stringBuffer.append("\t\t\t");
        stringBuffer.append(string);
        stringBuffer.append(".main___3Ljava_lang_String_2(result);");
        stringBuffer.append(string3);
        stringBuffer.append("\t\t");
        stringBuffer.append("}");
        stringBuffer.append(string3);
        stringBuffer.append("\t");
        stringBuffer.append("]]></mx:Script>");
        stringBuffer.append(string3);
        stringBuffer.append("</mx:Application>");
        stringBuffer.append(string3);
        String string4 = this.getClassName(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
        if (ActionScriptCorePlugin.DEPLOY) {
            ActionScriptLaunchConfigurationDelegate.exportFile(string2, String.valueOf(string4) + "M.mxml", byteArrayInputStream);
        } else {
            ActionScriptLaunchConfigurationDelegate.createFile(iProject, string2, String.valueOf(string4) + "M.mxml", byteArrayInputStream);
        }
    }

    void buildHTMLFile(IProject iProject, String string, String string2) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = System.getProperty("line.separator");
        stringBuffer.append("<html lang=\"en\">");
        stringBuffer.append(string3);
        stringBuffer.append("<head>");
        stringBuffer.append(string3);
        stringBuffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
        stringBuffer.append(string3);
        stringBuffer.append("<style>");
        stringBuffer.append(string3);
        stringBuffer.append("body { margin: 0px; overflow:hidden }");
        stringBuffer.append(string3);
        stringBuffer.append("</style>");
        stringBuffer.append(string3);
        stringBuffer.append("<title>");
        stringBuffer.append(string);
        stringBuffer.append("</title>");
        stringBuffer.append(string3);
        stringBuffer.append("</head>");
        stringBuffer.append(string3);
        stringBuffer.append("<body scroll='no'>");
        stringBuffer.append(string3);
        stringBuffer.append("\t<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" id=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" width=\"100%\" height=\"100%\" codebase=\"http://fpdownload.macromedia.com/get/flashplayer/current/swflash.cab\">");
        stringBuffer.append(string3);
        stringBuffer.append("\t\t<param name=\"src\" value=\"");
        String string4 = "";
        if (!ActionScriptCorePlugin.DEPLOY) {
            stringBuffer.append("http://localhost:7777/actionscript?path=");
            string4 = String.valueOf(iProject.getLocation().toPortableString()) + "/" + string2 + "/";
            stringBuffer.append(string4);
        }
        String string5 = this.getClassName(string);
        stringBuffer.append(string5);
        stringBuffer.append("M.swf\"/>");
        stringBuffer.append(string3);
        stringBuffer.append("\t\t<param name=\"quality\" value=\"high\" />");
        stringBuffer.append(string3);
        stringBuffer.append("\t\t<param name=\"bgcolor\" value=\"#869ca7\" />");
        stringBuffer.append(string3);
        stringBuffer.append("\t\t<param name=\"allowScriptAccess\" value=\"sameDomain\" />");
        stringBuffer.append(string3);
        stringBuffer.append("\t\t<embed src=\"");
        if (!ActionScriptCorePlugin.DEPLOY) {
            stringBuffer.append("http://localhost:7777/actionscript?path=");
            stringBuffer.append(string4);
        }
        stringBuffer.append(string5);
        stringBuffer.append("M.swf\" name=\"");
        stringBuffer.append(string5);
        stringBuffer.append("\" quality=\"high\" bgcolor=\"#869ca7\" width=\"100%\" height=\"100%\" align=\"middle\" play=\"true\" loop=\"false\" quality=\"high\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.adobe.com/go/getflashplayer\"/>");
        stringBuffer.append(string3);
        stringBuffer.append("\t</object>");
        stringBuffer.append(string3);
        stringBuffer.append("</body>");
        stringBuffer.append(string3);
        stringBuffer.append("</html>");
        stringBuffer.append(string3);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
        if (ActionScriptCorePlugin.DEPLOY) {
            ActionScriptLaunchConfigurationDelegate.exportFile(string2, String.valueOf(string5) + ".html", byteArrayInputStream);
        } else {
            ActionScriptLaunchConfigurationDelegate.createFile(iProject, string2, String.valueOf(string5) + ".html", byteArrayInputStream);
        }
    }

    static void createFile(IProject iProject, String string, String string2, InputStream inputStream) throws CoreException {
        String string3 = String.valueOf(string) + File.separator + string2;
        IFile iFile = iProject.getFile(string3);
        ActionScriptLaunchConfigurationDelegate.create(iFile.getParent());
        if (iFile.exists()) {
            iFile.setContents(inputStream, true, false, null);
        } else {
            iFile.create(inputStream, true, null);
        }
    }

    static void create(IContainer iContainer) throws CoreException {
        if (iContainer.exists()) {
            return;
        }
        switch (iContainer.getType()) {
            case 2: {
                ActionScriptLaunchConfigurationDelegate.create(iContainer.getParent());
                ((IFolder)iContainer).create(true, true, null);
            }
        }
    }

    String parseID(String string) {
        String string2 = "fcsh: Assigned ";
        if (string.startsWith(string2)) {
            int n;
            int n2 = n = string2.length();
            while (n2 < string.length()) {
                if (Character.isWhitespace(string.charAt(n2))) {
                    return string.substring(n, n2);
                }
                ++n2;
            }
        }
        return null;
    }

    String parseInfo(String string) {
        String string2 = "mxmlc: ";
        int n = string.indexOf(string2) + string2.length();
        if (n != -1) {
            int n2 = string.length();
            int n3 = string.indexOf(13, n + string2.length());
            if (n3 != -1) {
                n2 = n3 - 1;
            } else if ((n3 = string.indexOf(10, n3 + string2.length())) != -1) {
                n2 = n3 - 1;
            }
            return "mxmlc " + string.substring(n, n2);
        }
        return "";
    }
}

