/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.internal.compiler.as.Main;
import org.eclipse.swt.tools.actionscript.ActionScriptCorePlugin;
import org.eclipse.swt.tools.actionscript.build.ActionScriptLaunchConfigurationDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ActionScriptParticipant
extends CompilationParticipant {
    public static final String COMPILE_ID_KEY = "swc_compile_id";
    public static final String FLEX_SDK = "flex.sdk";
    final String SOURCE_ID = "java_as";
    ArrayList sources;

    public void buildFinished(IJavaProject iJavaProject) {
        if (this.sources == null) {
            return;
        }
        try {
            this.buildActionScript(iJavaProject);
            this.buildSWC(iJavaProject);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public void buildStarting(BuildContext[] buildContextArray, boolean bl) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        int n = 0;
        while (n < buildContextArray.length) {
            BuildContext buildContext = buildContextArray[n];
            IFile iFile = buildContext.getFile();
            this.sources.add(iFile.getLocation().toPortableString());
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isActive(IJavaProject iJavaProject) {
        try {
            IProject iProject = iJavaProject.getProject();
            if (iProject.getNature("org.eclipse.swt.tools.actionscript.core.actionscriptnature") != null) {
                return true;
            }
            IProject[] iProjectArray = iProject.getWorkspace().getRoot().getProjects();
            int n = 0;
            while (true) {
                IJavaProject iJavaProject2;
                if (n >= iProjectArray.length) {
                    return false;
                }
                if (iProjectArray[n].isOpen() && iProjectArray[n].getNature("org.eclipse.swt.tools.actionscript.core.actionscriptnature") != null && (iJavaProject2 = JavaCore.create((IProject)iProjectArray[n])) != null && iJavaProject2.isOnClasspath((IResource)iProject)) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    void buildActionScript(IJavaProject iJavaProject) throws CoreException {
        String string = String.valueOf(iJavaProject.getProject().getLocation().toPortableString()) + "/.buildas";
        PrintWriter printWriter = null;
        try {
            try {
                IClasspathEntry iClasspathEntry;
                IProject iProject;
                IPath iPath;
                Object object;
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                int n = 0;
                while (n < iClasspathEntryArray.length) {
                    object = iClasspathEntryArray[n];
                    if (object.getEntryKind() == 5 && object.getPath().toPortableString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                        iPath = iJavaProject.getProject().getWorkspace().getRoot();
                        iProject = (IProject)iPath.findMember("org.eclipse.swt.e4.jcl");
                        if (iProject != null && iProject.isOpen()) {
                            iClasspathEntry = JavaCore.create((IProject)iProject.getProject());
                            stringBuffer3.append(iPath.findMember(iClasspathEntry.getOutputLocation()).getLocation().toPortableString());
                        } else {
                            stringBuffer3.append(ActionScriptCorePlugin.getDefault().getJCLLocation().toPortableString());
                        }
                    }
                    ++n;
                }
                n = 0;
                while (n < iClasspathEntryArray.length) {
                    object = iClasspathEntryArray[n];
                    iPath = object.getPath();
                    int n2 = object.getEntryKind();
                    switch (n2) {
                        case 3: {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(File.pathSeparatorChar);
                            }
                            iClasspathEntry = iJavaProject.getProject().getWorkspace().getRoot().findMember(object.getPath());
                            stringBuffer.append(iClasspathEntry.getLocation().toPortableString());
                            break;
                        }
                        case 2: {
                            if (stringBuffer2.length() > 0) {
                                stringBuffer2.append(File.pathSeparator);
                            }
                            iClasspathEntry = iJavaProject.getProject().getWorkspace().getRoot();
                            IResource iResource = iClasspathEntry.findMember(object.getPath());
                            IJavaProject iJavaProject2 = JavaCore.create((IProject)((IProject)iResource));
                            stringBuffer2.append(iClasspathEntry.findMember(iJavaProject2.getOutputLocation()).getLocation().toPortableString());
                            break;
                        }
                        case 4: {
                            if (stringBuffer2.length() > 0) {
                                stringBuffer2.append(File.pathSeparatorChar);
                            }
                            iClasspathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)object);
                            stringBuffer2.append(iClasspathEntry.getPath().toPortableString());
                            break;
                        }
                        case 1: {
                            if (stringBuffer2.length() > 0) {
                                stringBuffer2.append(File.pathSeparatorChar);
                            }
                            stringBuffer2.append(object.getPath().toPortableString());
                            break;
                        }
                        case 5: {
                            if (iPath.toPortableString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) break;
                            iClasspathEntry = JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)iJavaProject);
                            IResource iResource = iClasspathEntry.getClasspathEntries();
                            int n3 = 0;
                            while (n3 < ((IResource)iResource).length) {
                                IResource iResource2;
                                if (stringBuffer2.length() > 0) {
                                    stringBuffer2.append(File.pathSeparator);
                                }
                                if ((iResource2 = iResource[n3]).getEntryKind() == 2) {
                                    IWorkspaceRoot iWorkspaceRoot = iJavaProject.getProject().getWorkspace().getRoot();
                                    IProject iProject2 = (IProject)iWorkspaceRoot.findMember(iResource2.getPath());
                                    IJavaProject iJavaProject3 = JavaCore.create((IProject)iProject2);
                                    stringBuffer2.append(iWorkspaceRoot.findMember(iJavaProject3.getOutputLocation()).getLocation().toPortableString());
                                } else {
                                    stringBuffer2.append(iResource2.getPath().toPortableString());
                                }
                                ++n3;
                            }
                            break;
                        }
                    }
                    ++n;
                }
                String string2 = string;
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(File.pathSeparator);
                }
                stringBuffer2.append(string2);
                object = new ArrayList();
                ((ArrayList)object).addAll(Arrays.asList("-d", string2, "-bootclasspath", stringBuffer3.toString(), "-cp", stringBuffer2.toString(), "-log", String.valueOf(string) + "/log.xml", "-1.5", "-sourcepath", stringBuffer.toString()));
                ((ArrayList)object).addAll(this.sources);
                this.sources = null;
                iPath = iJavaProject.getProject().getFolder(".buildas");
                if (!iPath.exists()) {
                    iPath.create(true, true, null);
                }
                printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(String.valueOf(string) + "/out.txt")));
                iProject = new Main(printWriter, printWriter, false, null);
                iProject.compile(((ArrayList)object).toArray(new String[((ArrayList)object).size()]));
                printWriter.close();
                iJavaProject.getProject().findMember((IPath)new Path(".buildas")).refreshLocal(2, null);
                this.createProblems(iJavaProject, string);
            }
            catch (Exception exception) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Problem compiling ActionScript", (Throwable)exception));
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    void appendLibrary(StringBuffer stringBuffer, IProject iProject) {
        stringBuffer.append(" -external-library-path+=");
        stringBuffer.append(String.valueOf(iProject.getLocation().toPortableString()) + "/.buildas/" + iProject.getName() + ".swc");
    }

    void appendLibrary(StringBuffer stringBuffer, IPath iPath) {
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        String string = iPreferencesService.getString("org.eclipse.swt.tools.actionscript.core", "org.eclipse.swt.tools.actionscript.core.swcpath", "", null);
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = iPath.lastSegment();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        string2 = String.valueOf(string2) + ".swc";
        File file = new File(String.valueOf(string) + File.separator + string2);
        if (file.exists()) {
            stringBuffer.append(" -external-library-path+=");
            stringBuffer.append(new Path(file.getAbsolutePath()).toPortableString());
        }
    }

    public void buildSWC(IJavaProject iJavaProject) throws CoreException {
        try {
            Object object;
            Object object2;
            Object object3;
            IProject iProject = iJavaProject.getProject();
            IResource iResource = iProject.findMember((IPath)new Path(".buildas"));
            if (iResource != null && !iResource.exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Missing .buildas folder.", null));
            }
            iResource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            final String string = String.valueOf(iProject.getLocation().toOSString()) + File.separator + ".buildas" + File.separator;
            this.generateResourceClass(iJavaProject, ".buildas");
            final StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("compc ");
            stringBuffer2.append("-warnings=false");
            stringBuffer2.append(" ");
            stringBuffer2.append("-debug=");
            IPreferencesService iPreferencesService = Platform.getPreferencesService();
            boolean bl = iPreferencesService.getBoolean("org.eclipse.swt.tools.actionscript.core", "org.eclipse.swt.tools.actionscript.core.enabledebug", false, null);
            stringBuffer2.append((Object)bl);
            stringBuffer2.append(" -external-library-path+=");
            stringBuffer2.append(String.valueOf(new Path(System.getProperty(FLEX_SDK)).toPortableString()) + "/frameworks/libs/framework.swc");
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                object3 = iClasspathEntryArray[n];
                if (object3.getEntryKind() == 5 && object3.getPath().toPortableString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                    object2 = iJavaProject.getProject().getWorkspace().getRoot();
                    object = (IProject)object2.findMember("org.eclipse.swt.e4.jcl");
                    if (object != null && object.isOpen()) {
                        this.appendLibrary(stringBuffer2, (IProject)object);
                    } else {
                        this.appendLibrary(stringBuffer2, ActionScriptCorePlugin.getDefault().getJCLLocation());
                    }
                }
                ++n;
            }
            n = 0;
            while (n < iClasspathEntryArray.length) {
                object3 = iClasspathEntryArray[n];
                object2 = object3.getPath();
                int n2 = object3.getEntryKind();
                switch (n2) {
                    case 3: {
                        break;
                    }
                    case 2: {
                        IClasspathEntry iClasspathEntry = iProject.getWorkspace().getRoot();
                        IClasspathEntry[] iClasspathEntryArray2 = (IClasspathEntry[])iClasspathEntry.findMember(object2);
                        this.appendLibrary(stringBuffer2, (IProject)iClasspathEntryArray2);
                        break;
                    }
                    case 4: {
                        IClasspathEntry iClasspathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)object3);
                        this.appendLibrary(stringBuffer2, iClasspathEntry.getPath());
                        break;
                    }
                    case 1: {
                        this.appendLibrary(stringBuffer2, (IPath)object2);
                        break;
                    }
                    case 5: {
                        if (object2.toPortableString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) break;
                        IClasspathEntry iClasspathEntry = JavaCore.getClasspathContainer((IPath)object2, (IJavaProject)iJavaProject);
                        IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntry.getClasspathEntries();
                        int n3 = 0;
                        while (n3 < iClasspathEntryArray2.length) {
                            IClasspathEntry iClasspathEntry2 = iClasspathEntryArray2[n3];
                            if (iClasspathEntry2.getEntryKind() == 2) {
                                IWorkspaceRoot iWorkspaceRoot = iJavaProject.getProject().getWorkspace().getRoot();
                                IProject iProject2 = (IProject)iWorkspaceRoot.findMember(iClasspathEntry2.getPath());
                                this.appendLibrary(stringBuffer2, iProject2);
                            } else {
                                this.appendLibrary(stringBuffer2, iClasspathEntryArray2[n3].getPath());
                            }
                            ++n3;
                        }
                        break;
                    }
                }
                ++n;
            }
            stringBuffer2.append(" ");
            stringBuffer2.append("-source-path");
            stringBuffer2.append(" ");
            stringBuffer2.append(string);
            stringBuffer2.append(" ");
            stringBuffer2.append("-include-classes");
            iResource.accept(new IResourceVisitor(){

                public boolean visit(IResource iResource) throws CoreException {
                    if ("as".equals(iResource.getFileExtension())) {
                        String string2 = iResource.getLocation().toPortableString();
                        string2 = string2.substring(string.length());
                        string2 = string2.substring(0, string2.length() - 3);
                        string2 = string2.replace('/', '.');
                        stringBuffer.append(" ");
                        stringBuffer.append(string2);
                    }
                    return true;
                }
            });
            stringBuffer2.append(stringBuffer);
            stringBuffer2.append(" ");
            stringBuffer2.append("-output=");
            stringBuffer2.append(String.valueOf(string) + iProject.getName() + ".swc");
            n = 0;
            object3 = null;
            do {
                object2 = stringBuffer2.toString();
                object = iProject.getSessionProperty(new QualifiedName("org.eclipse.swt.tools.actionscript.core", COMPILE_ID_KEY));
                if (object == null || !this.parseInfo((String)(object3 = ActionScriptCorePlugin.getDefault().getManager().sendCommand("info " + object))).equals(object2)) continue;
                object2 = "compile " + object;
            } while ((object3 = ActionScriptCorePlugin.getDefault().getManager().sendCommand((String)object2)) == null && n++ < 3);
            if (object3 == null) {
                throw new Exception("Out of Memory");
            }
            object2 = this.parseID((String)object3);
            if (object2 != null) {
                iProject.setSessionProperty(new QualifiedName("org.eclipse.swt.tools.actionscript.core", COMPILE_ID_KEY), object2);
            }
            iProject.findMember((IPath)new Path(".buildas")).refreshLocal(2, null);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Problem compiling SWC", (Throwable)exception));
        }
    }

    void generateResourceClass(IJavaProject iJavaProject, final String string) throws JavaModelException, CoreException {
        final StringBuffer stringBuffer = new StringBuffer();
        final String string2 = System.getProperty("line.separator");
        stringBuffer.append("package {");
        stringBuffer.append(string2);
        stringBuffer.append(string2);
        stringBuffer.append("public class Resources {");
        stringBuffer.append(string2);
        stringBuffer.append(string2);
        final IProject iProject = iJavaProject.getProject();
        IResource iResource = iProject.getWorkspace().getRoot().findMember(iJavaProject.getOutputLocation());
        final String string3 = String.valueOf(iResource.getLocation().toPortableString()) + "/";
        iResource.accept(new IResourceVisitor(){

            public boolean visit(IResource iResource) {
                if (!"class".equals(iResource.getFileExtension()) && iResource instanceof IFile) {
                    String string4 = iResource.getLocation().toPortableString();
                    string4 = string4.substring(string3.length());
                    stringBuffer.append("\t[Embed(source=\"");
                    stringBuffer.append(string4);
                    stringBuffer.append("\", mimeType=\"application/octet-stream\")]");
                    stringBuffer.append(string2);
                    stringBuffer.append("\tpublic var ");
                    stringBuffer.append(ActionScriptParticipant.this.mangleResourceName(string4));
                    stringBuffer.append(":Class;");
                    stringBuffer.append(string2);
                    stringBuffer.append(string2);
                    try {
                        ActionScriptLaunchConfigurationDelegate.createFile(iProject, String.valueOf(string) + "/" + string4.substring(0, string4.length() - iResource.getName().length()), iResource.getName(), ((IFile)iResource).getContents());
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                }
                return true;
            }
        });
        stringBuffer.append("}");
        stringBuffer.append(string2);
        stringBuffer.append("}");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
        ActionScriptLaunchConfigurationDelegate.createFile(iProject, string, "Resources.as", byteArrayInputStream);
    }

    void createProblems(IJavaProject iJavaProject, String string) throws CoreException {
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        boolean bl = iPreferencesService.getBoolean("org.eclipse.swt.tools.actionscript.core", "org.eclipse.swt.tools.actionscript.core.showaserrors", false, null);
        if (bl) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(String.valueOf(string) + "/log.xml"));
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(bufferedInputStream));
                ((InputStream)bufferedInputStream).close();
                IWorkspaceRoot iWorkspaceRoot = iJavaProject.getProject().getWorkspace().getRoot();
                String string2 = iWorkspaceRoot.getLocation().toPortableString();
                NodeList nodeList = document.getDocumentElement().getElementsByTagName("sources");
                int n = 0;
                while (n < nodeList.getLength()) {
                    NodeList nodeList2 = ((Element)nodeList.item(n)).getElementsByTagName("source");
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        Object object;
                        Element element = (Element)nodeList2.item(n2);
                        String string3 = element.getAttribute("path").replace('\\', '/');
                        if (string3.startsWith(string2)) {
                            string3 = string3.substring(string2.length());
                        }
                        IResource iResource = iWorkspaceRoot.findMember((IPath)new Path(string3));
                        boolean bl2 = false;
                        IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
                        int n3 = 0;
                        while (n3 < iMarkerArray.length) {
                            IMarker iMarker = iMarkerArray[n3];
                            if ("java_as".equals(iMarker.getAttribute("sourceId"))) {
                                iMarker.delete();
                            } else {
                                object = iMarker.getAttribute("severity");
                                bl2 |= object != null && (Integer)object == 2;
                            }
                            ++n3;
                        }
                        if (!bl2) {
                            NodeList nodeList3 = element.getElementsByTagName("problems");
                            int n4 = 0;
                            while (n4 < nodeList3.getLength()) {
                                object = ((Element)nodeList3.item(n4)).getElementsByTagName("problem");
                                int n5 = 0;
                                while (n5 < object.getLength()) {
                                    Element element2 = (Element)object.item(n5);
                                    if (iResource != null) {
                                        int n6 = Integer.parseInt(element2.getAttribute("charStart"));
                                        int n7 = Integer.parseInt(element2.getAttribute("charEnd")) + 1;
                                        String string4 = "[AS] " + ((Element)element2.getElementsByTagName("message").item(0)).getAttribute("value");
                                        IMarker iMarker = iResource.createMarker("org.eclipse.jdt.core.problem");
                                        int n8 = "ERROR".equals(element2.getAttribute("severity")) ? 2 : 1;
                                        iMarker.setAttributes(new String[]{"message", "severity", "charStart", "charEnd", "sourceId"}, new Object[]{string4, new Integer(n8), new Integer(n6), new Integer(n7), "java_as"});
                                    }
                                    ++n5;
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools.actionscript.core", "Problem creating ActionScript problems", (Throwable)exception));
            }
        }
    }

    public void cleanStarting(IJavaProject iJavaProject) {
        if (!this.isActive(iJavaProject)) {
            return;
        }
        this.sources = null;
        IResource iResource = iJavaProject.getProject().findMember((IPath)new Path(".buildas"));
        if (iResource != null) {
            try {
                iResource.delete(true, null);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }

    String parseID(String string) {
        String string2 = "fcsh: Assigned ";
        if (string.startsWith(string2)) {
            int n;
            int n2 = n = string2.length();
            while (n2 < string.length()) {
                if (Character.isWhitespace(string.charAt(n2))) {
                    return string.substring(n, n2);
                }
                ++n2;
            }
        }
        return null;
    }

    String parseInfo(String string) {
        String string2 = "compc: ";
        int n = string.indexOf(string2) + string2.length();
        if (n != -1) {
            int n2 = string.length();
            int n3 = string.indexOf(13, n + string2.length());
            if (n3 != -1) {
                n2 = n3 - 1;
            } else if ((n3 = string.indexOf(10, n3 + string2.length())) != -1) {
                n2 = n3 - 1;
            }
            return "compc " + string.substring(n, n2);
        }
        return "";
    }

    String mangleResourceName(String string) {
        String string2 = string.replace(' ', '_');
        string2 = string2.replace('/', '_');
        string2 = string2.replace('.', '_');
        string2 = string2.replace('-', '_');
        return string2;
    }
}

