/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.debug;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.events.BreakEvent;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.events.SwfLoadedEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptDebugTarget;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptLineMapper;

public class ActionScriptDebugEventDispatcher
extends Job {
    static final int CLIENT_REQUEST = 32;
    static final int BREAKPOINT = 16;
    ActionScriptDebugTarget target;

    public ActionScriptDebugEventDispatcher(ActionScriptDebugTarget actionScriptDebugTarget) {
        super("ActionScript Event Dispatcher");
        this.target = actionScriptDebugTarget;
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        if (this.target.isTerminated()) {
            return Status.CANCEL_STATUS;
        }
        Session session = this.target.session;
        DebugEvent debugEvent = session.nextEvent();
        while (debugEvent != null && !this.target.isTerminated()) {
            this.handleEvent(debugEvent);
            debugEvent = session.nextEvent();
        }
        if (!this.target.isTerminated()) {
            this.schedule(500L);
        }
        return Status.OK_STATUS;
    }

    void handleEvent(DebugEvent debugEvent) {
        if (debugEvent instanceof BreakEvent) {
            this.handleBreak((BreakEvent)debugEvent);
        } else if (debugEvent instanceof SwfLoadedEvent) {
            this.handleSwfLoaded((SwfLoadedEvent)debugEvent);
        }
    }

    void handleSwfLoaded(SwfLoadedEvent swfLoadedEvent) {
        IBreakpointManager iBreakpointManager = this.target.getBreakpointManager();
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints();
        int n = 0;
        while (n < iBreakpointArray.length) {
            if (iBreakpointArray[n] instanceof IJavaBreakpoint) {
                try {
                    this.target.installBreakpoint((IJavaLineBreakpoint)iBreakpointArray[n]);
                }
                catch (PlayerDebugException playerDebugException) {
                    playerDebugException.printStackTrace();
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            ++n;
        }
    }

    void handleBreak(BreakEvent breakEvent) {
        Session session;
        try {
            session = this.target.session;
            switch (session.suspendReason()) {
                case 0: 
                case 7: {
                    if (session.isSuspended()) {
                        session.resume();
                    }
                    return;
                }
            }
        }
        catch (PlayerDebugException playerDebugException) {
            playerDebugException.printStackTrace();
        }
        session = this.target.getBreakpointManager();
        IBreakpoint[] iBreakpointArray = session.getBreakpoints();
        int n = 0;
        while (n < iBreakpointArray.length) {
            if (iBreakpointArray[n] instanceof IJavaLineBreakpoint) {
                IJavaLineBreakpoint iJavaLineBreakpoint = (IJavaLineBreakpoint)iBreakpointArray[n];
                try {
                    int n2 = iJavaLineBreakpoint.getMarker().getAttribute("ASID", -1);
                    ActionScriptLineMapper actionScriptLineMapper = ActionScriptLineMapper.getInstance();
                    ActionScriptLineMapper.FileLocation fileLocation = actionScriptLineMapper.getActionScriptLocation(iJavaLineBreakpoint);
                    if (fileLocation != null && fileLocation.lineNumber == breakEvent.line && n2 == breakEvent.fileId) {
                        if (this.target.isStepping) {
                            this.target.isStepping = false;
                        }
                        this.target.thread.fireSuspendEvent(16);
                        return;
                    }
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            ++n;
        }
        if (this.target.isStepping()) {
            this.target.stepEnd();
        } else {
            this.target.thread.fireSuspendEvent(32);
        }
    }
}

