/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.debug;

import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.SourceFile;
import flash.tools.debugger.SwfInfo;
import java.util.HashMap;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptLineMapper;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptProcess;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptThread;

public class ActionScriptDebugTarget
extends DebugElement
implements IDebugTarget,
IStep {
    Session session;
    ActionScriptThread thread;
    public ActionScriptProcess process;
    ILaunch launch;
    IBreakpointManager breakpointManager;
    boolean isStepping;
    String mainClass;
    String processName;
    HashMap<Integer, Location> locations;

    public ActionScriptDebugTarget(Session session, ILaunch iLaunch, String string, String string2) {
        super(null);
        this.session = session;
        this.launch = iLaunch;
        this.mainClass = string;
        this.processName = string2;
        this.thread = new ActionScriptThread(this);
        this.process = new ActionScriptProcess(this, iLaunch, string2);
        this.breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this.breakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.locations = new HashMap();
        this.fireCreationEvent();
    }

    public String getName() throws DebugException {
        if (this.process.isTerminated()) {
            return "<terminated>" + this.mainClass;
        }
        return this.mainClass;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public IThread[] getThreads() throws DebugException {
        if (this.isTerminated()) {
            return new IThread[0];
        }
        return new IThread[]{this.thread};
    }

    public boolean hasThreads() throws DebugException {
        return !this.isTerminated();
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        return iBreakpoint instanceof IJavaLineBreakpoint;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getModelIdentifier() {
        return "org.eclipse.swt.tools.actionscript.core.debugModelPresentation";
    }

    public boolean canTerminate() {
        return !this.process.isTerminated();
    }

    public boolean isTerminated() {
        return this.process.isTerminated();
    }

    public void terminate() throws DebugException {
        this.fireTerminateEvent();
        this.process.terminate();
    }

    public boolean canResume() {
        if (!this.session.isConnected()) {
            return false;
        }
        try {
            return this.session.isSuspended();
        }
        catch (PlayerDebugException playerDebugException) {
            playerDebugException.printStackTrace();
            return false;
        }
    }

    public boolean canSuspend() {
        if (!this.session.isConnected()) {
            return false;
        }
        try {
            return !this.session.isSuspended();
        }
        catch (NotConnectedException notConnectedException) {
            notConnectedException.printStackTrace();
            return false;
        }
    }

    public boolean isSuspended() {
        block3: {
            try {
                if (!this.isDisconnected()) break block3;
                return false;
            }
            catch (NotConnectedException notConnectedException) {
                notConnectedException.printStackTrace();
                return false;
            }
        }
        return this.session.isSuspended();
    }

    public void resume() throws DebugException {
        try {
            this.session.resume();
            this.thread.fireResumeEvent(32);
        }
        catch (PlayerDebugException playerDebugException) {
            Status status = new Status(4, "org.eclipse.swt.tools.actionscript.core", "Error resuming target", (Throwable)playerDebugException);
            throw new DebugException((IStatus)status);
        }
    }

    public void suspend() throws DebugException {
        try {
            this.session.suspend();
            this.thread.fireSuspendEvent(32);
        }
        catch (PlayerDebugException playerDebugException) {
            Status status = new Status(4, "org.eclipse.swt.tools.actionscript.core", "Error suspending target", (Throwable)playerDebugException);
            throw new DebugException((IStatus)status);
        }
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
        if (!(iBreakpoint instanceof IJavaLineBreakpoint)) {
            return;
        }
        if (this.isTerminated()) {
            return;
        }
        try {
            this.installBreakpoint((IJavaLineBreakpoint)iBreakpoint);
        }
        catch (PlayerDebugException playerDebugException) {
            playerDebugException.printStackTrace();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    boolean installBreakpoint(IJavaLineBreakpoint iJavaLineBreakpoint) throws PlayerDebugException, CoreException {
        ActionScriptLineMapper actionScriptLineMapper = ActionScriptLineMapper.getInstance();
        ActionScriptLineMapper.FileLocation fileLocation = actionScriptLineMapper.getActionScriptLocation(iJavaLineBreakpoint);
        if (fileLocation == null) {
            return false;
        }
        SwfInfo[] swfInfoArray = this.session.getSwfs();
        int n = 0;
        while (n < swfInfoArray.length) {
            SwfInfo swfInfo = swfInfoArray[n];
            SourceFile[] sourceFileArray = swfInfo.getSourceList(this.session);
            int n2 = 0;
            while (n2 < sourceFileArray.length) {
                SourceFile sourceFile = sourceFileArray[n2];
                String string = sourceFile.getFullPath();
                if (string.equals(fileLocation.fileName)) {
                    int n3 = sourceFile.getId();
                    Location location = this.session.setBreakpoint(n3, fileLocation.lineNumber);
                    iJavaLineBreakpoint.getMarker().setAttribute("ASID", n3);
                    this.locations.put(n3, location);
                    return location != null;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (iBreakpoint instanceof IJavaLineBreakpoint) {
            try {
                Location location;
                int n = iBreakpoint.getMarker().getAttribute("ASID", -1);
                if (n != -1 && (location = this.locations.get(n)) != null) {
                    this.session.clearBreakpoint(location);
                }
                iBreakpoint.getMarker().setAttribute("ASID", -1);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            catch (NoResponseException noResponseException) {
                noResponseException.printStackTrace();
            }
            catch (NotConnectedException notConnectedException) {
                notConnectedException.printStackTrace();
            }
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return !this.session.isConnected();
    }

    public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public boolean canStepInto() {
        try {
            return this.session.isSuspended();
        }
        catch (NotConnectedException notConnectedException) {
            return false;
        }
    }

    public boolean canStepOver() {
        try {
            return this.session.isSuspended();
        }
        catch (NotConnectedException notConnectedException) {
            return false;
        }
    }

    public boolean canStepReturn() {
        try {
            return this.session.isSuspended();
        }
        catch (NotConnectedException notConnectedException) {
            return false;
        }
    }

    public boolean isStepping() {
        return this.isStepping;
    }

    public void stepInto() throws DebugException {
        this.isStepping = true;
        try {
            this.session.stepInto();
            this.thread.fireResumeEvent(1);
        }
        catch (PlayerDebugException playerDebugException) {
            playerDebugException.printStackTrace();
        }
    }

    public void stepOver() throws DebugException {
        this.isStepping = true;
        try {
            this.session.stepOver();
            this.thread.fireResumeEvent(2);
        }
        catch (PlayerDebugException playerDebugException) {
            playerDebugException.printStackTrace();
        }
    }

    public void stepReturn() throws DebugException {
        this.isStepping = true;
        try {
            this.session.stepOut();
            this.thread.fireResumeEvent(4);
        }
        catch (PlayerDebugException playerDebugException) {
            playerDebugException.printStackTrace();
        }
    }

    void stepEnd() {
        this.isStepping = false;
        this.thread.fireSuspendEvent(8);
    }

    public IBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }
}

