/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.debug;

import flash.tools.debugger.Frame;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Variable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptDebugTarget;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptLineMapper;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptVariable;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptVariableValue;

public class ActionScriptFrame
extends DebugElement
implements IStackFrame {
    ActionScriptDebugTarget target;
    Frame frame;
    ActionScriptLineMapper.FileLocation fileLocation;

    ActionScriptFrame(ActionScriptDebugTarget actionScriptDebugTarget, Frame frame) {
        super((IDebugTarget)actionScriptDebugTarget);
        this.target = actionScriptDebugTarget;
        this.frame = frame;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ActionScriptFrame)) {
            return false;
        }
        ActionScriptFrame actionScriptFrame = (ActionScriptFrame)((Object)object);
        return this.frame == actionScriptFrame.frame;
    }

    public int hashCode() {
        return this.frame.hashCode();
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        this.initLocation();
        return this.fileLocation != null ? this.fileLocation.lineNumber : 0;
    }

    public String getName() throws DebugException {
        String string = this.frame.getCallSignature();
        string = ActionScriptVariableValue.replace(string, "::", ".");
        string = string.replace('/', '.');
        string = String.valueOf(string) + "(";
        string = String.valueOf(string) + ")";
        return String.valueOf(string) + " line: " + this.getLineNumber();
    }

    public String getSourceName() {
        this.initLocation();
        return this.fileLocation != null ? this.fileLocation.qualifiedName : null;
    }

    private void initLocation() {
        if (this.fileLocation != null) {
            return;
        }
        try {
            this.fileLocation = ActionScriptLineMapper.getInstance().getJavaLocation(this.frame.getLocation());
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public IThread getThread() {
        return this.target.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        try {
            Variable[] variableArray = this.target.session.getVariableList();
            int n = variableArray.length;
            IVariable[] iVariableArray = new ActionScriptVariable[n];
            int n2 = 0;
            while (n2 < n) {
                iVariableArray[n2] = new ActionScriptVariable(this.target, variableArray[n2]);
                ++n2;
            }
            return iVariableArray;
        }
        catch (PlayerDebugException playerDebugException) {
            Status status = new Status(4, "org.eclipse.swt.tools.actionscript.core", "Error getting variables", (Throwable)playerDebugException);
            throw new DebugException((IStatus)status);
        }
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        try {
            Variable[] variableArray = this.frame.getLocals(this.target.session);
            return variableArray.length > 0;
        }
        catch (PlayerDebugException playerDebugException) {
            Status status = new Status(4, "org.eclipse.swt.tools.actionscript.core", "Error getting variables", (Throwable)playerDebugException);
            throw new DebugException((IStatus)status);
        }
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public ILaunch getLaunch() {
        return this.target.getLaunch();
    }

    public String getModelIdentifier() {
        return this.target.getModelIdentifier();
    }

    public boolean canStepInto() {
        return this.target.canStepInto();
    }

    public boolean canStepOver() {
        return this.target.canStepOver();
    }

    public boolean canStepReturn() {
        return this.target.canStepReturn();
    }

    public boolean isStepping() {
        return this.target.isStepping();
    }

    public void stepInto() throws DebugException {
        this.target.stepInto();
    }

    public void stepOver() throws DebugException {
        this.target.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.target.stepReturn();
    }

    public boolean canResume() {
        return this.target.canResume();
    }

    public boolean canSuspend() {
        return this.target.canSuspend();
    }

    public boolean isSuspended() {
        return this.target.isSuspended();
    }

    public void resume() throws DebugException {
        this.target.resume();
    }

    public void suspend() throws DebugException {
        this.target.suspend();
    }

    public boolean canTerminate() {
        return this.target.canTerminate();
    }

    public boolean isTerminated() {
        return this.target.isTerminated();
    }

    public void terminate() throws DebugException {
        this.target.terminate();
    }
}

