/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.debug;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.swt.tools.actionscript.debug.ActionScriptVariable;

public class ActionScriptVariableValue
implements IValue {
    Value value;
    ActionScriptVariable variable;

    ActionScriptVariableValue(ActionScriptVariable actionScriptVariable, Value value) {
        this.variable = actionScriptVariable;
        this.value = value;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.value.getClassName();
    }

    public String getValueString() throws DebugException {
        switch (this.value.getType()) {
            case 2: {
                Object object = this.value.getValueAsObject();
                return "\"" + object + "\"";
            }
            case 0: {
                return this.value.getValueAsString();
            }
            case 6: {
                return "null";
            }
            case 7: {
                return this.value.getValueAsString();
            }
            case 3: {
                String string = this.value.getTypeName();
                string = ActionScriptVariableValue.replace(string, "::", ".");
                string = string.substring(0, string.lastIndexOf(64));
                return String.valueOf(string) + " (id=" + this.value.getId() + ")";
            }
        }
        return this.value.getValueAsString();
    }

    static String replace(String string, String string2, String string3) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public IVariable[] getVariables() throws DebugException {
        try {
            Variable[] variableArray = this.value.getMembers(this.variable.target.session);
            IVariable[] iVariableArray = new ActionScriptVariable[variableArray.length];
            int n = 0;
            while (n < variableArray.length) {
                iVariableArray[n] = new ActionScriptVariable(this.variable.target, variableArray[n]);
                ++n;
            }
            return iVariableArray;
        }
        catch (PlayerDebugException playerDebugException) {
            Status status = new Status(4, "org.eclipse.swt.tools.actionscript.core", "Error getting variables", (Throwable)playerDebugException);
            throw new DebugException((IStatus)status);
        }
    }

    public boolean hasVariables() throws DebugException {
        try {
            return this.value.getMemberCount(this.variable.target.session) != 0;
        }
        catch (PlayerDebugException playerDebugException) {
            Status status = new Status(4, "org.eclipse.swt.tools.actionscript.core", "Error getting variables", (Throwable)playerDebugException);
            throw new DebugException((IStatus)status);
        }
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IDebugTarget getDebugTarget() {
        return this.variable.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.variable.getLaunch();
    }

    public String getModelIdentifier() {
        return this.variable.getModelIdentifier();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IValue.class) {
            return this;
        }
        return super.getClass();
    }
}

