/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.server.bespin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.e4.server.bespin.Activator;
import org.eclipse.e4.server.bespin.JSONUtil;

public class AuthenticationServlet
extends HttpServlet {
    private File users = Activator.bundleContext.getDataFile("users");

    public AuthenticationServlet() {
        this.users.mkdir();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        if (string.equals("/userinfo/")) {
            HttpSession httpSession = httpServletRequest.getSession();
            if (httpSession == null) {
                httpServletResponse.setStatus(401);
                return;
            }
            String string2 = (String)httpSession.getAttribute("username");
            if (string2 == null) {
                httpServletResponse.setStatus(401);
                return;
            }
            Map map = this.loadUserMap(string2);
            if (map == null) {
                httpServletResponse.setStatus(401);
                return;
            }
            String string3 = (String)map.get("project");
            httpServletResponse.setContentType("application/json; charset=UTF-8");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("project", new Integer(string3.hashCode()));
            hashMap.put("username", string2);
            httpServletResponse.getWriter().write(JSONUtil.write(hashMap));
            return;
        }
        if (string.equals("/logout/")) {
            HttpSession httpSession = httpServletRequest.getSession();
            if (httpSession != null) {
                httpSession.invalidate();
            }
            return;
        }
        super.doGet(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        if (string.startsWith("/new/")) {
            String string2 = string.substring("/new/".length());
            Map map = this.loadUserMap(string2);
            if (map != null) {
                httpServletResponse.getWriter().write("Username " + string2 + " is already in use");
                httpServletResponse.setStatus(409);
                return;
            }
            map = this.createUserMap();
            String string3 = httpServletRequest.getParameter("password");
            map.put("password", string3);
            String string4 = httpServletRequest.getParameter("email");
            map.put("email", string4);
            String string5 = String.valueOf(string2) + "_Project";
            map.put("project", string5);
            this.saveUserMap(string2, map);
            httpServletRequest.getSession(true).setAttribute("username", (Object)string2);
            httpServletResponse.setContentType("application/json; charset=UTF-8");
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("project", new Integer(string5.hashCode()));
            httpServletResponse.getWriter().write(JSONUtil.write(hashMap));
            return;
        }
        if (string.startsWith("/login/")) {
            String string6 = string.substring("/login/".length());
            Map map = this.loadUserMap(string6);
            if (map == null) {
                httpServletResponse.setStatus(401);
                return;
            }
            String string7 = (String)map.get("project");
            httpServletRequest.getSession(true).setAttribute("username", (Object)string6);
            httpServletResponse.setContentType("application/json; charset=UTF-8");
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("project", new Integer(string7.hashCode()));
            httpServletResponse.getWriter().write(JSONUtil.write(hashMap));
            return;
        }
        super.doPost(httpServletRequest, httpServletResponse);
    }

    private Map createUserMap() {
        return new Properties();
    }

    private void saveUserMap(String string, Map map) {
        File file = new File(this.users, String.valueOf(string) + ".properties");
        Properties properties = (Properties)map;
        try {
            properties.store(new FileOutputStream(file), null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Map loadUserMap(String string) {
        File file = new File(this.users, String.valueOf(string) + ".properties");
        if (!file.isFile()) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
    }
}

