/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.server.bespin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.server.bespin.JSONUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.internal.core.ClasspathComputer;

public class FilesServlet
extends HttpServlet {
    private static final boolean CHEAT = false;
    private IWorkspace workspace;

    private synchronized IWorkspace getWorkspace() {
        if (this.workspace == null) {
            new InstanceScope().getNode("org.eclipse.core.resources").putBoolean("refresh.enabled", true);
            this.workspace = ResourcesPlugin.getWorkspace();
        }
        return this.workspace;
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        if (string.startsWith("/at/")) {
            try {
                String string2 = string.substring("/at".length());
                IFile iFile = this.getWorkspace().getRoot().getFile((IPath)new Path(string2));
                ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                if (iFile.exists()) {
                    iFile.setContents((InputStream)servletInputStream, false, true, null);
                } else {
                    iFile.create((InputStream)servletInputStream, false, null);
                }
                httpServletResponse.setStatus(200);
                this.pipe(iFile, (OutputStream)httpServletResponse.getOutputStream());
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace(httpServletResponse.getWriter());
                httpServletResponse.setStatus(500);
                return;
            }
        }
        if (string.startsWith("/list/")) {
            String string3 = string.substring("/list/".length());
            boolean bl = string3.indexOf(46) != -1;
            try {
                this.createProject(string3, bl);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace(httpServletResponse.getWriter());
                httpServletResponse.setStatus(500);
                return;
            }
        }
        super.doPut(httpServletRequest, httpServletResponse);
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        if (string.startsWith("/at/")) {
            String string2 = string.substring("/at".length());
            IResource iResource = this.getWorkspace().getRoot().findMember((IPath)new Path(string2));
            if (iResource == null) {
                httpServletResponse.getWriter().println("Resource '" + string2 + "' does not exist");
                httpServletResponse.setStatus(404);
                return;
            }
            try {
                iResource.delete(false, null);
                httpServletResponse.setStatus(204);
                return;
            }
            catch (CoreException coreException) {
                coreException.printStackTrace(httpServletResponse.getWriter());
                httpServletResponse.setStatus(500);
                return;
            }
        }
        super.doDelete(httpServletRequest, httpServletResponse);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        if (string.startsWith("/at/")) {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            String string2 = string.substring("/at".length());
            IResource iResource = this.getWorkspace().getRoot().findMember((IPath)new Path(string2));
            if (iResource == null) {
                httpServletResponse.setStatus(404);
                return;
            }
            if (iResource.getType() != 1) {
                httpServletResponse.setStatus(405);
                return;
            }
            IFile iFile = (IFile)iResource;
            try {
                this.pipe(iFile, (OutputStream)servletOutputStream);
                return;
            }
            catch (CoreException coreException) {
                coreException.printStackTrace(new PrintStream((OutputStream)servletOutputStream, true));
                httpServletResponse.setStatus(500);
                return;
            }
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (string.startsWith("/list/")) {
            String string3 = string.substring("/list".length());
            IResource iResource = this.getWorkspace().getRoot().findMember((IPath)new Path(string3));
            if (iResource == null) {
                httpServletResponse.setStatus(404);
                return;
            }
            if (iResource.getType() == 1) {
                httpServletResponse.setStatus(405);
                return;
            }
            IContainer iContainer = (IContainer)iResource;
            try {
                IResource[] iResourceArray = iContainer.members();
                httpServletResponse.setStatus(200);
                httpServletResponse.setContentType("application/json; charset=UTF-8");
                ArrayList arrayList = new ArrayList();
                int n = 0;
                while (n < iResourceArray.length) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    String string4 = iResourceArray[n].getName();
                    if (iResourceArray[n].getType() != 1) {
                        string4 = String.valueOf(string4) + "/";
                    }
                    hashMap.put("name", string4);
                    arrayList.add(hashMap);
                    ++n;
                }
                printWriter.write(JSONUtil.write(arrayList));
                return;
            }
            catch (CoreException coreException) {
                coreException.printStackTrace(printWriter);
                httpServletResponse.setStatus(500);
                return;
            }
        }
        if (string.equals("/listopen/")) {
            httpServletResponse.setStatus(200);
            httpServletResponse.setContentType("application/json; charset=UTF-8");
            printWriter.print("{} ".replace('\'', '\"'));
            return;
        }
        super.doGet(httpServletRequest, httpServletResponse);
    }

    private void pipe(IFile iFile, OutputStream outputStream) throws CoreException, IOException {
        InputStream inputStream = iFile.getContents();
        byte[] byArray = new byte[4096];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
    }

    private void createProject(String string, boolean bl) throws CoreException, JavaModelException {
        IProject iProject = this.getWorkspace().getRoot().getProject(string);
        iProject.create(null);
        iProject.open(null);
        if (bl) {
            this.addNatureToProject(iProject, "org.eclipse.pde.PluginNature", null);
            this.setupJava(iProject, true);
            IFolder iFolder = iProject.getFolder("META-INF");
            iFolder.create(true, true, null);
            this.createManifest(iFolder, string);
            this.createBuildProperties(iProject);
        } else {
            this.setupJava(iProject, false);
        }
    }

    private void addNatureToProject(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }

    private void setupJava(IProject iProject, boolean bl) throws CoreException, JavaModelException {
        this.addNatureToProject(iProject, "org.eclipse.jdt.core.javanature", null);
        IFolder iFolder = iProject.getFolder("src");
        iFolder.create(true, true, null);
        IFolder iFolder2 = iProject.getFolder("bin");
        if (!iFolder2.exists()) {
            iFolder2.create(true, true, null);
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        iJavaProject.setOutputLocation(iFolder2.getFullPath(), null);
        IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[bl ? 3 : 1];
        if (bl) {
            String string = "J2SE-1.5";
            ClasspathComputer.setComplianceOptions((IJavaProject)iJavaProject, (String)string);
            iClasspathEntryArray[0] = ClasspathComputer.createJREEntry((String)string);
            iClasspathEntryArray[1] = ClasspathComputer.createContainerEntry();
        }
        iClasspathEntryArray[iClasspathEntryArray.length - 1] = JavaCore.newSourceEntry((IPath)iFolder.getFullPath());
        iJavaProject.setRawClasspath(iClasspathEntryArray, null);
    }

    private void createManifest(IFolder iFolder, String string) throws CoreException {
        IFile iFile = iFolder.getFile("MANIFEST.MF");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Manifest-Version: 1.0\n");
        stringBuffer.append("Bundle-ManifestVersion: 2\n");
        stringBuffer.append("Bundle-Name: " + string + "\n");
        stringBuffer.append("Bundle-SymbolicName: " + string + "\n");
        stringBuffer.append("Bundle-Version: 1.0.0\n");
        stringBuffer.append("Bundle-RequiredExecutionEnvironment: J2SE-1.5\n");
        stringBuffer.append("\n");
        iFile.create((InputStream)new ByteArrayInputStream(stringBuffer.toString().getBytes()), false, null);
    }

    private void createBuildProperties(IProject iProject) throws CoreException {
        IFile iFile = iProject.getFile("build.properties");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("source.. = src/\n");
        stringBuffer.append("output.. = bin/\n");
        stringBuffer.append("bin.includes = META-INF/,\\n");
        stringBuffer.append("               .\n");
        iFile.create((InputStream)new ByteArrayInputStream(stringBuffer.toString().getBytes()), false, null);
    }
}

