/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.server.bespin;

import java.math.BigDecimal;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSONUtil {
    private static final String EMPTY_STRING = "";
    private static final String NULL = "null";

    public static Object read(String string) {
        return JSONUtil.parse(new StringCharacterIterator(string));
    }

    public static String write(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        JSONUtil.writeValue(object, stringBuffer);
        return stringBuffer.toString();
    }

    private static RuntimeException error(String string, CharacterIterator characterIterator) {
        return new IllegalStateException("[" + characterIterator.getIndex() + "] " + string);
    }

    private static RuntimeException error(String string) {
        return new IllegalStateException(string);
    }

    private static Object parse(CharacterIterator characterIterator) {
        JSONUtil.parseWhitespace(characterIterator);
        Object object = JSONUtil.parseValue(characterIterator);
        JSONUtil.parseWhitespace(characterIterator);
        if (characterIterator.current() != '\uffff') {
            throw JSONUtil.error("should be done", characterIterator);
        }
        return object;
    }

    private static void parseWhitespace(CharacterIterator characterIterator) {
        char c = characterIterator.current();
        while (Character.isWhitespace(c)) {
            c = characterIterator.next();
        }
    }

    private static Object parseValue(CharacterIterator characterIterator) {
        switch (characterIterator.current()) {
            case '{': {
                return JSONUtil.parseObject(characterIterator);
            }
            case '[': {
                return JSONUtil.parseArray(characterIterator);
            }
            case '\"': {
                return JSONUtil.parseString(characterIterator);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return JSONUtil.parseNumber(characterIterator);
            }
            case 't': {
                JSONUtil.parseText(Boolean.TRUE.toString(), characterIterator);
                return Boolean.TRUE;
            }
            case 'f': {
                JSONUtil.parseText(Boolean.FALSE.toString(), characterIterator);
                return Boolean.FALSE;
            }
            case 'n': {
                JSONUtil.parseText(NULL, characterIterator);
                return null;
            }
        }
        throw JSONUtil.error("Bad JSON starting character '" + characterIterator.current() + "'", characterIterator);
    }

    private static Map parseObject(CharacterIterator characterIterator) {
        characterIterator.next();
        JSONUtil.parseWhitespace(characterIterator);
        if (characterIterator.current() == '}') {
            characterIterator.next();
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (true) {
            if (characterIterator.current() != '\"') {
                throw JSONUtil.error("expected a string start '\"' but was '" + characterIterator.current() + "'", characterIterator);
            }
            String string = JSONUtil.parseString(characterIterator);
            if (hashMap.containsKey(string)) {
                throw JSONUtil.error("' already definedkey '" + string, characterIterator);
            }
            JSONUtil.parseWhitespace(characterIterator);
            if (characterIterator.current() != ':') {
                throw JSONUtil.error("expected a pair separator ':' but was '" + characterIterator.current() + "'", characterIterator);
            }
            characterIterator.next();
            JSONUtil.parseWhitespace(characterIterator);
            Object object = JSONUtil.parseValue(characterIterator);
            hashMap.put(string, object);
            JSONUtil.parseWhitespace(characterIterator);
            if (characterIterator.current() != ',') break;
            characterIterator.next();
            JSONUtil.parseWhitespace(characterIterator);
        }
        if (characterIterator.current() != '}') {
            throw JSONUtil.error("expected an object close '}' but was '" + characterIterator.current() + "'", characterIterator);
        }
        characterIterator.next();
        return hashMap;
    }

    private static List parseArray(CharacterIterator characterIterator) {
        characterIterator.next();
        JSONUtil.parseWhitespace(characterIterator);
        if (characterIterator.current() == ']') {
            characterIterator.next();
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (true) {
            Object object = JSONUtil.parseValue(characterIterator);
            arrayList.add(object);
            JSONUtil.parseWhitespace(characterIterator);
            if (characterIterator.current() != ',') break;
            characterIterator.next();
            JSONUtil.parseWhitespace(characterIterator);
        }
        if (characterIterator.current() != ']') {
            throw JSONUtil.error("expected an array close ']' but was '" + characterIterator.current() + "'", characterIterator);
        }
        characterIterator.next();
        return arrayList;
    }

    private static void parseText(String string, CharacterIterator characterIterator) {
        int n = string.length();
        char c = characterIterator.current();
        int n2 = 0;
        while (n2 < n) {
            if (c != string.charAt(n2)) {
                throw JSONUtil.error("expected to parse '" + string + "' but character " + (n2 + 1) + " was '" + c + "'", characterIterator);
            }
            c = characterIterator.next();
            ++n2;
        }
    }

    private static Object parseNumber(CharacterIterator characterIterator) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = characterIterator.current();
        while (Character.isDigit(c) || c == '-' || c == '+' || c == '.' || c == 'e' || c == 'E') {
            stringBuffer.append(c);
            c = characterIterator.next();
        }
        try {
            return new BigDecimal(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw JSONUtil.error("expected a number but was '" + stringBuffer.toString() + "'", characterIterator);
        }
    }

    private static String parseString(CharacterIterator characterIterator) {
        char c = characterIterator.next();
        if (c == '\"') {
            characterIterator.next();
            return EMPTY_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (c != '\"') {
            block15: {
                block16: {
                    if (Character.isISOControl(c)) {
                        throw JSONUtil.error("illegal iso control character: '" + Integer.toHexString(c) + "'", characterIterator);
                    }
                    if (c != '\\') break block16;
                    c = characterIterator.next();
                    switch (c) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            stringBuffer.append(c);
                            break block15;
                        }
                        case 'b': {
                            stringBuffer.append('\b');
                            break block15;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            break block15;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            break block15;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            break block15;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            break block15;
                        }
                        case 'u': {
                            StringBuffer stringBuffer2 = new StringBuffer(4);
                            int n = 0;
                            while (n < 4) {
                                stringBuffer2.append(characterIterator.next());
                                ++n;
                            }
                            try {
                                stringBuffer.append((char)Integer.parseInt(stringBuffer2.toString(), 16));
                                break block15;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw JSONUtil.error("expected a unicode hex number but was '" + stringBuffer2.toString() + "'", characterIterator);
                            }
                        }
                        default: {
                            throw JSONUtil.error("illegal escape character '" + c + "'", characterIterator);
                        }
                    }
                }
                stringBuffer.append(c);
            }
            c = characterIterator.next();
        }
        c = characterIterator.next();
        return stringBuffer.toString();
    }

    private static void writeValue(Object object, StringBuffer stringBuffer) {
        if (object == null) {
            stringBuffer.append(NULL);
        } else if (object instanceof Boolean || object instanceof Number) {
            stringBuffer.append(object.toString());
        } else if (object instanceof String) {
            JSONUtil.writeString((String)object, stringBuffer);
        } else if (object instanceof Collection) {
            JSONUtil.writeArray((Collection)object, stringBuffer);
        } else if (object instanceof Map) {
            JSONUtil.writeObject((Map)object, stringBuffer);
        } else {
            throw JSONUtil.error("Unexpected object instance type was '" + object.getClass().getName() + "'");
        }
    }

    private static void writeObject(Map map, StringBuffer stringBuffer) {
        stringBuffer.append('{');
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) {
                throw JSONUtil.error("Map keys must be an instance of String but was '" + k.getClass().getName() + "'");
            }
            JSONUtil.writeString((String)k, stringBuffer);
            stringBuffer.append(':');
            JSONUtil.writeValue(map.get(k), stringBuffer);
            stringBuffer.append(',');
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
            stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
        } else {
            stringBuffer.append('}');
        }
    }

    private static void writeArray(Collection collection, StringBuffer stringBuffer) {
        stringBuffer.append('[');
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JSONUtil.writeValue(iterator.next(), stringBuffer);
            stringBuffer.append(',');
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
            stringBuffer.setCharAt(stringBuffer.length() - 1, ']');
        } else {
            stringBuffer.append(']');
        }
    }

    private static void writeString(String string, StringBuffer stringBuffer) {
        stringBuffer.append('\"');
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        stringBuffer.append("\\u");
                        String string2 = Integer.toHexString(c);
                        int n3 = string2.length();
                        while (n3 < 4) {
                            stringBuffer.append('0');
                            ++n3;
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        stringBuffer.append('\"');
    }
}

