/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.server.bespin;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.server.bespin.JSONUtil;

public class MarkersServlet
extends HttpServlet {
    private IWorkspace workspace;

    private synchronized IWorkspace getWorkspace() {
        if (this.workspace == null) {
            new InstanceScope().getNode("org.eclipse.core.resources").putBoolean("refresh.enabled", true);
            this.workspace = ResourcesPlugin.getWorkspace();
        }
        return this.workspace;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        if (string.startsWith("/at/")) {
            String string2 = string.substring("/at".length());
            IResource iResource = this.getWorkspace().getRoot().findMember((IPath)new Path(string2));
            if (iResource.getType() != 1) {
                httpServletResponse.setStatus(405);
                return;
            }
            PrintWriter printWriter = httpServletResponse.getWriter();
            try {
                IMarker[] iMarkerArray = iResource.findMarkers(null, true, 0);
                httpServletResponse.setStatus(200);
                httpServletResponse.setContentType("application/json; charset=UTF-8");
                ArrayList arrayList = new ArrayList();
                int n = 0;
                while (n < iMarkerArray.length) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("message", ("" + iMarkerArray[n].getAttribute("message")).replace('\"', '\''));
                    hashMap.put("severity", ("" + iMarkerArray[n].getAttribute("severity")).replace('\"', '\''));
                    hashMap.put("line", iMarkerArray[n].getAttribute("lineNumber"));
                    arrayList.add(hashMap);
                    ++n;
                }
                printWriter.write(JSONUtil.write(arrayList));
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace(printWriter);
                httpServletResponse.setStatus(500);
                return;
            }
        }
        super.doGet(httpServletRequest, httpServletResponse);
    }
}

