/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.server.bespin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.e4.server.bespin.Activator;
import org.eclipse.e4.server.bespin.JSONUtil;

public class SettingsServlet
extends HttpServlet {
    private File users = Activator.bundleContext.getDataFile("users");

    public SettingsServlet() {
        this.users.mkdir();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession == null) {
            httpServletResponse.setStatus(401);
            return;
        }
        String string2 = (String)httpSession.getAttribute("username");
        if (string2 == null) {
            httpServletResponse.setStatus(401);
            return;
        }
        Map map = this.loadUserSettingsMap(string2);
        if (map == null) {
            httpServletResponse.setStatus(401);
            return;
        }
        if (string.equals("/")) {
            httpServletResponse.setContentType("application/json; charset=UTF-8");
            httpServletResponse.getWriter().write(JSONUtil.write(map));
            return;
        }
        String string3 = string.substring(1);
        String string4 = (String)map.get(string3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string3, string4);
        httpServletResponse.setContentType("application/json; charset=UTF-8");
        httpServletResponse.getWriter().write(JSONUtil.write(hashMap));
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        if (string.equals("/")) {
            HttpSession httpSession = httpServletRequest.getSession();
            if (httpSession == null) {
                httpServletResponse.setStatus(401);
                return;
            }
            String string2 = (String)httpSession.getAttribute("username");
            if (string2 == null) {
                httpServletResponse.setStatus(401);
                return;
            }
            Map map = this.loadUserSettingsMap(string2);
            if (map == null) {
                httpServletResponse.setStatus(401);
                return;
            }
            Enumeration enumeration = httpServletRequest.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                map.put(string3, httpServletRequest.getParameter(string3));
            }
            this.saveUserSettingsMap(string2, map);
            return;
        }
        super.doPost(httpServletRequest, httpServletResponse);
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession == null) {
            httpServletResponse.setStatus(401);
            return;
        }
        String string2 = (String)httpSession.getAttribute("username");
        if (string2 == null) {
            httpServletResponse.setStatus(401);
            return;
        }
        Map map = this.loadUserSettingsMap(string2);
        if (map == null) {
            httpServletResponse.setStatus(401);
            return;
        }
        if (string.equals("/")) {
            map.clear();
        }
        String string3 = string.substring(1);
        map.remove(string3);
        this.saveUserSettingsMap(string2, map);
    }

    private void saveUserSettingsMap(String string, Map map) {
        File file = new File(this.users, String.valueOf(string) + "_settings.properties");
        Properties properties = (Properties)map;
        try {
            properties.store(new FileOutputStream(file), null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Map loadUserSettingsMap(String string) {
        Properties properties = new Properties();
        File file = new File(this.users, String.valueOf(string) + "_settings.properties");
        if (!file.isFile()) {
            return properties;
        }
        try {
            properties.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
    }
}

