/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.ILogger;
import org.eclipse.e4.xwt.IMetaclassFactory;
import org.eclipse.e4.xwt.IStyle;
import org.eclipse.e4.xwt.ResourceDictionary;
import org.eclipse.e4.xwt.Tracking;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.converters.BindingToObject;
import org.eclipse.e4.xwt.converters.DateToString;
import org.eclipse.e4.xwt.converters.ObjectToObject;
import org.eclipse.e4.xwt.converters.ObjectToString;
import org.eclipse.e4.xwt.converters.StringToBoolean;
import org.eclipse.e4.xwt.converters.StringToColor;
import org.eclipse.e4.xwt.converters.StringToDouble;
import org.eclipse.e4.xwt.converters.StringToFloat;
import org.eclipse.e4.xwt.converters.StringToFont;
import org.eclipse.e4.xwt.converters.StringToImage;
import org.eclipse.e4.xwt.converters.StringToIntArray;
import org.eclipse.e4.xwt.converters.StringToInteger;
import org.eclipse.e4.xwt.converters.StringToPoint;
import org.eclipse.e4.xwt.converters.StringToRectangle;
import org.eclipse.e4.xwt.converters.StringToURL;
import org.eclipse.e4.xwt.dataproviders.IDataProvider;
import org.eclipse.e4.xwt.dataproviders.impl.ObjectDataProvider;
import org.eclipse.e4.xwt.dataproviders.impl.XMLDataProvider;
import org.eclipse.e4.xwt.impl.Core;
import org.eclipse.e4.xwt.impl.LoadingContext;
import org.eclipse.e4.xwt.impl.NameScope;
import org.eclipse.e4.xwt.input.ICommand;
import org.eclipse.e4.xwt.javabean.ResourceLoaderFactory;
import org.eclipse.e4.xwt.javabean.ValueConvertorRegister;
import org.eclipse.e4.xwt.javabean.metadata.BindingMetaclass;
import org.eclipse.e4.xwt.javabean.metadata.ComboBoxCellEditorMetaclass;
import org.eclipse.e4.xwt.javabean.metadata.ExpandItemHeightAction;
import org.eclipse.e4.xwt.javabean.metadata.Metaclass;
import org.eclipse.e4.xwt.javabean.metadata.MetaclassManager;
import org.eclipse.e4.xwt.javabean.metadata.TableEditorMetaclass;
import org.eclipse.e4.xwt.javabean.metadata.TableViewerColumnMetaClass;
import org.eclipse.e4.xwt.javabean.metadata.properties.DataProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.DynamicBeanProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.DynamicProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableColumnEditorProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableEditorDynamicProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableItemEditorProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableItemProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableViewerColumnTextProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableViewerColumnWidthProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableViewerColumnsProperty;
import org.eclipse.e4.xwt.jface.ComboBoxCellEditor;
import org.eclipse.e4.xwt.jface.DefaultCellModifier;
import org.eclipse.e4.xwt.jface.DefaultLabelProvider;
import org.eclipse.e4.xwt.jface.JFacesHelper;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.utils.ResourceManager;
import org.eclipse.e4.xwt.utils.UserDataHelper;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWT {
    public static final String CONTAINER_PROPERTY = "XWT.Container";
    public static final String INIT_STYLE_PROPERTY = "XWT.Style";
    public static final String DEFAULT_STYLES_PROPERTY = "XWT.DefaultStyles";
    public static final String DISBALE_STYLES_PROPERTY = "XWT.DisabledStyles";
    public static final String DATACONTEXT_PROPERTY = "XWT.DataContext";
    public static final String RESOURCE_DICTIONARY_PROPERTY = "XWT.Resources";
    static Core core = new Core(new ResourceLoaderFactory());
    private static boolean initialized = false;
    private static ILoadingContext loadingContext;
    private static Set<Tracking> trackingSet;
    private static Map<String, ICommand> commands;
    private static ILogger logger;
    private static Collection<IStyle> defaultStyles;
    private static Collection<IDataProvider> dataProviders;

    static {
        trackingSet = new HashSet<Tracking>();
        commands = new HashMap<String, ICommand>();
        defaultStyles = new ArrayList<IStyle>();
        dataProviders = new ArrayList<IDataProvider>();
    }

    public static ILogger getLogger() {
        if (logger == null) {
            return Core.nullLog;
        }
        return logger;
    }

    public static void setLogger(ILogger iLogger) {
        logger = iLogger;
    }

    public static boolean IsInitialized() {
        return initialized;
    }

    public static String getNamespace(Class<?> clazz) {
        if (XWT.getMetaclass(clazz) != null) {
            return "http://www.eclipse.org/xwt/presentation";
        }
        Package package_ = clazz.getPackage();
        if (package_ == null) {
            return "clr-namespace:";
        }
        return "clr-namespace:" + clazz.getPackage().getName();
    }

    public static String getElementName(Object object) {
        return UserDataHelper.getElementName(object);
    }

    public static NameScope findNameContext(Widget widget) {
        return UserDataHelper.findNameContext(widget);
    }

    public static Object findElementByName(Widget widget, String string) {
        NameScope nameScope = UserDataHelper.findNameContext(widget);
        if (nameScope != null) {
            return nameScope.getObject(string);
        }
        return null;
    }

    public static Object getDataContext(Widget widget) {
        return UserDataHelper.getDataContext(widget);
    }

    public static void setDataContext(Widget widget, Object object) {
        UserDataHelper.setDataContext(widget, object);
    }

    public static Object getCLR(Widget widget) {
        return UserDataHelper.getCLR(widget);
    }

    public static Shell findShell(Widget widget) {
        return UserDataHelper.findShell(widget);
    }

    public static Composite findCompositeParent(Widget widget) {
        return UserDataHelper.findCompositeParent(widget);
    }

    public static IMetaclass getMetaclass(Object object) {
        return core.getMetaclass(object);
    }

    public static synchronized Control load(URL uRL) throws Exception {
        return XWT.loadWithOptions(uRL, (Map<String, Object>)Collections.EMPTY_MAP);
    }

    public static synchronized Control load(URL uRL, Object object) throws Exception {
        return XWT.load(null, uRL, object);
    }

    public static synchronized Control load(Composite composite, URL uRL) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(CONTAINER_PROPERTY, composite);
        return XWT.loadWithOptions(uRL, hashMap);
    }

    public static synchronized Control load(Composite composite, URL uRL, Object object) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(CONTAINER_PROPERTY, composite);
        hashMap.put(DATACONTEXT_PROPERTY, object);
        return XWT.loadWithOptions(uRL, hashMap);
    }

    public static synchronized Control load(Composite composite, Class<?> clazz, Object object) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(CONTAINER_PROPERTY, composite);
        hashMap.put(DATACONTEXT_PROPERTY, object);
        return XWT.loadWithOptions(clazz, hashMap);
    }

    protected static Map<String, Object> prepareOptions(Map<String, Object> map) {
        Boolean bl = (Boolean)map.get(DISBALE_STYLES_PROPERTY);
        if (!Boolean.TRUE.equals(bl)) {
            Object object3;
            Collection<IStyle> collection = XWT.getDefaultStyles();
            Object object2 = map.get(DEFAULT_STYLES_PROPERTY);
            if (object2 != null) {
                if (object2 instanceof IStyle) {
                    collection.add((IStyle)object2);
                } else if (object2 instanceof Collection) {
                    for (Object object3 : (Collection)object2) {
                        collection.add((IStyle)object3);
                    }
                } else if (object2 instanceof Object[]) {
                    Object[] objectArray = (Object[])object2;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        object3 = objectArray[n2];
                        if (!(object3 instanceof IStyle)) {
                            throw new XWTException("IStyle is expected in [styles] paramters.");
                        }
                        collection.add((IStyle)object3);
                        ++n2;
                    }
                }
                map.remove(DEFAULT_STYLES_PROPERTY);
            }
            if (!collection.isEmpty()) {
                object3 = (ResourceDictionary)map.get(RESOURCE_DICTIONARY_PROPERTY);
                if (object3 == null) {
                    object3 = new ResourceDictionary();
                    if (map == Collections.EMPTY_MAP) {
                        map = new HashMap<String, Object>();
                    }
                    map.put(RESOURCE_DICTIONARY_PROPERTY, object3);
                }
                ((HashMap)object3).put(DEFAULT_STYLES_PROPERTY, collection);
            }
        }
        return map;
    }

    public static synchronized Control loadWithOptions(Class<?> clazz, Map<String, Object> map) throws Exception {
        ILoadingContext iLoadingContext = XWT.getLoadingContext();
        try {
            XWT.setLoadingContext(new LoadingContext(clazz.getClassLoader()));
            map = XWT.prepareOptions(map);
            Control control = XWT.loadWithOptions(clazz.getResource(String.valueOf(clazz.getSimpleName()) + ".xwt"), map);
            return control;
        }
        finally {
            XWT.setLoadingContext(iLoadingContext);
        }
    }

    public static synchronized void open(URL uRL) throws Exception {
        XWT.open(uRL, Collections.EMPTY_MAP);
    }

    public static synchronized Control load(Composite composite, InputStream inputStream, URL uRL, Object object) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(CONTAINER_PROPERTY, composite);
        hashMap.put(DATACONTEXT_PROPERTY, object);
        return XWT.loadWithOptions(inputStream, uRL, hashMap);
    }

    public static synchronized void open(URL uRL, Object object) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(DATACONTEXT_PROPERTY, object);
        XWT.open(uRL, hashMap);
    }

    public static synchronized void open(final URL uRL, final Map<String, Object> map) throws Exception {
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)Display.getDefault()), (Runnable)new Runnable(){

            public void run() {
                try {
                    Control control = XWT.loadWithOptions(uRL, (Map<String, Object>)map);
                    Shell shell = control.getShell();
                    shell.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent disposeEvent) {
                            ResourceManager.resources.dispose();
                        }
                    });
                    shell.open();
                    while (!shell.isDisposed()) {
                        if (shell.getDisplay().readAndDispatch()) continue;
                        shell.getDisplay().sleep();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public static Object convertFrom(IMetaclass iMetaclass, String string) {
        Class<?> clazz = iMetaclass.getType();
        return XWT.convertFrom(clazz, string);
    }

    public static Object convertFrom(Class<?> clazz, String string) {
        if (clazz == String.class) {
            return string;
        }
        IConverter iConverter = XWT.findConvertor(String.class, clazz);
        if (iConverter != null) {
            return iConverter.convert((Object)string);
        }
        throw new XWTException("Converter is missing of type: " + clazz.getName());
    }

    public static synchronized Control loadWithOptions(URL uRL, Map<String, Object> map) throws Exception {
        XWT.checkInitialize();
        Composite composite = (Composite)map.get(CONTAINER_PROPERTY);
        ILoadingContext iLoadingContext = composite != null ? XWT.getLoadingContext(composite) : XWT.getLoadingContext();
        map = XWT.prepareOptions(map);
        Control control = core.load(iLoadingContext, uRL, map);
        return control;
    }

    public static synchronized Control load(InputStream inputStream, URL uRL) throws Exception {
        return XWT.loadWithOptions(inputStream, uRL, Collections.EMPTY_MAP);
    }

    public static synchronized Control loadWithOptions(InputStream inputStream, URL uRL, Map<String, Object> map) throws Exception {
        XWT.checkInitialize();
        Composite composite = (Composite)map.get(CONTAINER_PROPERTY);
        ILoadingContext iLoadingContext = composite != null ? XWT.getLoadingContext(composite) : XWT.getLoadingContext();
        map = XWT.prepareOptions(map);
        Control control = core.load(iLoadingContext, inputStream, uRL, map);
        return control;
    }

    public static IMetaclass[] getAllMetaclasses() {
        XWT.checkInitialize();
        Collection<IMetaclass> collection = core.getAllMetaclasses("http://www.eclipse.org/xwt/presentation");
        return collection.toArray(new IMetaclass[collection.size()]);
    }

    public static IMetaclass getMetaclass(String string, String string2) {
        XWT.checkInitialize();
        return core.getMetaclass(XWT.getLoadingContext(), string, string2);
    }

    public static IMetaclass registerMetaclass(Class<?> clazz) {
        XWT.checkInitialize();
        return XWT.register(clazz, "http://www.eclipse.org/xwt/presentation");
    }

    public static void registerMetaclassFactory(IMetaclassFactory iMetaclassFactory) {
        XWT.checkInitialize();
        core.registerMetaclassFactory(iMetaclassFactory);
    }

    public static IMetaclass register(Class<?> clazz, String string) {
        XWT.checkInitialize();
        return core.registerMetaclass(clazz, string);
    }

    public static ConverterService getConverterService() {
        XWT.checkInitialize();
        ConverterService converterService = (ConverterService)core.getService(ConverterService.class);
        if (converterService == null) {
            converterService = new ConverterService();
            core.registerService(ConverterService.class, converterService);
            converterService.register(Object.class, new IConverter(){

                public Object convert(Object object) {
                    return null;
                }

                public Object getFromType() {
                    return Object.class;
                }

                public Object getToType() {
                    return String.class;
                }
            });
        }
        return converterService;
    }

    private static Class<?> normalizedType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    public static IConverter findConvertor(Class<?> clazz, Class<?> clazz2) {
        XWT.checkInitialize();
        clazz = XWT.normalizedType(clazz);
        clazz2 = XWT.normalizedType(clazz2);
        if (clazz == clazz2 || clazz != Object.class && clazz.isAssignableFrom(clazz2)) {
            return ObjectToObject.instance;
        }
        ValueConvertorRegister valueConvertorRegister = (ValueConvertorRegister)core.getService(ValueConvertorRegister.class);
        return valueConvertorRegister.findConverter(clazz, clazz2);
    }

    public static void registerConvertor(IConverter iConverter) {
        XWT.checkInitialize();
        Class clazz = (Class)iConverter.getFromType();
        Class clazz2 = (Class)iConverter.getToType();
        ValueConvertorRegister valueConvertorRegister = (ValueConvertorRegister)core.getService(ValueConvertorRegister.class);
        valueConvertorRegister.register(clazz, clazz2, iConverter);
    }

    protected static void checkInitialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        core.registerService(ValueConvertorRegister.class, new ValueConvertorRegister());
        core.registerMetaclassManager("http://www.eclipse.org/xwt/presentation", new MetaclassManager(null, null));
        core.registerMetaclass(new BindingMetaclass(), "http://www.eclipse.org/xwt/presentation");
        core.registerMetaclass(new TableEditorMetaclass(core.getMetaclass(ControlEditor.class)), "http://www.eclipse.org/xwt/presentation");
        XWT.registerConvertor(new ObjectToString());
        XWT.registerConvertor(new DateToString());
        XWT.registerConvertor(new StringToInteger());
        XWT.registerConvertor(new StringToFloat());
        XWT.registerConvertor(new StringToDouble());
        XWT.registerConvertor(new StringToBoolean());
        XWT.registerConvertor(new StringToIntArray());
        XWT.registerConvertor(new BindingToObject());
        XWT.registerConvertor(new StringToColor());
        XWT.registerConvertor(new StringToFont());
        XWT.registerConvertor(new StringToImage());
        XWT.registerConvertor(new StringToPoint());
        XWT.registerConvertor(new StringToRectangle());
        XWT.registerConvertor(new StringToURL());
        Class<Browser> clazz = Browser.class;
        Metaclass metaclass = (Metaclass)XWT.registerMetaclass(clazz);
        metaclass.addProperty(new DynamicProperty(clazz, String.class, "url"));
        Metaclass metaclass2 = (Metaclass)XWT.registerMetaclass(Button.class);
        metaclass2.addProperty(new DataProperty(ICommand.class, "Command", "__XWT.Command"));
        XWT.registerMetaclass(Canvas.class);
        XWT.registerMetaclass(Caret.class);
        XWT.registerMetaclass(Combo.class);
        XWT.registerMetaclass(Composite.class);
        XWT.registerMetaclass(CoolBar.class);
        XWT.registerMetaclass(CoolItem.class);
        XWT.registerMetaclass(DateTime.class);
        XWT.registerMetaclass(Decorations.class);
        XWT.registerMetaclass(ExpandBar.class);
        IMetaclass iMetaclass = XWT.registerMetaclass(ExpandItem.class);
        iMetaclass.findProperty("control").addSetPostAction(new ExpandItemHeightAction());
        XWT.registerMetaclass(Group.class);
        XWT.registerMetaclass(IME.class);
        XWT.registerMetaclass(Label.class);
        XWT.registerMetaclass(Link.class);
        XWT.registerMetaclass(Listener.class);
        XWT.registerMetaclass(List.class);
        XWT.registerMetaclass(Menu.class);
        Metaclass metaclass3 = (Metaclass)XWT.registerMetaclass(MenuItem.class);
        metaclass3.addProperty(new DataProperty(ICommand.class, "Command", "__XWT.Command"));
        XWT.registerMetaclass(MessageBox.class);
        XWT.registerMetaclass(ProgressBar.class);
        XWT.registerMetaclass(Sash.class);
        XWT.registerMetaclass(Scale.class);
        XWT.registerMetaclass(ScrollBar.class);
        XWT.registerMetaclass(Shell.class);
        XWT.registerMetaclass(Slider.class);
        XWT.registerMetaclass(Spinner.class);
        XWT.registerMetaclass(TabFolder.class);
        XWT.registerMetaclass(TabItem.class);
        XWT.registerMetaclass(Table.class);
        clazz = TableItem.class;
        Metaclass metaclass4 = (Metaclass)XWT.registerMetaclass(clazz);
        metaclass4.addProperty(new TableItemProperty());
        metaclass4.addProperty(new TableItemEditorProperty());
        metaclass4.addProperty(new DynamicBeanProperty(TableItem.class, String[].class, "texts", "text"));
        XWT.registerMetaclass(TableItemProperty.Cell.class);
        XWT.registerMetaclass(ControlEditor.class);
        XWT.registerMetaclass(TableEditor.class);
        IMetaclass iMetaclass2 = XWT.getMetaclass(TableEditor.class);
        iMetaclass2.addProperty(new TableEditorDynamicProperty());
        clazz = TableColumn.class;
        metaclass4 = (Metaclass)XWT.registerMetaclass(clazz);
        metaclass4.addProperty(new TableColumnEditorProperty());
        XWT.registerMetaclass(Text.class);
        XWT.registerMetaclass(ToolBar.class);
        XWT.registerMetaclass(ToolItem.class);
        XWT.registerMetaclass(ToolTip.class);
        XWT.registerMetaclass(Tracker.class);
        XWT.registerMetaclass(Tray.class);
        XWT.registerMetaclass(Tree.class);
        XWT.registerMetaclass(TreeColumn.class);
        XWT.registerMetaclass(TreeItem.class);
        clazz = TreeItem.class;
        metaclass4 = (Metaclass)XWT.registerMetaclass(clazz);
        metaclass4.addProperty(new DynamicBeanProperty(TreeItem.class, String[].class, "texts", "text"));
        XWT.registerMetaclass(FillLayout.class);
        XWT.registerMetaclass(FormAttachment.class);
        XWT.registerMetaclass(FormData.class);
        XWT.registerMetaclass(FormLayout.class);
        XWT.registerMetaclass(GridData.class);
        XWT.registerMetaclass(GridLayout.class);
        XWT.registerMetaclass(RowData.class);
        XWT.registerMetaclass(RowLayout.class);
        XWT.registerMetaclass(StackLayout.class);
        XWT.registerMetaclass(CLabel.class);
        XWT.registerMetaclass(CCombo.class);
        XWT.registerMetaclass(CTabFolder.class);
        XWT.registerMetaclass(CTabItem.class);
        XWT.registerMetaclass(SashForm.class);
        XWT.registerMetaclass(StyledText.class);
        clazz = Widget.class;
        metaclass4 = (Metaclass)XWT.registerMetaclass(clazz);
        metaclass4.addProperty(new DataProperty("DataContext", "__XWT.Datacontext"));
        Class<?>[] classArray = JFacesHelper.getSupportedElements();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz2 = classArray[n2];
            XWT.registerMetaclass(clazz2);
            ++n2;
        }
        core.registerMetaclass(new ComboBoxCellEditorMetaclass(core.getMetaclass(ComboBoxCellEditor.class.getSuperclass())), "http://www.eclipse.org/xwt/presentation");
        clazz = TableViewer.class;
        metaclass4 = (Metaclass)core.getMetaclass(clazz);
        if (metaclass4 != null) {
            metaclass4.addProperty(new DynamicBeanProperty(clazz, String[].class, "columnProperties", "columnProperties"));
            metaclass4.addProperty(new TableViewerColumnsProperty());
        }
        clazz = TableViewerColumn.class;
        core.registerMetaclass(new TableViewerColumnMetaClass(core.getMetaclass(clazz.getSuperclass())), "http://www.eclipse.org/xwt/presentation");
        metaclass4 = (Metaclass)core.getMetaclass(clazz);
        metaclass4.addProperty(new TableViewerColumnWidthProperty());
        metaclass4.addProperty(new TableViewerColumnTextProperty());
        XWT.registerMetaclass(DefaultCellModifier.class);
        XWT.registerMetaclass(DefaultLabelProvider.class);
        XWT.registerMetaclass(XMLDataProvider.class);
        XWT.registerMetaclass(ObjectDataProvider.class);
    }

    public static ILoadingContext findLoadingContext(Object object) {
        XWT.checkInitialize();
        return XWT.getLoadingContext();
    }

    public static ILoadingContext getLoadingContext(Composite composite) {
        XWT.checkInitialize();
        return XWT.getLoadingContext();
    }

    public static ILoadingContext getLoadingContext() {
        XWT.checkInitialize();
        if (loadingContext == null) {
            return LoadingContext.defaultLoadingContext;
        }
        return loadingContext;
    }

    public static void setLoadingContext(ILoadingContext iLoadingContext) {
        XWT.checkInitialize();
        loadingContext = iLoadingContext;
    }

    public static void addTracking(Tracking tracking) {
        if (!trackingSet.contains((Object)tracking)) {
            trackingSet.add(tracking);
        }
    }

    public static boolean isTracking(Tracking tracking) {
        return trackingSet.contains((Object)tracking);
    }

    public static Set<Tracking> getTrackings() {
        return trackingSet;
    }

    public static void removeTracking(Tracking tracking) {
        if (trackingSet.contains((Object)tracking)) {
            trackingSet.remove((Object)tracking);
        }
    }

    public static void registerCommand(String string, ICommand iCommand) {
        commands.put(string, iCommand);
    }

    public static ICommand getCommand(String string) {
        return commands.get(string);
    }

    public static Map<String, ICommand> getCommands() {
        return commands;
    }

    public static void unregisterCommand(String string) {
        commands.remove(string);
    }

    public static void addDefaultStyle(IStyle iStyle) {
        defaultStyles.add(iStyle);
    }

    public static void removeDefaultStyle(IStyle iStyle) {
        defaultStyles.remove(iStyle);
    }

    public static Collection<IStyle> getDefaultStyles() {
        return new ArrayList<IStyle>(defaultStyles);
    }

    public static void addDataProvider(IDataProvider iDataProvider) {
        if (iDataProvider == null) {
            return;
        }
        if (!dataProviders.contains(iDataProvider)) {
            dataProviders.add(iDataProvider);
        }
    }

    public static void removeDataProvider(IDataProvider iDataProvider) {
        if (iDataProvider == null) {
            return;
        }
        if (dataProviders.contains(iDataProvider)) {
            dataProviders.remove(iDataProvider);
        }
    }

    public static Collection<IDataProvider> getDataProviders() {
        return dataProviders;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConverterService {
        protected Map<Class<?>, IConverter> converters = new HashMap();

        ConverterService() {
        }

        public IConverter getConverter(Class<?> clazz) {
            IConverter iConverter = this.converters.get(clazz);
            if (iConverter != null) {
                return iConverter;
            }
            return null;
        }

        public void register(Class<?> clazz, IConverter iConverter) {
            this.converters.put(clazz, iConverter);
        }
    }
}

