/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWTMaps {
    private static final Map<String, Integer> styles = new HashMap<String, Integer>();
    private static final Map<String, Integer> colors = new HashMap<String, Integer>();
    private static final Map<String, Integer> events = new HashMap<String, Integer>();
    private static final Map<String, Integer> accelerators = new HashMap<String, Integer>();

    private XWTMaps() {
    }

    private static void checkAndInit() {
        if (styles.isEmpty() || colors.isEmpty() || events.isEmpty() || accelerators.isEmpty()) {
            XWTMaps.init();
        }
    }

    private static void init() {
        styles.put("SWT.NONE", 0);
        styles.put("SWT.FILL", 4);
        styles.put("SWT.BORDER", 2048);
        styles.put("SWT.PUSH", 8);
        styles.put("SWT.CHECK", 32);
        styles.put("SWT.RADIO", 16);
        styles.put("SWT.TOGGLE", 2);
        styles.put("SWT.ARROW", 4);
        styles.put("SWT.ARROW_DOWN", 0x1000002);
        styles.put("SWT.ARROW_LEFT", 0x1000003);
        styles.put("SWT.ARROW_RIGHT", 0x1000004);
        styles.put("SWT.ARROW_UP", 0x1000001);
        styles.put("SWT.FLAT", 0x800000);
        styles.put("SWT.DROP_DOWN", 4);
        styles.put("SWT.SIMPLE", 64);
        styles.put("SWT.READ_ONLY", 8);
        styles.put("SWT.LEFT", 16384);
        styles.put("SWT.UP", 128);
        styles.put("SWT.DOWN", 1024);
        styles.put("SWT.CENTER", 0x1000000);
        styles.put("SWT.RIGHT", 131072);
        styles.put("SWT.H_SCROLL", 256);
        styles.put("SWT.V_SCROLL", 512);
        styles.put("SWT.DATE", 32);
        styles.put("SWT.TIME", 128);
        styles.put("SWT.CALENDAR", 1024);
        styles.put("SWT.SHORT", 32768);
        styles.put("SWT.MEDIUM", 65536);
        styles.put("SWT.LONG", 0x10000000);
        styles.put("SWT.WRAP", 64);
        styles.put("SWT.HORIZONTAL", 256);
        styles.put("SWT.VERTICAL", 512);
        styles.put("SWT.SEPARATOR", 2);
        styles.put("SWT.SHADOW_IN", 4);
        styles.put("SWT.SHADOW_NONE", 32);
        styles.put("SWT.SHADOW_OUT", 8);
        styles.put("SWT.NO_TRIM", 8);
        styles.put("SWT.CLOSE", 64);
        styles.put("SWT.MIN", 128);
        styles.put("SWT.MAX", 1024);
        styles.put("SWT.RESIZE", 16);
        styles.put("SWT.TOOL", 4);
        styles.put("SWT.ON_TOP", 16384);
        styles.put("SWT.MODELESS", 0);
        styles.put("SWT.PRIMARY_MODAL", 32768);
        styles.put("SWT.APPLICATION_MODAL", 65536);
        styles.put("SWT.SYSTEM_MODAL", 131072);
        styles.put("SWT.TITLE", 32);
        styles.put("SWT.SINGLE", 4);
        styles.put("SWT.MULTI", 2);
        styles.put("SWT.PASSWORD", 0x400000);
        styles.put("SWT.SEARCH", 128);
        styles.put("SWT.CANCEL", 256);
        styles.put("SWT.ICON", 1);
        styles.put("SWT.ICON_ERROR", 1);
        styles.put("SWT.ICON_INFORMATION", 2);
        styles.put("SWT.ICON_QUESTION", 4);
        styles.put("SWT.ICON_WARNING", 8);
        styles.put("SWT.ICON_WORKING", 16);
        styles.put("SWT.SHADOW_ETCHED_IN", 16);
        styles.put("SWT.SHADOW_ETCHED_OUT", 64);
        styles.put("SWT.BALLOON", 4096);
        styles.put("SWT.NO_BACKGROUND", 262144);
        styles.put("SWT.NO_FOCUS", 524288);
        styles.put("SWT.NO_MERGE_PAINTS", 0x200000);
        styles.put("SWT.NO_REDRAW_RESIZE", 0x100000);
        styles.put("SWT.DOUBLE_BUFFERED", 0x20000000);
        styles.put("SWT.SMOOTH", 65536);
        styles.put("SWT.INDETERMINATE", 2);
        styles.put("SWT.FULL_SELECTION", 65536);
        styles.put("SWT.TOP", 128);
        styles.put("SWT.BOTTOM", 1024);
        styles.put("SWT.NORMAL", 0);
        styles.put("SWT.ITALIC", 2);
        styles.put("SWT.BOLD", 1);
        styles.put("SWT.LEFT_TO_RIGHT", 0x2000000);
        styles.put("SWT.RIGHT_TO_LEFT", 0x4000000);
        styles.put("SWT.BAR", 2);
        styles.put("SWT.CASCADE", 64);
        styles.put("SWT.NO_RADIO_GROUP", 0x400000);
        styles.put("SWT.POP_UP", 8);
        styles.put("SWT.INHERIT_DEFAULT", 1);
        styles.put("SWT.INHERIT_NONE", 0);
        styles.put("SWT.INHERIT_FORCE", 2);
        colors.put("SWT.COLOR_BLACK", 2);
        colors.put("SWT.COLOR_BLUE", 9);
        colors.put("SWT.COLOR_CYAN", 13);
        colors.put("SWT.COLOR_DARK_BLUE", 10);
        colors.put("SWT.COLOR_DARK_CYAN", 14);
        colors.put("SWT.COLOR_DARK_GREEN", 6);
        colors.put("SWT.COLOR_DARK_MAGENTA", 12);
        colors.put("SWT.COLOR_DARK_RED", 4);
        colors.put("SWT.COLOR_DARK_YELLOW", 8);
        colors.put("SWT.COLOR_GRAY", 15);
        colors.put("SWT.COLOR_GREEN", 5);
        colors.put("SWT.COLOR_INFO_BACKGROUND", 29);
        colors.put("SWT.COLOR_INFO_FOREGROUND", 28);
        colors.put("SWT.COLOR_LIST_BACKGROUND", 25);
        colors.put("SWT.COLOR_LIST_FOREGROUND", 24);
        colors.put("SWT.COLOR_LIST_SELECTION", 26);
        colors.put("SWT.COLOR_LIST_SELECTION_TEXT", 27);
        colors.put("SWT.COLOR_MAGENTA", 11);
        colors.put("SWT.COLOR_RED", 3);
        colors.put("SWT.COLOR_TITLE_BACKGROUND", 31);
        colors.put("SWT.COLOR_TITLE_BACKGROUND_GRADIENT", 32);
        colors.put("SWT.COLOR_TITLE_FOREGROUND", 30);
        colors.put("SWT.COLOR_TITLE_INACTIVE_BACKGROUND", 34);
        colors.put("SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT", 35);
        colors.put("SWT.COLOR_TITLE_INACTIVE_FOREGROUND", 33);
        colors.put("SWT.COLOR_WHITE", 1);
        colors.put("SWT.COLOR_WIDGET_BACKGROUND", 22);
        colors.put("SWT.COLOR_WIDGET_BORDER", 23);
        colors.put("SWT.COLOR_WIDGET_DARK_SHADOW", 17);
        colors.put("SWT.COLOR_WIDGET_FOREGROUND", 21);
        colors.put("SWT.COLOR_WIDGET_HIGHLIGHT_SHADOW", 20);
        colors.put("SWT.COLOR_WIDGET_LIGHT_SHADOW", 19);
        colors.put("SWT.COLOR_WIDGET_NORMAL_SHADOW", 18);
        colors.put("SWT.COLOR_YELLOW", 7);
        events.put("swt.activate", 26);
        events.put("swt.arm", 30);
        events.put("swt.close", 21);
        events.put("swt.collapse", 18);
        events.put("swt.deactivate", 27);
        events.put("swt.defaultselection", 14);
        events.put("swt.deiconify", 20);
        events.put("swt.dispose", 12);
        events.put("swt.dragdetect", 29);
        events.put("swt.eraseitem", 40);
        events.put("swt.expand", 17);
        events.put("swt.focusin", 15);
        events.put("swt.focusout", 16);
        events.put("swt.hardkeydown", 33);
        events.put("swt.hardkeyup", 34);
        events.put("swt.help", 28);
        events.put("swt.hide", 23);
        events.put("swt.iconify", 19);
        events.put("swt.keydown", 1);
        events.put("swt.keyup", 2);
        events.put("swt.measureitem", 41);
        events.put("swt.menudetect", 35);
        events.put("swt.modify", 24);
        events.put("swt.mousedoubleclick", 8);
        events.put("swt.mousedown", 3);
        events.put("swt.mouseenter", 6);
        events.put("swt.mouseexit", 7);
        events.put("swt.mousehover", 32);
        events.put("swt.mousemove", 5);
        events.put("swt.mouseup", 4);
        events.put("swt.mousewheel", 37);
        events.put("swt.move", 10);
        events.put("swt.paint", 9);
        events.put("swt.paintitem", 42);
        events.put("swt.resize", 11);
        events.put("swt.selection", 13);
        events.put("swt.setdata", 36);
        events.put("swt.settings", 39);
        events.put("swt.show", 22);
        events.put("swt.traverse", 31);
        events.put("swt.verify", 25);
        events.put("swt.imecomposition", 43);
        accelerators.put("SWT.ALT", 65536);
        accelerators.put("SWT.ARROW_UP", 0x1000001);
        accelerators.put("SWT.ARROW_DOWN", 0x1000002);
        accelerators.put("SWT.ARROW_LEFT", 0x1000003);
        accelerators.put("SWT.ARROW_RIGHT", 0x1000004);
        accelerators.put("SWT.BREAK", 16777302);
        accelerators.put("SWT.CAPS_LOCK", 16777298);
        accelerators.put("SWT.CENTER", 0x1000000);
        accelerators.put("SWT.CTRL", 262144);
        accelerators.put("SWT.DEFAULT", -1);
        accelerators.put("SWT.EMBEDDED", 0x1000000);
        accelerators.put("SWT.END", 0x1000008);
        accelerators.put("SWT.F1", 0x100000A);
        accelerators.put("SWT.F2", 0x100000B);
        accelerators.put("SWT.F3", 0x100000C);
        accelerators.put("SWT.F4", 0x100000D);
        accelerators.put("SWT.F5", 0x100000E);
        accelerators.put("SWT.F6", 0x100000F);
        accelerators.put("SWT.F7", 0x1000010);
        accelerators.put("SWT.F8", 0x1000011);
        accelerators.put("SWT.F9", 0x1000012);
        accelerators.put("SWT.F10", 0x1000013);
        accelerators.put("SWT.F11", 0x1000014);
        accelerators.put("SWT.F12", 0x1000015);
        accelerators.put("SWT.HELP", 0x1000051);
        accelerators.put("SWT.HOME", 0x1000007);
        accelerators.put("SWT.IMAGE_UNDEFINED", -1);
        accelerators.put("SWT.INSERT", 0x1000009);
        accelerators.put("SWT.KEYPAD_ADD", 16777259);
        accelerators.put("SWT.KEYPAD_CR", 0x1000050);
        accelerators.put("SWT.KEYPAD_DECIMAL", 16777262);
        accelerators.put("SWT.KEYPAD_DIVIDE", 16777263);
        accelerators.put("SWT.KEYPAD_EQUAL", 16777277);
        accelerators.put("SWT.KEYPAD_MULTIPLY", 16777258);
        accelerators.put("SWT.KEYPAD_SUBTRACT", 16777261);
        accelerators.put("SWT.KEYPAD_0", 0x1000030);
        accelerators.put("SWT.KEYPAD_1", 0x1000031);
        accelerators.put("SWT.KEYPAD_2", 16777266);
        accelerators.put("SWT.KEYPAD_3", 0x1000033);
        accelerators.put("SWT.KEYPAD_4", 16777268);
        accelerators.put("SWT.KEYPAD_5", 16777269);
        accelerators.put("SWT.KEYPAD_6", 16777270);
        accelerators.put("SWT.KEYPAD_7", 16777271);
        accelerators.put("SWT.KEYPAD_8", 16777272);
        accelerators.put("SWT.KEYPAD_9", 16777273);
        accelerators.put("SWT.NUM_LOCK", 16777299);
        accelerators.put("SWT.PAUSE", 0x1000055);
        accelerators.put("SWT.PAGE_DOWN", 0x1000006);
        accelerators.put("SWT.PAGE_UP", 0x1000005);
        accelerators.put("SWT.PRINT_SCREEN", 16777303);
        accelerators.put("SWT.SCROLL_LOCK", 16777300);
        accelerators.put("SWT.SHIFT", 131072);
    }

    public static Collection<String> getStyleKeys() {
        XWTMaps.checkAndInit();
        return styles.keySet();
    }

    public static int getStyle(String string) {
        Integer n;
        if (string == null) {
            return 0;
        }
        XWTMaps.checkAndInit();
        String string2 = string.toUpperCase();
        if (!string2.startsWith("SWT.")) {
            string2 = "SWT." + string2;
        }
        return (n = styles.get(string2)) == null ? 0 : n;
    }

    public static Collection<String> getColorKeys() {
        XWTMaps.checkAndInit();
        return colors.keySet();
    }

    public static int getColor(String string) {
        Integer n;
        if (string == null || string.equals("")) {
            return 0;
        }
        XWTMaps.checkAndInit();
        String string2 = string.toUpperCase();
        if (!string2.startsWith("SWT.")) {
            string2 = "SWT." + string2;
        }
        return (n = colors.get(string2)) == null ? 0 : n;
    }

    public static Collection<String> getEventKeys() {
        XWTMaps.checkAndInit();
        return events.keySet();
    }

    public static int getEvent(String string) {
        Integer n;
        if (string == null || string.equals("")) {
            return 0;
        }
        XWTMaps.checkAndInit();
        String string2 = string.toLowerCase();
        if (!string2.startsWith("swt.")) {
            string2 = "swt." + string2;
        }
        return (n = events.get(string2)) == null ? 0 : n;
    }

    public static Collection<String> getAcceleratorKeys() {
        XWTMaps.checkAndInit();
        return accelerators.keySet();
    }

    public static int getAccelerator(String string) {
        Integer n;
        char c;
        if (string == null || string.equals("")) {
            return 0;
        }
        XWTMaps.checkAndInit();
        if (string.equals("BS")) {
            Integer n2 = 8;
            return n2 == null ? 0 : n2;
        }
        if (string.equals("ENTER")) {
            Integer n3 = 13;
            return n3 == null ? 0 : n3;
        }
        if (string.equals("DEL")) {
            Integer n4 = 127;
            return n4 == null ? 0 : n4;
        }
        if (string.equals("SPACE")) {
            Integer n5 = 32;
            return n5 == null ? 0 : n5;
        }
        if (string.length() == 1 && ((c = string.charAt(0)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            Integer n6 = c;
            return n6 == null ? 0 : n6;
        }
        String string2 = string.toUpperCase();
        if (!string2.startsWith("SWT.")) {
            string2 = "SWT." + string2;
        }
        return (n = accelerators.get(string2)) == null ? 0 : n;
    }

    public static int getValue(String string) {
        int n = XWTMaps.getStyle(string);
        if (n == 0) {
            n = XWTMaps.getColor(string);
        }
        if (n == 0) {
            n = XWTMaps.getEvent(string);
        }
        if (n == 0) {
            n = XWTMaps.getAccelerator(string);
        }
        return n;
    }

    public static String getCombAccelerator(String string) {
        if (string.equals("Alt0")) {
            return "SWT.ALT | SWT.KEYPAD_0";
        }
        if (string.equals("Alt1")) {
            return "SWT.ALT | SWT.KEYPAD_1";
        }
        if (string.equals("Alt2")) {
            return "SWT.ALT | SWT.KEYPAD_2";
        }
        if (string.equals("Alt3")) {
            return "SWT.ALT | SWT.KEYPAD_3";
        }
        if (string.equals("Alt4")) {
            return "SWT.ALT | SWT.KEYPAD_4";
        }
        if (string.equals("Alt5")) {
            return "SWT.ALT | SWT.KEYPAD_5";
        }
        if (string.equals("Alt6")) {
            return "SWT.ALT | SWT.KEYPAD_6";
        }
        if (string.equals("Alt7")) {
            return "SWT.ALT | SWT.KEYPAD_7";
        }
        if (string.equals("Alt8")) {
            return "SWT.ALT | SWT.KEYPAD_8";
        }
        if (string.equals("Alt9")) {
            return "SWT.ALT | SWT.KEYPAD_9";
        }
        if (string.equals("AltBksp")) {
            return "SWT.ALT | BS";
        }
        if (string.equals("AltDownArrow")) {
            return "SWT.ALT | SWT.ARROW_DOWN";
        }
        if (string.equals("AltF1")) {
            return "SWT.ALT | SWT.F1";
        }
        if (string.equals("AltF10")) {
            return "SWT.ALT | SWT.F10";
        }
        if (string.equals("AltF11")) {
            return "SWT.ALT | SWT.F11";
        }
        if (string.equals("AltF12")) {
            return "SWT.ALT | SWT.F12";
        }
        if (string.equals("AltF2")) {
            return "SWT.ALT | SWT.F2";
        }
        if (string.equals("AltF3")) {
            return "SWT.ALT | SWT.F3";
        }
        if (string.equals("AltF4")) {
            return "SWT.ALT | SWT.F4";
        }
        if (string.equals("AltF5")) {
            return "SWT.ALT | SWT.F5";
        }
        if (string.equals("AltF6")) {
            return "SWT.ALT | SWT.F6";
        }
        if (string.equals("AltF7")) {
            return "SWT.ALT | SWT.F7";
        }
        if (string.equals("AltF8")) {
            return "SWT.ALT | SWT.F8";
        }
        if (string.equals("AltF9")) {
            return "SWT.ALT | SWT.F9";
        }
        if (string.equals("AltLeftArrow")) {
            return "SWT.ALT | SWT.ARROW_LEFT";
        }
        if (string.equals("AltRightArrow")) {
            return "SWT.ALT | SWT.ARROW_RIGHT";
        }
        if (string.equals("AltUpArrow")) {
            return "SWT.ALT | SWT.ARROW_UP";
        }
        if (string.equals("AltEnter")) {
            return "SWT.ALT | Enter";
        }
        if (string.equals("AltSpace")) {
            return "SWT.ALT | Space";
        }
        if (string.equals("Ctrl0")) {
            return "SWT.CTRL | SWT.KEYPAD_0";
        }
        if (string.equals("Ctrl1")) {
            return "SWT.CTRL | SWT.KEYPAD_1";
        }
        if (string.equals("Ctrl2")) {
            return "SWT.CTRL | SWT.KEYPAD_2";
        }
        if (string.equals("Ctrl3")) {
            return "SWT.CTRL | SWT.KEYPAD_3";
        }
        if (string.equals("Ctrl4")) {
            return "SWT.CTRL | SWT.KEYPAD_4";
        }
        if (string.equals("Ctrl5")) {
            return "SWT.CTRL | SWT.KEYPAD_5";
        }
        if (string.equals("Ctrl6")) {
            return "SWT.CTRL | SWT.KEYPAD_6";
        }
        if (string.equals("Ctrl7")) {
            return "SWT.CTRL | SWT.KEYPAD_7";
        }
        if (string.equals("Ctrl8")) {
            return "SWT.CTRL | SWT.KEYPAD_8";
        }
        if (string.equals("Ctrl9")) {
            return "SWT.CTRL | SWT.KEYPAD_9";
        }
        if (string.equals("CtrlA")) {
            return "SWT.CTRL | A";
        }
        if (string.equals("CtrlB")) {
            return "SWT.CTRL | B";
        }
        if (string.equals("CtrlC")) {
            return "SWT.CTRL | C";
        }
        if (string.equals("CtrlD")) {
            return "SWT.CTRL | D";
        }
        if (string.equals("CtrlDel")) {
            return "SWT.CTRL | DEL";
        }
        if (string.equals("CtrlEnter")) {
            return "SWT.CTRL | Enter";
        }
        if (string.equals("CtrlSpace")) {
            return "SWT.CTRL | Space";
        }
        if (string.equals("CtrlE")) {
            return "SWT.CTRL | E";
        }
        if (string.equals("CtrlF")) {
            return "SWT.CTRL | F";
        }
        if (string.equals("CtrlF1")) {
            return "SWT.CTRL | SWT.F1";
        }
        if (string.equals("CtrlF10")) {
            return "SWT.CTRL | SWT.F10";
        }
        if (string.equals("CtrlF11")) {
            return "SWT.CTRL | SWT.F11";
        }
        if (string.equals("CtrlF12")) {
            return "SWT.CTRL | SWT.F12";
        }
        if (string.equals("CtrlF2")) {
            return "SWT.CTRL | SWT.F2";
        }
        if (string.equals("CtrlF3")) {
            return "SWT.CTRL | SWT.F3";
        }
        if (string.equals("CtrlF4")) {
            return "SWT.CTRL | SWT.F4";
        }
        if (string.equals("CtrlF5")) {
            return "SWT.CTRL | SWT.F5";
        }
        if (string.equals("CtrlF6")) {
            return "SWT.CTRL | SWT.F6";
        }
        if (string.equals("CtrlF7")) {
            return "SWT.CTRL | SWT.F7";
        }
        if (string.equals("CtrlF8")) {
            return "SWT.CTRL | SWT.F8";
        }
        if (string.equals("CtrlF9")) {
            return "SWT.CTRL | SWT.F9";
        }
        if (string.equals("CtrlG")) {
            return "SWT.CTRL | G";
        }
        if (string.equals("CtrlH")) {
            return "SWT.CTRL | H";
        }
        if (string.equals("CtrlI")) {
            return "SWT.CTRL | I";
        }
        if (string.equals("CtrlIns")) {
            return "SWT.CTRL | SWT.INSERT";
        }
        if (string.equals("CtrlJ")) {
            return "SWT.CTRL | J";
        }
        if (string.equals("CtrlK")) {
            return "SWT.CTRL | K";
        }
        if (string.equals("CtrlL")) {
            return "SWT.CTRL | L";
        }
        if (string.equals("CtrlM")) {
            return "SWT.CTRL | M";
        }
        if (string.equals("CtrlN")) {
            return "SWT.CTRL | N";
        }
        if (string.equals("CtrlO")) {
            return "SWT.CTRL | O";
        }
        if (string.equals("CtrlP")) {
            return "SWT.CTRL | P";
        }
        if (string.equals("CtrlQ")) {
            return "SWT.CTRL | Q";
        }
        if (string.equals("CtrlR")) {
            return "SWT.CTRL | R";
        }
        if (string.equals("CtrlS")) {
            return "SWT.CTRL | S";
        }
        if (string.equals("CtrlShift0")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_0";
        }
        if (string.equals("CtrlShift1")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_1";
        }
        if (string.equals("CtrlShift2")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_2";
        }
        if (string.equals("CtrlShift3")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_3";
        }
        if (string.equals("CtrlShift4")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_4";
        }
        if (string.equals("CtrlShift5")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_5";
        }
        if (string.equals("CtrlShift6")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_6";
        }
        if (string.equals("CtrlShift7")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_7";
        }
        if (string.equals("CtrlShift8")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_8";
        }
        if (string.equals("CtrlShift9")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.KEYPAD_9";
        }
        if (string.equals("CtrlShiftA")) {
            return "SWT.CTRL | SWT.SHIFT | A";
        }
        if (string.equals("CtrlShiftB")) {
            return "SWT.CTRL | SWT.SHIFT | B";
        }
        if (string.equals("CtrlShiftC")) {
            return "SWT.CTRL | SWT.SHIFT | C";
        }
        if (string.equals("CtrlShiftD")) {
            return "SWT.CTRL | SWT.SHIFT | D";
        }
        if (string.equals("CtrlShiftE")) {
            return "SWT.CTRL | SWT.SHIFT | E";
        }
        if (string.equals("CtrlShiftF")) {
            return "SWT.CTRL | SWT.SHIFT | F";
        }
        if (string.equals("CtrlShiftF1")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F1";
        }
        if (string.equals("CtrlShiftF10")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F10";
        }
        if (string.equals("CtrlShiftF11")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F11";
        }
        if (string.equals("CtrlShiftF12")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F12";
        }
        if (string.equals("CtrlShiftF2")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F2";
        }
        if (string.equals("CtrlShiftF3")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F3";
        }
        if (string.equals("CtrlShiftF4")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F4";
        }
        if (string.equals("CtrlShiftF5")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F5";
        }
        if (string.equals("CtrlShiftF6")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F6";
        }
        if (string.equals("CtrlShiftF7")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F7";
        }
        if (string.equals("CtrlShiftF8")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F8";
        }
        if (string.equals("CtrlShiftF9")) {
            return "SWT.CTRL | SWT.SHIFT | SWT.F9";
        }
        if (string.equals("CtrlShiftH")) {
            return "SWT.CTRL | SWT.SHIFT | H";
        }
        if (string.equals("CtrlShiftI")) {
            return "SWT.CTRL | SWT.SHIFT | I";
        }
        if (string.equals("CtrlShiftJ")) {
            return "SWT.CTRL | SWT.SHIFT | J";
        }
        if (string.equals("CtrlShiftK")) {
            return "SWT.CTRL | SWT.SHIFT | K";
        }
        if (string.equals("CtrlShiftL")) {
            return "SWT.CTRL | SWT.SHIFT | L";
        }
        if (string.equals("CtrlShiftM")) {
            return "SWT.CTRL | SWT.SHIFT | M";
        }
        if (string.equals("CtrlShiftN")) {
            return "SWT.CTRL | SWT.SHIFT | N";
        }
        if (string.equals("CtrlShiftO")) {
            return "SWT.CTRL | SWT.SHIFT | O";
        }
        if (string.equals("CtrlShiftP")) {
            return "SWT.CTRL | SWT.SHIFT | P";
        }
        if (string.equals("CtrlShiftQ")) {
            return "SWT.CTRL | SWT.SHIFT | Q";
        }
        if (string.equals("CtrlShiftR")) {
            return "SWT.CTRL | SWT.SHIFT | R";
        }
        if (string.equals("CtrlShiftS")) {
            return "SWT.CTRL | SWT.SHIFT | S";
        }
        if (string.equals("CtrlShiftT")) {
            return "SWT.CTRL | SWT.SHIFT | T";
        }
        if (string.equals("CtrlShiftU")) {
            return "SWT.CTRL | SWT.SHIFT | U";
        }
        if (string.equals("CtrlShiftV")) {
            return "SWT.CTRL | SWT.SHIFT | V";
        }
        if (string.equals("CtrlShiftW")) {
            return "SWT.CTRL | SWT.SHIFT | W";
        }
        if (string.equals("CtrlShiftX")) {
            return "SWT.CTRL | SWT.SHIFT | X";
        }
        if (string.equals("CtrlShiftY")) {
            return "SWT.CTRL | SWT.SHIFT | Y";
        }
        if (string.equals("CtrlShiftZ")) {
            return "SWT.CTRL | SWT.SHIFT | Z";
        }
        if (string.equals("CtrlShiftEnter")) {
            return "SWT.CTRL | SWT.SHIFT | Enter";
        }
        if (string.equals("CtrlShiftSpace")) {
            return "SWT.CTRL | SWT.SHIFT | Space";
        }
        if (string.equals("CtrlT")) {
            return "SWT.CTRL | T";
        }
        if (string.equals("CtrlU")) {
            return "SWT.CTRL | U";
        }
        if (string.equals("CtrlV")) {
            return "SWT.CTRL | V";
        }
        if (string.equals("CtrlW")) {
            return "SWT.CTRL | W";
        }
        if (string.equals("CtrlX")) {
            return "SWT.CTRL | X";
        }
        if (string.equals("CtrlY")) {
            return "SWT.CTRL | Y";
        }
        if (string.equals("CtrlZ")) {
            return "SWT.CTRL | Z";
        }
        if (string.equals("ShiftDel")) {
            return "SWT.SHIFT | DEL";
        }
        if (string.equals("ShiftF1")) {
            return "SWT.SHIFT | SWT.F1";
        }
        if (string.equals("ShiftF10")) {
            return "SWT.SHIFT | SWT.F10";
        }
        if (string.equals("ShiftF11")) {
            return "SWT.SHIFT | SWT.F11";
        }
        if (string.equals("ShiftF12")) {
            return "SWT.SHIFT | SWT.F12";
        }
        if (string.equals("ShiftF3")) {
            return "SWT.SHIFT | SWT.F2";
        }
        if (string.equals("ShiftF3")) {
            return "SWT.SHIFT | SWT.F3";
        }
        if (string.equals("ShiftF4")) {
            return "SWT.SHIFT | SWT.F4";
        }
        if (string.equals("ShiftF5")) {
            return "SWT.SHIFT | SWT.F5";
        }
        if (string.equals("ShiftF6")) {
            return "SWT.SHIFT | SWT.F6";
        }
        if (string.equals("ShiftF7")) {
            return "SWT.SHIFT | SWT.F7";
        }
        if (string.equals("ShiftF8")) {
            return "SWT.SHIFT | SWT.F8";
        }
        if (string.equals("ShiftF9")) {
            return "SWT.SHIFT | SWT.F9";
        }
        if (string.equals("ShiftIns")) {
            return "SWT.SHIFT | SWT.INSERT";
        }
        if (string.equals("ShiftEnter")) {
            return "SWT.SHIFT | Enter";
        }
        if (string.equals("ShiftSpace")) {
            return "SWT.SHIFT | Space";
        }
        if (string.equals("Enter")) {
            return "Enter";
        }
        if (string.equals("Space")) {
            return "Space";
        }
        return string;
    }
}

