/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.converters;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.XWTMaps;

public class StringToInteger
implements IConverter {
    private static final String GRIDDATA_PREFIX = "GRIDDATA.";
    private static final String STYLES_SEP = "|";
    public static StringToInteger instance = new StringToInteger();

    public Object convert(Object object) {
        String string = (String)object;
        if (string.indexOf(STYLES_SEP) != -1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, STYLES_SEP);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            int n = 0;
            for (String string2 : arrayList) {
                n |= this.convertInt(string2);
            }
            return n;
        }
        return this.convertInt(string);
    }

    private int convertInt(String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            string = string.toUpperCase().trim();
            if (string.startsWith(GRIDDATA_PREFIX)) {
                return this.convertGridDataInt(string);
            }
            return this.defaultConvertInt(string);
        }
    }

    private int convertGridDataInt(String string) {
        if ("GridData.BEGINNING".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("GridData.CENTER".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("GridData.END".equalsIgnoreCase(string)) {
            return 3;
        }
        if ("GridData.FILL".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("GridData.FILL_BOTH".equalsIgnoreCase(string)) {
            return 1808;
        }
        if ("GridData.FILL_HORIZONTAL".equalsIgnoreCase(string)) {
            return 768;
        }
        if ("GridData.GRAB_HORIZONTAL".equalsIgnoreCase(string)) {
            return 512;
        }
        if ("GridData.GRAB_VERTICAL".equalsIgnoreCase(string)) {
            return 1024;
        }
        if ("GridData.HORIZONTAL_ALIGN_BEGINNING".equalsIgnoreCase(string)) {
            return 32;
        }
        if ("GridData.HORIZONTAL_ALIGN_CENTER".equalsIgnoreCase(string)) {
            return 64;
        }
        if ("GridData.HORIZONTAL_ALIGN_END".equalsIgnoreCase(string)) {
            return 128;
        }
        if ("GridData.HORIZONTAL_ALIGN_FILL".equalsIgnoreCase(string)) {
            return 256;
        }
        if ("GridData.VERTICAL_ALIGN_BEGINNING".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("GridData.VERTICAL_ALIGN_CENTER".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("GridData.VERTICAL_ALIGN_END".equalsIgnoreCase(string)) {
            return 8;
        }
        if ("GridData.VERTICAL_ALIGN_FILL".equalsIgnoreCase(string)) {
            return 16;
        }
        return 0;
    }

    private int defaultConvertInt(String string) {
        return XWTMaps.getValue(string);
    }

    public Object getFromType() {
        return String.class;
    }

    public Object getToType() {
        return Integer.class;
    }
}

