/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.dataproviders.impl;

import java.io.ByteArrayInputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.e4.xwt.dataproviders.IXMLDataProvider;
import org.eclipse.e4.xwt.dataproviders.impl.AbstractDataProvider;
import org.w3c.dom.Document;

public class XMLDataProvider
extends AbstractDataProvider
implements IXMLDataProvider {
    private URL source;
    private String xPath;
    private String xDataContent;

    public Document getDocument() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        if (this.source != null) {
            try {
                return documentBuilder.parse(this.source.openStream());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.xDataContent != null) {
            try {
                return documentBuilder.parse(new ByteArrayInputStream(this.xDataContent.getBytes()));
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public URL getSource() {
        return this.source;
    }

    public String getXPath() {
        return this.xPath;
    }

    public void setSource(URL uRL) {
        this.source = uRL;
    }

    public void setXPath(String string) {
        this.xPath = string;
    }

    private Object getRoot() {
        Document document = this.getDocument();
        if (document == null) {
            return null;
        }
        if (this.xPath != null) {
            try {
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                XPathExpression xPathExpression = xPath.compile(this.xPath);
                return xPathExpression.evaluate(document, XPathConstants.NODE);
            }
            catch (XPathExpressionException xPathExpressionException) {
                xPathExpressionException.printStackTrace();
            }
        }
        return document;
    }

    public Object getData(String string) {
        Object object = this.getRoot();
        if (object == null || string == null) {
            return null;
        }
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            String string2 = xPathExpression.evaluate(object);
            return string2;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public String getXDataContent() {
        return this.xDataContent;
    }

    public void setXDataContent(String string) {
        this.xDataContent = string;
    }
}

