/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.ILogger;
import org.eclipse.e4.xwt.IMetaclassFactory;
import org.eclipse.e4.xwt.Tracking;
import org.eclipse.e4.xwt.impl.IElementLoaderFactory;
import org.eclipse.e4.xwt.impl.IRenderingContext;
import org.eclipse.e4.xwt.impl.IVisualElementLoader;
import org.eclipse.e4.xwt.javabean.metadata.MetaclassManager;
import org.eclipse.e4.xwt.javabean.metadata.MetaclassService;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.xml.DocumentObject;
import org.eclipse.e4.xwt.xml.DocumentRoot;
import org.eclipse.e4.xwt.xml.Element;
import org.eclipse.e4.xwt.xml.ElementManager;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Core {
    public static final String DEFAULT_STYLES_KEY = "XWT.DefaultStyles";
    public static boolean TRACE_BENCH = false;
    private HashMap<Class<?>, Object> registrations;
    private HashMap<DocumentObject, IVisualElementLoader> elementsLoaders = new HashMap();
    MetaclassService metaclassService = new MetaclassService();
    IElementLoaderFactory loaderFactory;
    public static ILogger nullLog = new ILogger(){
        private Map<Tracking, String> messageMap = new HashMap<Tracking, String>();

        public void error(Throwable throwable) {
        }

        public void error(Throwable throwable, String string) {
        }

        public void message(String string) {
        }

        public void warning(String string) {
        }

        public void printInfo(String string, Tracking tracking, Set set) {
            String string2 = "";
            if (set != null && set.size() > 0 && set.contains((Object)tracking)) {
                string2 = this.messageMap.get((Object)tracking);
            }
            System.out.println(string2);
        }

        public void addMessage(String string, Tracking tracking) {
            if (this.messageMap.containsKey((Object)tracking)) {
                this.messageMap.remove((Object)tracking);
            }
            this.messageMap.put(tracking, string);
        }

        public void removeMessage(Tracking tracking) {
            if (this.messageMap.containsKey((Object)tracking)) {
                this.messageMap.remove((Object)tracking);
            }
        }
    };

    public Core(IElementLoaderFactory iElementLoaderFactory) {
        this.loaderFactory = iElementLoaderFactory;
        this.registrations = new HashMap();
    }

    public IMetaclass getMetaclass(ILoadingContext iLoadingContext, String string, String string2) {
        return this.getMetaclassService().getMetaclass(iLoadingContext, string, string2);
    }

    public IMetaclass getMetaclass(Object object) {
        if (object instanceof Class) {
            return this.getMetaclassService().getMetaclass((Class)object);
        }
        return this.getMetaclassService().getMetaclass(object.getClass());
    }

    public Collection<IMetaclass> getAllMetaclasses(String string) {
        return this.getMetaclassService().getAllMetaclasses(string);
    }

    public void registerMetaclass(IMetaclass iMetaclass, String string) {
        this.getMetaclassService().register(iMetaclass, string);
    }

    public void registerMetaclassFactory(IMetaclassFactory iMetaclassFactory) {
        this.getMetaclassService().registerFactory(iMetaclassFactory);
    }

    public IMetaclass registerMetaclass(Class<?> clazz, String string) {
        return this.getMetaclassService().register(clazz, string);
    }

    public void registerMetaclassManager(String string, MetaclassManager metaclassManager) {
        this.getMetaclassService().register(string, metaclassManager);
    }

    public Object getService(Class<?> clazz) {
        return this.registrations.get(clazz);
    }

    public void registerService(Class<?> clazz, Object object) {
        this.registrations.put(clazz, object);
    }

    protected Object createCLRElement(IRenderingContext iRenderingContext, Element element, Map<String, Object> map) {
        IVisualElementLoader iVisualElementLoader = this.findElementLoader(element);
        if (iVisualElementLoader != null) {
            return iVisualElementLoader.createCLRElement(element, map);
        }
        iVisualElementLoader = this.createElementLoader(iRenderingContext, element);
        Object object = iVisualElementLoader.createCLRElement(element, map);
        this.removeElementLoader(element);
        return object;
    }

    protected IVisualElementLoader findElementLoader(DocumentObject documentObject) {
        IVisualElementLoader iVisualElementLoader = this.elementsLoaders.get(documentObject);
        if (iVisualElementLoader != null) {
            return iVisualElementLoader;
        }
        if (documentObject.getParent() != null) {
            return this.findElementLoader(documentObject.getParent());
        }
        return null;
    }

    protected IVisualElementLoader createElementLoader(IRenderingContext iRenderingContext, DocumentObject documentObject) {
        IVisualElementLoader iVisualElementLoader = this.loaderFactory.createElementLoader(iRenderingContext);
        this.elementsLoaders.put(documentObject, iVisualElementLoader);
        return iVisualElementLoader;
    }

    protected void removeElementLoader(DocumentObject documentObject) {
        this.elementsLoaders.remove(documentObject);
    }

    public Control load(ILoadingContext iLoadingContext, URL uRL, Map<String, Object> map) throws Exception {
        return this.load(iLoadingContext, null, uRL, map);
    }

    public Control load(ILoadingContext iLoadingContext, InputStream inputStream, URL uRL, Map<String, Object> map) throws Exception {
        long l = System.currentTimeMillis();
        ElementManager elementManager = new ElementManager();
        if (uRL != null) {
            Element element = inputStream == null ? elementManager.load(uRL) : elementManager.load(inputStream, uRL);
            ExtensionContext extensionContext = new ExtensionContext(iLoadingContext, elementManager, elementManager.getRootElement().getNamespace());
            Object object = this.createCLRElement(extensionContext, element, map);
            if (TRACE_BENCH) {
                System.out.println("Loaded: " + (System.currentTimeMillis() - l) + "  " + uRL.toString());
            }
            if (object instanceof Control) {
                return (Control)object;
            }
            Class<?> clazz = Class.forName("org.eclipse.jface.window.Window");
            if (clazz != null && clazz.isInstance(object)) {
                Method method = clazz.getDeclaredMethod("create", new Class[0]);
                method.invoke(object, new Object[0]);
                Method method2 = clazz.getDeclaredMethod("getShell", new Class[0]);
                return (Control)method2.invoke(object, new Object[0]);
            }
        }
        return null;
    }

    public MetaclassService getMetaclassService() {
        return this.metaclassService;
    }

    private static class ExtensionContext
    implements IRenderingContext {
        private Map<String, Object> properties = new HashMap<String, Object>();
        private URL resourcePath;
        private DocumentRoot documentRoot;
        private String namespace;
        private String encoding;
        protected ILoadingContext loadingContext;

        public ExtensionContext(ILoadingContext iLoadingContext, ElementManager elementManager, String string) {
            this.documentRoot = elementManager.getDocumentRoot();
            this.resourcePath = this.documentRoot.getPath();
            this.namespace = string;
            this.loadingContext = iLoadingContext;
            this.encoding = elementManager.getEncoding();
        }

        public String getNamespace() {
            return this.namespace;
        }

        public InputStream openStream(String string) throws IOException {
            return this.documentRoot.openStream(string);
        }

        public URL getResourcePath() {
            return this.resourcePath;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public Object getProperty(String string) {
            return this.properties.get(string);
        }

        public void setProperty(String string, Object object) {
            this.properties.put(string, object);
        }

        public ILoadingContext getLoadingContext() {
            return this.loadingContext;
        }

        public void setLoadingContext(ILoadingContext iLoadingContext) {
            this.loadingContext = iLoadingContext;
        }
    }
}

