/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.javabean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.xwt.Tracking;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.javabean.metadata.BindingMetaclass;
import org.eclipse.e4.xwt.jface.JFacesHelper;
import org.eclipse.e4.xwt.utils.LoggerManager;
import org.eclipse.e4.xwt.xml.Attribute;
import org.eclipse.e4.xwt.xml.DocumentObject;
import org.eclipse.e4.xwt.xml.Element;
import org.eclipse.swt.widgets.Widget;

public class DataBindingTrack {
    private String bindingError = "";
    private Set<String> errorElements = null;
    private List<Element> widgetList = new ArrayList<Element>();
    private Map<Element, String> bindingMap;

    public DataBindingTrack() {
        this.errorElements = new HashSet<String>();
        this.bindingMap = new HashMap<Element, String>();
    }

    public void addWidgetElement(Element element) {
        this.widgetList.add(element);
    }

    private void addErrorWidgetId(String string) {
        this.errorElements.add(string);
    }

    private void addBindingMessageToMap(Element element, String string) {
        this.bindingMap.put(element, string);
    }

    private int validateParentElementError(Element element) {
        int n = 0;
        if (!this.bindingError.equals("")) {
            DocumentObject documentObject = element.getParent();
            while (documentObject != null) {
                element = (Element)documentObject;
                if (this.errorElements.contains(element.getId())) {
                    n = 1;
                    break;
                }
                documentObject = element.getParent();
            }
        }
        return n;
    }

    private String getCurrentWidgetPosition(Element element) {
        if (element.getParent() != null) {
            return " " + this.getCurrentWidgetPosition((Element)element.getParent());
        }
        return "";
    }

    public String getDataBindMessage() {
        StringBuffer stringBuffer = new StringBuffer("");
        Iterator<Element> iterator = this.widgetList.iterator();
        Set<Element> set = this.bindingMap.keySet();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            int n = this.validateParentElementError(element);
            if (n != 0) continue;
            String string = this.getCurrentWidgetPosition(element);
            if (!stringBuffer.toString().equals("")) {
                string = String.valueOf(string) + "+ ";
            }
            string = String.valueOf(string) + element.getName();
            if (XWT.isTracking(Tracking.NAME)) {
                Attribute attribute = element.getAttribute("Name");
                if (attribute == null) {
                    attribute = element.getAttribute("http://www.eclipse.org/xwt", "Name");
                }
                if (attribute != null) {
                    string = String.valueOf(string) + " <" + attribute.getContent() + ">";
                }
            }
            stringBuffer.append(string);
            if (!XWT.isTracking(Tracking.DATABINDING)) continue;
            if (set.contains(element)) {
                stringBuffer.append(this.bindingMap.get(element));
                continue;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void setBindingErrorMessage(String string) {
        this.bindingError = string;
    }

    public void tracking(Object object, Element element, Object object2) {
        String string = "";
        if (object instanceof BindingMetaclass.Binding) {
            String string2 = "";
            BindingMetaclass.Binding binding = (BindingMetaclass.Binding)object;
            String string3 = null;
            Attribute attribute = element.getAttribute("Path");
            if (attribute == null) {
                attribute = element.getAttribute("path");
            }
            if (attribute != null) {
                string3 = attribute.getContent();
            }
            Object object3 = null;
            try {
                String[] stringArray;
                object3 = binding.getValue();
                if (string3 != null && string3.length() > 0 && (stringArray = string3.trim().split("\\.")).length > 1) {
                    String string4 = "";
                    int n = 0;
                    while (n < stringArray.length - 1) {
                        string4 = stringArray[n];
                        if (object3 != null) {
                            object3 = DataBindingTrack.getObserveData(object3, string4);
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                this.addErrorWidgetId(element.getParent().getParent().getId());
                this.setBindingErrorMessage("-> Error");
                string2 = "-> Error";
            }
            if (object3 != null) {
                string = " (DataContext=" + object3.getClass().getSimpleName() + ", Path=" + string3 + ")" + string2 + "\n";
                this.addBindingMessageToMap((Element)element.getParent().getParent(), string);
            }
        } else if (object instanceof Widget) {
            this.addWidgetElement(element);
            if (object2 != null) {
                string = " (DataContext=" + object2.getClass().getSimpleName() + ")\n";
                this.addBindingMessageToMap(element, string);
            }
        } else if (JFacesHelper.isViewer(object)) {
            if (object2 != null) {
                string = " (DataContext=" + object2.getClass().getSimpleName() + ")\n";
                this.addBindingMessageToMap(element, string);
            }
        } else if (element.attributeNames("http://www.eclipse.org/xwt").length > 0 && element.getParent() != null && element.getParent().getParent() != null) {
            string = " (DataContext=" + element.getName() + ")\n";
            this.addBindingMessageToMap((Element)element.getParent().getParent(), string);
        }
    }

    public static Object getObserveData(Object object, String string) {
        try {
            Class<?> clazz = object.getClass();
            String string2 = "get" + string.substring(0, 1).toUpperCase() + string.substring(1);
            Method method = clazz.getDeclaredMethod(string2, new Class[0]);
            if (method != null) {
                return method.invoke(object, new Object[0]);
            }
        }
        catch (SecurityException securityException) {
            LoggerManager.log(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LoggerManager.log(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LoggerManager.log(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LoggerManager.log(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LoggerManager.log(invocationTargetException);
        }
        return null;
    }
}

