/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.javabean.metadata;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.javabean.metadata.BeanEvent;
import org.eclipse.e4.xwt.javabean.metadata.LoadedEvent;
import org.eclipse.e4.xwt.javabean.metadata.TypedEvent;
import org.eclipse.e4.xwt.javabean.metadata.properties.BeanProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.DynamicProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.FieldProperty;
import org.eclipse.e4.xwt.jface.JFacesHelper;
import org.eclipse.e4.xwt.metadata.IBehavior;
import org.eclipse.e4.xwt.metadata.IEvent;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metaclass
implements IMetaclass {
    public static IProperty[] EMPTY_PROPERTIES = new IProperty[0];
    public static IEvent[] EMPTY_ROUTED_EVENTS = new IEvent[0];
    protected final Map<String, IProperty> propertyCache = new HashMap<String, IProperty>();
    protected Map<String, IEvent> routedEventCache = new HashMap<String, IEvent>();
    public static final String LOADED = "Loaded";
    private Class<?> type;
    private String name;
    private IMetaclass superClass;
    private boolean buildTypedEvents;

    public Metaclass(Class<?> clazz, IMetaclass iMetaclass) {
        this.type = clazz;
        this.name = clazz.getSimpleName();
        this.superClass = iMetaclass;
        try {
            IBehavior iBehavior;
            Object object;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            Object[] objectArray = propertyDescriptorArray;
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = objectArray[n2];
                if (((PropertyDescriptor)object).getPropertyType() != null) {
                    IProperty iProperty = iBehavior = iMetaclass != null ? iMetaclass.findProperty(((FeatureDescriptor)object).getName()) : null;
                    if (iBehavior != null && !iBehavior.isDefault()) {
                        this.addProperty((IProperty)iBehavior);
                    } else {
                        this.addProperty(new BeanProperty((PropertyDescriptor)object));
                    }
                }
                ++n2;
            }
            objectArray = clazz.getDeclaredFields();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                object = objectArray[n2];
                if (!this.propertyCache.containsKey(this.normalize(((Field)object).getName())) && !Modifier.isFinal(((Field)object).getModifiers())) {
                    this.addProperty(new FieldProperty((Field)object));
                }
                ++n2;
            }
            objectArray = beanInfo.getEventSetDescriptors();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                object = objectArray[n2];
                iBehavior = new BeanEvent(((FeatureDescriptor)object).getName(), (EventSetDescriptor)object);
                this.routedEventCache.put(this.normalize(String.valueOf(((FeatureDescriptor)object).getName()) + "Event"), (IEvent)iBehavior);
                ++n2;
            }
            if (this.isWidgetType(clazz)) {
                this.routedEventCache.put(this.normalize(LOADED), new LoadedEvent(LOADED));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isWidgetType(Class<?> clazz) {
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            if (clazz2.getName().equalsIgnoreCase(Widget.class.getName())) {
                return true;
            }
            return this.isWidgetType(clazz2);
        }
        return false;
    }

    @Override
    public IProperty addProperty(IProperty iProperty) {
        String string = this.normalize(iProperty.getName());
        return this.propertyCache.put(string, iProperty);
    }

    private void buildTypedEvents() {
        if (this.buildTypedEvents) {
            return;
        }
        if (this.isSubclassOf(XWT.getMetaclass(Widget.class))) {
            this.addTypedEvent("Activate", 26);
            this.addTypedEvent("Arm", 30);
            this.addTypedEvent("Close", 21);
            this.addTypedEvent("Collapse", 18);
            this.addTypedEvent("Deactivate", 27);
            this.addTypedEvent("DefaultSelection", 14);
            this.addTypedEvent("Deiconify", 20);
            this.addTypedEvent("Dispose", 12);
            this.addTypedEvent("DragDetect", 29);
            this.addTypedEvent("EraseItem", 40);
            this.addTypedEvent("Expand", 17);
            this.addTypedEvent("FocusIn", 15);
            this.addTypedEvent("FocusOut", 16);
            this.addTypedEvent("HardKeyDown", 33);
            this.addTypedEvent("HardKeyUp", 34);
            this.addTypedEvent("Help", 28);
            this.addTypedEvent("Hide", 23);
            this.addTypedEvent("Iconify", 19);
            this.addTypedEvent("KeyDown", 1);
            this.addTypedEvent("KeyUp", 2);
            this.addTypedEvent("MeasureItem", 41);
            this.addTypedEvent("MenuDetect", 35);
            this.addTypedEvent("Modify", 24);
            this.addTypedEvent("MouseDoubleClick", 8);
            this.addTypedEvent("MouseDown", 3);
            this.addTypedEvent("MouseEnter", 6);
            this.addTypedEvent("MouseExit", 7);
            this.addTypedEvent("MouseHover", 32);
            this.addTypedEvent("MouseMove", 5);
            this.addTypedEvent("MouseUp", 4);
            this.addTypedEvent("MouseWheel", 37);
            this.addTypedEvent("Move", 10);
            this.addTypedEvent("Paint", 9);
            this.addTypedEvent("PaintItem", 42);
            this.addTypedEvent("Resize", 11);
            this.addTypedEvent("Selection", 13);
            this.addTypedEvent("SetData", 36);
            this.addTypedEvent("Show", 22);
            this.addTypedEvent("Traverse", 31);
            this.addTypedEvent("Verify", 25);
            this.addTypedEvent("ImeComposition", 43);
        }
        this.buildTypedEvents = true;
    }

    private void addTypedEvent(String string, int n) {
        if (!this.routedEventCache.containsKey(this.normalize(String.valueOf(string) + "Event"))) {
            this.routedEventCache.put(this.normalize(String.valueOf(string) + "Event"), new TypedEvent(string, n));
        }
    }

    @Override
    public IProperty findDefaultProperty() {
        return null;
    }

    @Override
    public IEvent findEvent(String string) {
        this.buildTypedEvents();
        return this.routedEventCache.get(this.normalize(string));
    }

    @Override
    public IProperty findProperty(String string) {
        IProperty iProperty = this.propertyCache.get(this.normalize(string));
        if (iProperty == null && this.superClass != null) {
            iProperty = this.superClass.findProperty(string);
        }
        if (iProperty == null) {
            try {
                Method method = DynamicProperty.createGetter(this.type, string);
                Class<?> clazz = method.getReturnType();
                Method method2 = DynamicProperty.createSetter(this.type, clazz, string);
                return new DynamicProperty(clazz, method2, method, string);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return iProperty;
    }

    private String normalize(String string) {
        return string.toLowerCase();
    }

    @Override
    public IEvent[] getEvents() {
        this.buildTypedEvents();
        return this.routedEventCache.values().toArray(new IEvent[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IProperty[] getProperties() {
        return this.propertyCache.values().toArray(new IProperty[this.propertyCache.size()]);
    }

    @Override
    public IMetaclass getSuperClass() {
        return this.superClass;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.type.getModifiers());
    }

    @Override
    public boolean isAssignableFrom(IMetaclass iMetaclass) {
        return this.getType().isAssignableFrom(iMetaclass.getType());
    }

    @Override
    public boolean isInstance(Object object) {
        return this.type.isInstance(object);
    }

    @Override
    public boolean isSubclassOf(IMetaclass iMetaclass) {
        if (iMetaclass == null) {
            return false;
        }
        if (this == iMetaclass) {
            return true;
        }
        if (this.superClass == iMetaclass) {
            return true;
        }
        if (this.superClass != null) {
            return this.superClass.isSubclassOf(iMetaclass);
        }
        return false;
    }

    @Override
    public boolean isSuperclassOf(IMetaclass iMetaclass) {
        return iMetaclass.isSubclassOf(this);
    }

    @Override
    public Object newInstance(Object[] objectArray) {
        try {
            if (objectArray.length == 0 || !(objectArray[0] instanceof Widget) && !JFacesHelper.isViewer(objectArray[0])) {
                return this.getType().newInstance();
            }
        }
        catch (Exception exception) {}
        try {
            Class<?>[] classArray;
            Constructor<?> constructor;
            Object var2_2 = null;
            Object object = objectArray[0];
            Widget widget = null;
            if (object instanceof Widget) {
                widget = (Widget)object;
            } else if (JFacesHelper.isViewer(object)) {
                widget = JFacesHelper.getControl(object);
            } else {
                throw new IllegalStateException();
            }
            if (Control.class.isAssignableFrom(this.getType()) && !(widget instanceof Composite)) {
                widget = XWT.findCompositeParent(widget);
            }
            Object object2 = null;
            if (objectArray.length == 2 && objectArray[1] != null && (objectArray[1].getClass() == Integer.TYPE || objectArray[1].getClass() == Integer.class)) {
                object2 = objectArray[1];
            }
            Constructor<?> constructor2 = null;
            Constructor<?>[] constructorArray = this.getType().getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                constructor = constructorArray[n2];
                classArray = constructor.getParameterTypes();
                if (classArray.length > 2 || classArray.length == 0) {
                    if (classArray.length == 0) {
                        constructor2 = constructor;
                    }
                } else if (classArray[0].isAssignableFrom(object.getClass())) {
                    if (classArray.length == 1) {
                        var2_2 = constructor.newInstance(object);
                        break;
                    }
                    if (classArray[1].isAssignableFrom(Integer.TYPE)) {
                        if (object2 == null) {
                            var2_2 = constructor.newInstance(object, 0);
                            break;
                        }
                        var2_2 = constructor.newInstance(object, object2);
                        break;
                    }
                }
                ++n2;
            }
            if (var2_2 == null) {
                constructorArray = this.getType().getConstructors();
                n = constructorArray.length;
                n2 = 0;
                while (n2 < n) {
                    constructor = constructorArray[n2];
                    classArray = constructor.getParameterTypes();
                    if (classArray.length > 2 || classArray.length == 0) {
                        if (classArray.length == 0) {
                            constructor2 = constructor;
                        }
                    } else if (classArray[0].isAssignableFrom(widget.getClass())) {
                        if (classArray.length == 1) {
                            var2_2 = constructor.newInstance(widget);
                            break;
                        }
                        if (classArray[1].isAssignableFrom(Integer.TYPE)) {
                            if (object2 == null) {
                                var2_2 = constructor.newInstance(widget, 0);
                                break;
                            }
                            var2_2 = constructor.newInstance(widget, object2);
                            break;
                        }
                    }
                    ++n2;
                }
            }
            if (var2_2 == null) {
                if (constructor2 == null) {
                    throw new UnsupportedOperationException("Constructor no found.");
                }
                var2_2 = constructor2.newInstance(new Object[0]);
            }
            return var2_2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

