/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.javabean.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.IMetaclassFactory;
import org.eclipse.e4.xwt.javabean.metadata.Metaclass;
import org.eclipse.e4.xwt.javabean.metadata.MetaclassService;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.utils.ClassLoaderUtil;
import org.eclipse.e4.xwt.utils.LoggerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaclassManager {
    protected Map<String, IMetaclass> nameRegister = new HashMap<String, IMetaclass>();
    protected Collection<Class<?>> classRegister = new HashSet();
    protected MetaclassManager parent;
    protected MetaclassService service;

    public MetaclassManager(MetaclassService metaclassService, MetaclassManager metaclassManager) {
        this.parent = metaclassManager;
        this.service = metaclassService;
    }

    public Collection<IMetaclass> getAllMetaclasses() {
        return this.nameRegister.values();
    }

    public void register(IMetaclass iMetaclass) {
        Class<?> clazz = iMetaclass.getType();
        if (this.classRegister.contains(clazz)) {
            return;
        }
        String string = clazz.getSimpleName();
        this.nameRegister.put(string, iMetaclass);
        this.classRegister.add(clazz);
    }

    public IMetaclass register(Class<?> clazz) {
        IMetaclass iMetaclass = this.getMetaclass(clazz);
        if (iMetaclass != null) {
            return iMetaclass;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null && clazz2 != Object.class) {
            this.register(clazz2);
        }
        IMetaclass iMetaclass2 = this.getMetaclass(clazz2);
        IMetaclass iMetaclass3 = this.createMetaclass(clazz, iMetaclass2);
        this.register(iMetaclass3);
        return iMetaclass3;
    }

    protected IMetaclass createMetaclass(Class<?> clazz, IMetaclass iMetaclass) {
        IMetaclassFactory iMetaclassFactory;
        if (this.service != null && (iMetaclassFactory = this.service.findFactory(clazz)) != null) {
            return iMetaclassFactory.create(clazz, iMetaclass);
        }
        return new Metaclass(clazz, iMetaclass);
    }

    public static String normalizePropertyName(String string) {
        return String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1);
    }

    public IMetaclass getMetaclass(ILoadingContext iLoadingContext, String string, String string2) {
        String string3;
        Class<?> clazz;
        String string4;
        int n;
        IMetaclass iMetaclass = this.nameRegister.get(string);
        if (iMetaclass != null) {
            return iMetaclass;
        }
        if (string2 == null || !string2.startsWith("clr-namespace:")) {
            LoggerManager.log(new IllegalArgumentException("Wrong namespace: " + string2 + " for " + string));
        }
        if ((n = (string4 = string2.substring("clr-namespace:".length())).indexOf(61)) != -1) {
            string4 = string4.substring(0, n);
        }
        if ((clazz = ClassLoaderUtil.loadClass(iLoadingContext, string3 = string4.length() == 0 ? string : String.valueOf(string4) + "." + string)) == null) {
            LoggerManager.log(new IllegalStateException("Cannot load " + string3));
        }
        iMetaclass = this.register(clazz);
        this.nameRegister.remove(clazz.getSimpleName());
        return iMetaclass;
    }

    public IMetaclass getMetaclass(Object object) {
        if (object instanceof Class) {
            return this.getMetaclass((Class)object);
        }
        if (object instanceof String) {
            return this.getMetaclass((String)object);
        }
        Class<?> clazz = object.getClass();
        return this.getMetaclass(clazz);
    }

    public IMetaclass getMetaclass(Class<?> clazz) {
        IMetaclass iMetaclass;
        if (this.classRegister.contains(clazz) && (iMetaclass = this.nameRegister.get(clazz.getSimpleName())) != null) {
            return iMetaclass;
        }
        if (this.parent != null && (iMetaclass = this.parent.getMetaclass(clazz)) != null) {
            return iMetaclass;
        }
        return null;
    }
}

