/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.javabean.metadata.properties;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.e4.xwt.javabean.metadata.properties.AbstractProperty;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableEditorDynamicProperty
extends AbstractProperty {
    public TableEditorDynamicProperty() {
        super("dynamic", Boolean.class);
    }

    public Object getValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        return null;
    }

    public void setValue(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        Boolean bl = (Boolean)object2;
        TableEditor tableEditor = (TableEditor)object;
        final Control control = tableEditor.getEditor();
        Table table = null;
        Composite composite = control.getParent();
        if (composite instanceof Table) {
            table = (Table)composite;
        } else if (tableEditor.getItem() != null) {
            table = tableEditor.getItem().getParent();
        }
        if (table == null) {
            return;
        }
        final Table table2 = table;
        if (bl.booleanValue()) {
            control.setVisible(false);
            control.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    control.setVisible(false);
                }
            });
            control.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.character == '\r' && control.isFocusControl()) {
                        table2.notifyListeners(14, new Event());
                    }
                }
            });
            Object object3 = table2.getData("tableUtil");
            if (object3 == null) {
                TableUtil tableUtil = new TableUtil(table2);
                table2.setData("tableUtil", (Object)tableUtil);
            }
            table2.addSelectionListener((SelectionListener)new TableSelectionHandler(table2, tableEditor));
        }
    }

    private class TableSelectionHandler
    implements SelectionListener {
        private Table table;
        private TableEditor tableEditor;

        public TableSelectionHandler(Table table, TableEditor tableEditor) {
            this.table = table;
            this.tableEditor = tableEditor;
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            Control control = this.tableEditor.getEditor();
            if (control.isDisposed()) {
                return;
            }
            if (control.isFocusControl()) {
                control.setVisible(false);
            } else {
                control.setFocus();
            }
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Control control = this.tableEditor.getEditor();
            if (control.isDisposed()) {
                return;
            }
            TableUtil tableUtil = (TableUtil)((Object)this.table.getData("tableUtil"));
            TableItem tableItem = tableUtil.getItem();
            int n = tableUtil.getColumn();
            if (tableItem == this.tableEditor.getItem() && n == this.tableEditor.getColumn()) {
                control.setVisible(true);
            } else {
                control.setVisible(false);
            }
        }
    }

    private static class TableUtil
    extends MouseAdapter
    implements KeyListener {
        private Table table;
        private TableItem item;
        private TableColumn column;

        public TableUtil(Table table) {
            this.table = table;
            table.addMouseListener((MouseListener)this);
            table.addKeyListener((KeyListener)this);
        }

        public void mouseDown(MouseEvent mouseEvent) {
            Rectangle rectangle;
            if (this.table.isDisposed() || !this.table.isVisible()) {
                return;
            }
            Point point = new Point(mouseEvent.x, mouseEvent.y);
            int n = this.table.getLinesVisible() ? this.table.getGridLineWidth() : 0;
            TableItem tableItem = this.table.getItem(point);
            int n2 = tableItem != null ? this.table.indexOf(tableItem) : this.table.getTopIndex();
            int n3 = this.table.getItemCount();
            Rectangle rectangle2 = this.table.getClientArea();
            int n4 = n2;
            while (n4 < n3) {
                TableItem tableItem2 = this.table.getItem(n4);
                rectangle = tableItem2.getBounds(0);
                if (point.y >= rectangle.y && point.y < rectangle.y + rectangle.height + n) {
                    tableItem = tableItem2;
                    break;
                }
                if (rectangle.y > rectangle2.y + rectangle2.height) {
                    return;
                }
                ++n4;
            }
            if (tableItem == null) {
                return;
            }
            this.item = tableItem;
            TableColumn tableColumn = null;
            int n5 = this.table.getColumnCount();
            if (n5 == 0) {
                if ((this.table.getStyle() & 0x10000) == 0) {
                    rectangle = tableItem.getBounds(0);
                    rectangle.width += n;
                    rectangle.height += n;
                    if (!rectangle.contains(point)) {
                        return;
                    }
                }
            } else {
                int n6 = 0;
                while (n6 < n5) {
                    Rectangle rectangle3 = tableItem.getBounds(n6);
                    rectangle3.width += n;
                    rectangle3.height += n;
                    if (rectangle3.contains(point)) {
                        tableColumn = this.table.getColumn(n6);
                        break;
                    }
                    ++n6;
                }
                if (tableColumn == null) {
                    if ((this.table.getStyle() & 0x10000) == 0) {
                        return;
                    }
                    tableColumn = this.table.getColumn(0);
                }
            }
            this.column = tableColumn;
            this.table.notifyListeners(14, new Event());
        }

        public TableItem getItem() {
            return this.item;
        }

        public int getRow() {
            return this.item == null ? (this.table.getItemCount() > 0 ? 0 : -1) : this.table.indexOf(this.item);
        }

        public void setRow(int n) {
            this.item = n >= 0 && n < this.table.getItemCount() ? this.table.getItem(n) : null;
        }

        public int getColumn() {
            return this.column == null ? (this.table.getColumnCount() > 0 ? 0 : -1) : this.table.indexOf(this.column);
        }

        public void setColumn(int n) {
            this.column = n >= 0 && n < this.table.getColumnCount() ? this.table.getColumn(n) : null;
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = this.getRow();
            int n2 = this.column == null ? 0 : this.table.indexOf(this.column);
            switch (keyEvent.keyCode) {
                case 0x1000001: {
                    this.setRow(Math.max(0, n - 1));
                    break;
                }
                case 0x1000002: {
                    this.setRow(Math.min(n + 1, this.table.getItemCount() - 1));
                    break;
                }
                case 0x1000003: 
                case 0x1000004: {
                    int n3;
                    int n4 = this.table.getColumnCount();
                    if (n4 == 0) break;
                    int[] nArray = this.table.getColumnOrder();
                    int n5 = 0;
                    while (n5 < nArray.length) {
                        if (nArray[n5] == n2) break;
                        ++n5;
                    }
                    if (n5 == nArray.length) {
                        n5 = 0;
                    }
                    int n6 = n3 = (this.table.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                    if (keyEvent.keyCode == n3) {
                        this.setColumn(nArray[Math.max(0, n5 - 1)]);
                    } else {
                        this.setColumn(nArray[Math.min(n4 - 1, n5 + 1)]);
                    }
                    this.table.notifyListeners(13, new Event());
                    break;
                }
                case 0x1000007: {
                    this.setRow(0);
                    this.setColumn(n2);
                    break;
                }
                case 0x1000008: {
                    this.setRow(this.table.getItemCount() - 1);
                    this.setColumn(n2);
                    break;
                }
                case 0x1000005: {
                    int n7 = this.table.getTopIndex();
                    if (n7 == n) {
                        Rectangle rectangle = this.table.getClientArea();
                        TableItem tableItem = this.table.getItem(n7);
                        Rectangle rectangle2 = tableItem.getBounds(0);
                        rectangle.height -= rectangle2.y;
                        int n8 = this.table.getItemHeight();
                        int n9 = Math.max(1, rectangle.height / n8);
                        n7 = Math.max(0, n7 - n9 + 1);
                    }
                    this.setRow(n7);
                    break;
                }
                case 0x1000006: {
                    int n10 = this.table.getTopIndex();
                    Rectangle rectangle = this.table.getClientArea();
                    TableItem tableItem = this.table.getItem(n10);
                    Rectangle rectangle3 = tableItem.getBounds(0);
                    rectangle.height -= rectangle3.y;
                    int n11 = this.table.getItemHeight();
                    int n12 = Math.max(1, rectangle.height / n11);
                    int n13 = this.table.getItemCount() - 1;
                    n10 = Math.min(n13, n10 + n12 - 1);
                    if (n10 == n) {
                        n10 = Math.min(n13, n10 + n12 - 1);
                    }
                    this.setRow(n10);
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

