/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.jface;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.jface.TextCellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFacesHelper {
    private static Class<?>[] JFACES_SUPPORTED_ELEMENTS;
    private static Class<?> JFACES_VIEWER;

    static {
        ArrayList arrayList = new ArrayList();
        try {
            JFACES_VIEWER = Class.forName("org.eclipse.jface.viewers.Viewer");
            arrayList.add(Class.forName("org.eclipse.jface.viewers.ListViewer"));
            arrayList.add(Class.forName("org.eclipse.jface.viewers.TreeViewer"));
            arrayList.add(Class.forName("org.eclipse.jface.viewers.TableViewer"));
            arrayList.add(Class.forName("org.eclipse.jface.viewers.TableTreeViewer"));
            arrayList.add(Class.forName("org.eclipse.jface.viewers.CheckboxTableViewer"));
            arrayList.add(Class.forName("org.eclipse.jface.viewers.CheckboxTreeViewer"));
            arrayList.add(Class.forName("org.eclipse.jface.dialogs.TitleAreaDialog"));
            arrayList.add(Class.forName("org.eclipse.jface.viewers.CellEditor"));
            arrayList.add(Class.forName("org.eclipse.jface.viewers.ComboBoxViewerCellEditor"));
            arrayList.add(Class.forName("org.eclipse.jface.viewers.DialogCellEditor"));
            arrayList.add(Class.forName("org.eclipse.jface.viewers.ColorCellEditor"));
            arrayList.add(TextCellEditor.class);
            arrayList.add(CheckboxCellEditor.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("No JFaces support");
        }
        JFACES_SUPPORTED_ELEMENTS = arrayList.toArray(new Class[arrayList.size()]);
    }

    public static Class<?>[] getSupportedElements() {
        return JFACES_SUPPORTED_ELEMENTS;
    }

    public static boolean isViewer(Object object) {
        if (JFACES_VIEWER == null) {
            return false;
        }
        return JFACES_VIEWER.isAssignableFrom(object.getClass());
    }

    public static Control getControl(Object object) {
        if (!JFacesHelper.isViewer(object)) {
            throw new XWTException("Expecting a JFaces viewer:" + object);
        }
        try {
            Method method = JFACES_VIEWER.getMethod("getControl", new Class[0]);
            return (Control)method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

