/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.utils.NamespaceHelper;
import org.eclipse.e4.xwt.utils.ObjectUtil;
import org.eclipse.e4.xwt.xml.DocumentObject;
import org.eclipse.e4.xwt.xml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtil {
    static final String[] DefaultPackages = new String[0];

    public static Class<?> loadClass(ILoadingContext iLoadingContext, String string) {
        Class<?> clazz = ClassLoaderUtil.doLoadClass(iLoadingContext, string);
        if (clazz != null) {
            return clazz;
        }
        int n = string.indexOf(46);
        if (n == -1) {
            String[] stringArray = DefaultPackages;
            int n2 = DefaultPackages.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                clazz = ClassLoaderUtil.doLoadClass(iLoadingContext, String.valueOf(string2) + "." + string);
                if (clazz != null) {
                    return clazz;
                }
                ++n3;
            }
        }
        return null;
    }

    private static Class<?> doLoadClass(ILoadingContext iLoadingContext, String string) {
        try {
            return iLoadingContext.getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }

    public static Object loadMember(ILoadingContext iLoadingContext, String string, String string2, boolean bl) {
        Class<?> clazz = ClassLoaderUtil.loadClass(iLoadingContext, string);
        return ClassLoaderUtil.loadMember(iLoadingContext, clazz, string2, bl);
    }

    public static Object loadMember(ILoadingContext iLoadingContext, Class<?> clazz, String string, boolean bl) {
        try {
            Field field = clazz.getField(string);
            if (bl && !Modifier.isStatic(field.getModifiers())) {
                throw new IllegalStateException(String.valueOf(clazz.getName()) + "." + string + " is not static member.");
            }
            return field.get(null);
        }
        catch (Exception exception) {
            Exception exception2;
            if (exception instanceof NoSuchFieldException) {
                Method method = ObjectUtil.findGetter(clazz, string, null);
                if (bl && (method == null || !Modifier.isStatic(method.getModifiers()))) {
                    throw new IllegalStateException(String.valueOf(clazz.getName()) + "." + string + " is not static member.");
                }
                try {
                    return method.invoke(null, new Object[0]);
                }
                catch (Exception exception3) {
                    exception2 = exception3;
                }
            }
            if (bl) {
                exception2.printStackTrace();
                throw new IllegalStateException(exception2);
            }
            return null;
        }
    }

    public static Object loadStaticMember(ILoadingContext iLoadingContext, Element element) {
        String string;
        String string2 = element.getName();
        Object object = ClassLoaderUtil.doLoadMember(iLoadingContext, string2, string = element.getNamespace());
        if (object != null) {
            return object;
        }
        String string3 = element.getContent();
        if (string3 == null) {
            DocumentObject[] documentObjectArray;
            Element element2 = element.getAttribute("http://www.eclipse.org/xwt/presentation", "Member");
            if (element2 == null) {
                element2 = element;
            }
            if (element2 != null && (string3 = element2.getContent()) == null && (documentObjectArray = element2.getChildren()).length != 0) {
                DocumentObject documentObject = documentObjectArray[0];
                String string4 = documentObject.getNamespace();
                String string5 = documentObject.getName();
                return ClassLoaderUtil.doLoadMember(iLoadingContext, string5, string4);
            }
        } else if ("Static".equals(string2) && "http://www.eclipse.org/xwt".equals(string)) {
            string = "http://www.eclipse.org/xwt/presentation";
            return ClassLoaderUtil.doLoadMember(iLoadingContext, string3, string);
        }
        return null;
    }

    protected static Object doLoadMember(ILoadingContext iLoadingContext, String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new IllegalStateException("Separator '.' is missing in:" + string);
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        try {
            Class<?> clazz = NamespaceHelper.loadCLRClass(iLoadingContext, string3, string2);
            if (clazz != null) {
                return ClassLoaderUtil.loadMember(iLoadingContext, clazz, string4, true);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        return null;
    }
}

