/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectUtil {
    public static final Class<?>[] EMPTY = new Class[0];

    private ObjectUtil() {
    }

    public static final Class<?>[] findCompatibleClasses(Class<?> clazz) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.add(clazz);
        if (clazz == Boolean.class) {
            linkedHashSet.add(Boolean.TYPE);
        } else if (clazz == Byte.class) {
            linkedHashSet.add(Byte.TYPE);
        } else if (clazz == Short.class) {
            linkedHashSet.add(Short.TYPE);
        } else if (clazz == Integer.class) {
            linkedHashSet.add(Integer.TYPE);
        } else if (clazz == Long.class) {
            linkedHashSet.add(Long.TYPE);
        } else if (clazz == Float.class) {
            linkedHashSet.add(Float.TYPE);
        } else if (clazz == Double.class) {
            linkedHashSet.add(Double.TYPE);
        } else if (clazz == Character.class) {
            linkedHashSet.add(Character.TYPE);
        } else if (clazz == Boolean.TYPE) {
            linkedHashSet.add(Boolean.class);
        } else if (clazz == Byte.TYPE) {
            linkedHashSet.add(Byte.class);
        } else if (clazz == Short.TYPE) {
            linkedHashSet.add(Short.class);
        } else if (clazz == Integer.TYPE) {
            linkedHashSet.add(Integer.class);
        } else if (clazz == Long.TYPE) {
            linkedHashSet.add(Long.class);
        } else if (clazz == Float.TYPE) {
            linkedHashSet.add(Float.class);
        } else if (clazz == Double.TYPE) {
            linkedHashSet.add(Double.class);
        } else if (clazz == Character.TYPE) {
            linkedHashSet.add(Character.class);
        }
        ObjectUtil.findInterfaces(linkedHashSet, clazz);
        ObjectUtil.findSuperClasses(linkedHashSet, clazz);
        linkedHashSet.add(Object.class);
        return linkedHashSet.toArray(EMPTY);
    }

    public static final Constructor<?> findConstructor(Class<?> clazz, Class<?> ... classArray) {
        Class[][] classArrayArray = new Class[classArray.length][];
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class<?>[] classArray2 = ObjectUtil.findCompatibleClasses(classArray[n]);
            classArrayArray[n] = classArray2;
            ++n;
        }
        n = 1;
        n2 = 0;
        while (n2 < classArrayArray.length) {
            n *= classArrayArray[n2].length;
            ++n2;
        }
        ArrayList<Class<?>[]> arrayList = new ArrayList<Class<?>[]>(n);
        ObjectUtil.computeArguments(arrayList, classArrayArray, new Class[classArrayArray.length], 0);
        for (Class<?>[] classArray2 : arrayList) {
            try {
                return clazz.getConstructor(classArray2);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return null;
    }

    public static final Method findMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        if (classArray != null && classArray.length > 0) {
            Class[][] classArrayArray = new Class[classArray.length][];
            int n = 0;
            int n2 = classArray.length;
            while (n < n2) {
                Class<?>[] classArray2 = ObjectUtil.findCompatibleClasses(classArray[n]);
                classArrayArray[n] = classArray2;
                ++n;
            }
            n = 1;
            n2 = 0;
            while (n2 < classArrayArray.length) {
                n *= classArrayArray[n2].length;
                ++n2;
            }
            ArrayList<Class<?>[]> arrayList = new ArrayList<Class<?>[]>(n);
            ObjectUtil.computeArguments(arrayList, classArrayArray, new Class[classArrayArray.length], 0);
            for (Class<?>[] classArray2 : arrayList) {
                try {
                    return clazz.getDeclaredMethod(string, classArray2);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        } else {
            Method[] methodArray;
            Method[] methodArray2 = methodArray = clazz.getMethods();
            int n = methodArray.length;
            int n3 = 0;
            while (n3 < n) {
                Method method = methodArray2[n3];
                if (method.getName().equals(string)) {
                    return method;
                }
                ++n3;
            }
        }
        return null;
    }

    public static final Method findDeclaredMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Object object;
        if (classArray != null && classArray.length > 0) {
            object = new Class[classArray.length][];
            int n = 0;
            int n2 = classArray.length;
            while (n < n2) {
                Class<?>[] classArray2;
                object[n] = classArray2 = ObjectUtil.findCompatibleClasses(classArray[n]);
                ++n;
            }
            n = 1;
            n2 = 0;
            while (n2 < ((Method[])object).length) {
                n *= ((Method)object[n2]).length;
                ++n2;
            }
            ArrayList<Class<?>[]> arrayList = new ArrayList<Class<?>[]>(n);
            ObjectUtil.computeArguments(arrayList, object, new Class[((Method[])object).length], 0);
            for (Class<?>[] classArray2 : arrayList) {
                try {
                    return clazz.getDeclaredMethod(string, classArray2);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        } else {
            Method[] methodArray = object = clazz.getDeclaredMethods();
            int n = ((Method[])object).length;
            int n3 = 0;
            while (n3 < n) {
                Method method = methodArray[n3];
                if (method.getName().equals(string) && method.getParameterTypes().length == 0) {
                    return method;
                }
                ++n3;
            }
        }
        object = clazz.getSuperclass();
        if (object != null) {
            return ObjectUtil.findDeclaredMethod(object, string, classArray);
        }
        return null;
    }

    public static final Method findGetter(Class<?> clazz, String string, Class<?> clazz2) {
        Method method;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid getter method name, null value found");
        }
        String string2 = "get" + string.substring(0, 1).toUpperCase() + string.substring(1);
        try {
            method = clazz.getMethod(string2, EMPTY);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string2 = "is" + string.substring(0, 1).toUpperCase() + string.substring(1);
            try {
                method = clazz.getMethod(string2, EMPTY);
                if (method.getReturnType() != Boolean.class && method.getReturnType() != Boolean.TYPE) {
                    return null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return null;
            }
        }
        if (clazz2 == null) {
            return method;
        }
        if (method != null) {
            Class<?>[] classArray;
            Class<?> clazz3 = method.getReturnType();
            Class<?>[] classArray2 = classArray = ObjectUtil.findCompatibleClasses(clazz2);
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz4 = classArray2[n2];
                if (clazz4 == clazz3) {
                    return method;
                }
                ++n2;
            }
        }
        return null;
    }

    private static void findSuperClasses(Set<Class<?>> set, Class<?> clazz) {
        Class<?> clazz2;
        if (clazz != null && (clazz2 = clazz.getSuperclass()) != Object.class) {
            set.add(clazz2);
            ObjectUtil.findInterfaces(set, clazz2);
            ObjectUtil.findSuperClasses(set, clazz2);
        }
    }

    private static void findInterfaces(Set<Class<?>> set, Class<?> clazz) {
        if (clazz != null) {
            Class<?>[] classArray;
            Class<?>[] classArray2 = classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz2 = classArray2[n2];
                set.add(clazz2);
                ObjectUtil.findInterfaces(set, clazz2);
                ++n2;
            }
        }
    }

    private static void computeArguments(List<Class<?>[]> list, Class<?>[][] classArray, Class<?>[] classArray2, int n) {
        if (n >= classArray.length) {
            Class[] classArray3 = new Class[classArray.length];
            int n2 = 0;
            while (n2 < classArray.length) {
                classArray3[n2] = classArray2[n2];
                ++n2;
            }
            list.add(classArray3);
            return;
        }
        int n3 = 0;
        while (n3 < classArray[n].length) {
            classArray2[n] = classArray[n][n3];
            ObjectUtil.computeArguments(list, classArray, classArray2, n + 1);
            ++n3;
        }
    }
}

