/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.utils;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTMaps;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ResourceManager {
    public static ResourceManager resources = new ResourceManager();
    private Map<String, Color> key2Colors = new HashMap<String, Color>();
    private Map<String, Font> key2Fonts = new HashMap<String, Font>();
    private Map<URL, Image> key2Images = new HashMap<URL, Image>();

    private ResourceManager() {
    }

    public Color getColor(String string) {
        Color color = this.key2Colors.get(string);
        if (color != null) {
            return color;
        }
        color = ColorTool.getColor(string);
        this.key2Colors.put(string, color);
        return color;
    }

    public Font getFont(String string) {
        Font font = this.key2Fonts.get(string);
        if (font != null) {
            return font;
        }
        font = FontTool.getFont(string);
        this.key2Fonts.put(string, font);
        return font;
    }

    public Image getImage(String string) {
        Image image;
        if (string == null) {
            return null;
        }
        try {
            URL uRL = new URL(string);
            image = this.key2Images.get(uRL);
            if (image == null) {
                image = ImageTool.getImage(uRL);
                this.key2Images.put(uRL, image);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return image;
    }

    public void dispose() {
        Object object2;
        Collection<Color> collection = this.key2Colors.values();
        for (Color object22 : collection) {
            if (object22 == null) continue;
            object22.dispose();
        }
        this.key2Colors.clear();
        Collection<Font> collection2 = this.key2Fonts.values();
        for (Object object2 : collection2) {
            if (object2 == null) continue;
            object2.dispose();
        }
        this.key2Colors.clear();
        object2 = this.key2Images.values();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Image image = (Image)iterator.next();
            if (image == null) continue;
            image.dispose();
        }
    }

    static class ColorTool {
        ColorTool() {
        }

        static Color getColor(String string) {
            if (string.toLowerCase().startsWith("swt.")) {
                return ColorTool.getSWTColor(string);
            }
            if (string.startsWith("#")) {
                try {
                    int n = Integer.parseInt(string.substring(1), 16);
                    return ColorTool.getColor(n);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            if (string.indexOf(",") != -1) {
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                if (arrayList.size() == 3) {
                    try {
                        int n = Integer.parseInt(((String)arrayList.get(0)).trim());
                        int n2 = Integer.parseInt(((String)arrayList.get(1)).trim());
                        int n3 = Integer.parseInt(((String)arrayList.get(2)).trim());
                        return ColorTool.getColor(n, n2, n3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                }
            }
            return ColorTool.getSWTColor(string);
        }

        static Color getColor(int n, int n2, int n3) {
            if (n > 255 || n2 > 255 || n3 > 255 || n < 0 || n2 < 0 || n3 < 0) {
                return null;
            }
            return new Color((Device)Display.getDefault(), n, n2, n3);
        }

        static Color getColor(int n) {
            int n2 = 0xFF000000 | n;
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 >> 0 & 0xFF;
            return ColorTool.getColor(n3, n4, n5);
        }

        static Color getSWTColor(String string) {
            if (!string.toLowerCase().startsWith("swt.")) {
                if (!string.toLowerCase().startsWith("color_")) {
                    string = "COLOR_" + string;
                }
                string = "SWT." + string;
            }
            int n = XWTMaps.getColor(string);
            return ColorTool.getSWTColor(n);
        }

        static Color getSWTColor(int n) {
            return Display.getDefault().getSystemColor(n);
        }
    }

    static class FontTool {
        FontTool() {
        }

        static Font getFont(String string) {
            if (string.indexOf(",") != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = null;
                int n = 0;
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().trim();
                    if (string3.equalsIgnoreCase("normal") || string3.equalsIgnoreCase("blod") || string3.equalsIgnoreCase("italic") || string3.contains("|")) {
                        IConverter iConverter = XWT.findConvertor(String.class, Integer.class);
                        if (iConverter == null) continue;
                        n2 = (Integer)iConverter.convert((Object)string3);
                        continue;
                    }
                    if (FontTool.isInt(string3)) {
                        n = Integer.parseInt(string3);
                        continue;
                    }
                    string2 = string3;
                }
                return FontTool.getFont(string2, n, n2);
            }
            return FontTool.getFont(string, 12, 0);
        }

        static boolean isInt(String string) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }

        static Font getFont(String string, int n, int n2) {
            if (string == null) {
                return null;
            }
            return new Font((Device)Display.getDefault(), string, n, n2);
        }

        static Font getSWTFont() {
            return Display.getDefault().getSystemFont();
        }
    }

    static class ImageTool {
        ImageTool() {
        }

        static Image getImage(String string) {
            return ImageTool.getImage(ResourceManager.class.getResource(string));
        }

        static Image getImage(URL uRL) {
            if (uRL == null) {
                return null;
            }
            try {
                return new Image((Device)Display.getDefault(), uRL.openStream());
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

