/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.utils;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TableEditorHelper {
    public static void initEditor(final TableItem tableItem, Control control, final int n) {
        if (control instanceof Text) {
            final Text text = (Text)control;
            text.setText(tableItem.getText(n));
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    tableItem.setText(n, text.getText());
                }
            });
        } else if (control instanceof CCombo) {
            final CCombo cCombo = (CCombo)control;
            cCombo.setText(tableItem.getText(n));
            cCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    tableItem.setText(n, cCombo.getText());
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    tableItem.setText(n, cCombo.getItem(cCombo.getSelectionIndex()));
                }
            });
        } else if (control instanceof Combo) {
            final Combo combo = (Combo)control;
            combo.setText(tableItem.getText(n));
            combo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    tableItem.setText(n, combo.getText());
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    tableItem.setText(n, combo.getItem(combo.getSelectionIndex()));
                }
            });
        }
    }
}

