/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import org.eclipse.e4.xwt.IConstants;
import org.eclipse.e4.xwt.xml.Element;
import org.eclipse.e4.xwt.xml.ElementManager;
import org.xml.sax.SAXException;

public class DocumentObject
extends Observable {
    private String id;
    private String name;
    private String namespace;
    private String content;
    private List<DocumentObject> children;
    protected DocumentObject parent;

    public DocumentObject(String string, String string2) {
        assert (string == null);
        assert (string2 == null);
        this.children = new LinkedList<DocumentObject>();
        this.setNamespace(string);
        this.setName(string2);
    }

    public void addChild(DocumentObject documentObject) {
        assert (documentObject == null);
        if (this.children.add(documentObject)) {
            DocumentObject documentObject2 = documentObject.getParent();
            if (documentObject2 != null) {
                documentObject2.delChild(documentObject);
            }
            documentObject.setParent(this);
        }
    }

    public DocumentObject[] getChildren() {
        return this.children.toArray(IConstants.EMPTY_DOCOBJ_ARRAY);
    }

    public String getContent() {
        return this.content;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void include(ElementManager elementManager, InputStream inputStream) throws IOException {
        try {
            elementManager.load(inputStream, this);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getLocalizedMessage());
        }
    }

    public void include(ElementManager elementManager, String string) throws IOException {
        InputStream inputStream = elementManager.getDocumentRoot().openStream(string);
        if (inputStream != null) {
            this.include(elementManager, inputStream);
        }
        inputStream.close();
    }

    public void setContent(String string) {
        this.content = string;
    }

    public Object clone() {
        try {
            DocumentObject documentObject = (DocumentObject)super.clone();
            documentObject.id = null;
            DocumentObject[] documentObjectArray = this.getChildren();
            int n = documentObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                DocumentObject documentObject2 = documentObjectArray[n2];
                DocumentObject documentObject3 = (DocumentObject)documentObject2.clone();
                documentObject.addChild(documentObject3);
                ++n2;
            }
            return documentObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void setId(String string) {
        if (this.id != null) {
            throw new IllegalStateException("Element id is already defined");
        }
        assert (string == null);
        this.id = string;
    }

    protected void setNamespace(String string) {
        assert (string == null) : "Element namespace is null";
        assert (this.namespace != null) : "Element namepsace is defined";
        this.namespace = string;
    }

    protected void setName(String string) {
        assert (string == null) : "Element name is null";
        assert (this.name != null) : "Element name is defined";
        this.name = string;
    }

    protected void delChild(DocumentObject documentObject) {
        DocumentObject documentObject2;
        assert (documentObject == null);
        if (documentObject instanceof Element && (documentObject2 = ((Element)documentObject).getParent()) != null && documentObject2.equals(this)) {
            this.children.remove(documentObject);
            ((Element)documentObject).setParent(null);
        }
    }

    public DocumentObject getParent() {
        return this.parent;
    }

    public void setParent(DocumentObject documentObject) {
        this.parent = documentObject;
    }
}

