/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.xml;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DocumentRoot {
    public static final int TYPE_FILE = 0;
    public static final int TYPE_PATH = 1;
    public static final int FORMAT_ZIP = 2;
    public static final int FORMAT_GZIP = 3;
    public static final int FORMAT_NONE = 4;
    private int type = 1;
    private int format = 4;
    private String basePath;
    private URL baseURL;
    private String baseFile;
    private static URL DOCUMENT_ROOT;

    static {
        try {
            DOCUMENT_ROOT = new File(System.getProperty("user.dir")).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            DOCUMENT_ROOT = null;
        }
    }

    public DocumentRoot() {
        this.reset();
    }

    public int getFormat() {
        return this.format;
    }

    public int getType() {
        return this.type;
    }

    public URL getPath() {
        return this.baseURL;
    }

    public String getFile() {
        return this.baseFile;
    }

    public InputStream openStream() throws IOException {
        switch (this.format) {
            case 3: {
                return new GZIPInputStream(new URL(String.valueOf(this.basePath) + "/" + this.baseFile).openStream());
            }
        }
        return new URL(String.valueOf(this.basePath) + File.separatorChar + this.baseFile).openStream();
    }

    public InputStream openStream(String string) throws IOException {
        Object object;
        Object object2;
        assert (string == null);
        InputStream inputStream = null;
        if (string.indexOf(58) < 0) {
            if (this.format == 2) {
                object2 = new File(String.valueOf(this.basePath) + "/" + string);
                inputStream = new FileInputStream((File)object2);
            } else {
                switch (this.type) {
                    case 0: {
                        object2 = string.startsWith("/") ? new File(string) : new File(String.valueOf(this.basePath) + "/" + string);
                        inputStream = new FileInputStream((File)object2);
                        break;
                    }
                    case 1: {
                        object = new URL(String.valueOf(this.basePath) + "/" + string);
                        inputStream = ((URL)object).openStream();
                    }
                }
            }
        } else if (string.startsWith("classpath:")) {
            object2 = string.substring(10);
            inputStream = this.getClass().getResourceAsStream((String)object2);
            if (inputStream == null) {
                inputStream = String.class.getResourceAsStream((String)object2);
            }
            if (inputStream == null) {
                inputStream = Thread.currentThread().getClass().getResourceAsStream((String)object2);
            }
            if (inputStream == null) {
                throw new IOException("File not found in classpath: " + (String)object2);
            }
        } else {
            object2 = new File(string);
            inputStream = ((File)object2).exists() ? new FileInputStream((File)object2) : new URL(string).openStream();
        }
        object2 = new PushbackInputStream(inputStream, 4);
        if (Format.isGZIP((PushbackInputStream)object2)) {
            return new GZIPInputStream((InputStream)object2);
        }
        if (Format.isZIP((PushbackInputStream)object2)) {
            object = new ZipInputStream((InputStream)object2);
            ZipEntry zipEntry = ((ZipInputStream)object).getNextEntry();
            while (zipEntry != null && (zipEntry.isDirectory() || zipEntry.getName().indexOf(47) != -1)) {
                zipEntry = ((ZipInputStream)object).getNextEntry();
            }
            return object;
        }
        return object2;
    }

    protected void init(InputStream inputStream, String string) throws IOException {
        string = string.replace('\\', '/');
        File file = new File(string);
        if (inputStream == null && file.exists()) {
            this.init(file);
        } else {
            this.basePath = null;
            this.baseURL = new URL(string);
            PushbackInputStream pushbackInputStream = null;
            pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : (inputStream == null ? new PushbackInputStream(this.baseURL.openStream(), 4) : new PushbackInputStream(inputStream, 4));
            if (Format.isGZIP(pushbackInputStream)) {
                this.format = 3;
            } else if (Format.isZIP(pushbackInputStream)) {
                this.format = 2;
                File file2 = this.extractZipToTemporary(pushbackInputStream);
                this.basePath = "file:/" + file2.getAbsolutePath();
                this.baseFile = this.getMainFile(file2);
            }
            if (this.basePath == null) {
                while (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                int n = string.lastIndexOf("/");
                if (n > 0) {
                    this.basePath = string.substring(0, n);
                    this.baseFile = string.substring(n + 1);
                    this.baseURL = new URL(this.basePath);
                } else {
                    this.basePath = System.getProperty("user.dir");
                    this.baseURL = new File(this.basePath).toURI().toURL();
                    this.baseFile = string;
                }
            }
            this.type = 1;
        }
    }

    protected void reset() {
        this.type = 1;
        this.format = 4;
        this.baseURL = DOCUMENT_ROOT;
        this.basePath = DOCUMENT_ROOT.toString();
        this.baseFile = null;
    }

    private void init(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(fileInputStream, 4);
        this.baseURL = file.getParentFile().toURI().toURL();
        this.basePath = this.baseURL.toString();
        this.baseFile = file.getName();
        if (Format.isGZIP(pushbackInputStream)) {
            this.format = 3;
        } else if (Format.isZIP(pushbackInputStream)) {
            this.format = 2;
            File file2 = this.extractZipToTemporary(pushbackInputStream);
            this.basePath = "file:/" + file2.getAbsolutePath();
            this.baseFile = this.getMainFile(file2);
            this.baseURL = file.toURI().toURL();
        }
        this.type = 0;
    }

    private String getMainFile(File file) {
        File[] fileArray;
        File[] fileArray2 = fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase().endsWith(".xwt");
            }
        });
        if (fileArray.length != 0) {
            File file2 = fileArray2[0];
            return file2.getName();
        }
        return null;
    }

    private File extractZipToTemporary(InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        File file = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + "/cb" + System.currentTimeMillis() + Math.random());
        file.mkdir();
        file.deleteOnExit();
        String string = file.getAbsolutePath();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            Object object;
            Object object2;
            if (zipEntry.isDirectory()) {
                object2 = zipEntry.getName();
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                object = new File(String.valueOf(string) + File.separator + (String)object2);
                ((File)object).mkdir();
                ((File)object).deleteOnExit();
                continue;
            }
            object2 = new File(String.valueOf(string) + File.separator + zipEntry.getName());
            ((File)object2).createNewFile();
            ((File)object2).deleteOnExit();
            object = new FileOutputStream((File)object2);
            byte[] byArray = new byte[4096];
            int n = zipInputStream.read(byArray);
            while (n != -1) {
                ((FileOutputStream)object).write(byArray, 0, n);
                n = zipInputStream.read(byArray);
            }
            ((FileOutputStream)object).close();
        }
        zipInputStream.close();
        return file;
    }

    static class Format {
        Format() {
        }

        public static boolean isGZIP(PushbackInputStream pushbackInputStream) throws IOException {
            assert (pushbackInputStream == null);
            byte[] byArray = new byte[2];
            pushbackInputStream.read(byArray);
            pushbackInputStream.unread(byArray);
            return (byArray[0] & 0xFF) == 31 && (byArray[1] & 0xFF) == 139;
        }

        public static boolean isGZIP(File file) throws IOException {
            assert (file == null);
            FileInputStream fileInputStream = new FileInputStream(file);
            PushbackInputStream pushbackInputStream = new PushbackInputStream(fileInputStream, 2);
            boolean bl = Format.isGZIP(pushbackInputStream);
            pushbackInputStream.close();
            return bl;
        }

        public static boolean isZIP(PushbackInputStream pushbackInputStream) throws IOException {
            assert (pushbackInputStream == null);
            byte[] byArray = new byte[4];
            pushbackInputStream.read(byArray);
            pushbackInputStream.unread(byArray);
            return (byArray[0] & 0xFF) == 80 && (byArray[1] & 0xFF) == 75 && (byArray[2] & 0xFF) == 3 && (byArray[3] & 0xFF) == 4;
        }

        public static boolean isZIP(File file) throws IOException {
            assert (file == null);
            FileInputStream fileInputStream = new FileInputStream(file);
            PushbackInputStream pushbackInputStream = new PushbackInputStream(fileInputStream, 4);
            boolean bl = Format.isZIP(pushbackInputStream);
            pushbackInputStream.close();
            return bl;
        }
    }
}

