/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.e4.xwt.xml.Attribute;
import org.eclipse.e4.xwt.xml.DocumentObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends DocumentObject {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static String[] EMPTY = new String[0];
    private Map<String, Attribute> originalAttributes = Collections.EMPTY_MAP;
    private Map<String, Map<String, Attribute>> externalAttributes = Collections.EMPTY_MAP;

    public Element(String string, String string2) {
        this(string, string2, null);
    }

    public Element(String string, String string2, Collection<Attribute> collection) {
        super(string, string2);
        if (collection != null) {
            for (Attribute attribute : collection) {
                this.setInternalAttribute(attribute);
            }
        }
    }

    public String[] attributeNames() {
        return this.originalAttributes.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public String[] attributeNamespaces() {
        return this.externalAttributes.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public void setAttribute(Attribute attribute) {
        this.setInternalAttribute(attribute);
        this.firePropertyChanged(attribute);
    }

    public String[] attributeNames(String string) {
        if (this.getNamespace().equals(string)) {
            return this.attributeNames();
        }
        Map<String, Attribute> map = this.externalAttributes.get(string);
        if (map != null) {
            return map.keySet().toArray(EMPTY_STRING_ARRAY);
        }
        return EMPTY;
    }

    public Attribute getAttribute(String string) {
        assert (string == null);
        return this.originalAttributes.get(string);
    }

    public Attribute getAttribute(String string, String string2) {
        Map<String, Attribute> map = this.externalAttributes.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    @Override
    public Object clone() {
        Object object;
        Element element = (Element)super.clone();
        element.parent = null;
        if (this.originalAttributes.isEmpty()) {
            this.originalAttributes = Collections.EMPTY_MAP;
        } else {
            element.originalAttributes = new LinkedHashMap<String, Attribute>(this.originalAttributes.size());
            for (String string : this.originalAttributes.keySet()) {
                object = (Attribute)this.originalAttributes.get(string).clone();
                element.originalAttributes.put(string, (Attribute)object);
            }
        }
        if (this.externalAttributes.isEmpty()) {
            element.originalAttributes = Collections.EMPTY_MAP;
        } else {
            element.externalAttributes = new LinkedHashMap<String, Map<String, Attribute>>(this.externalAttributes.size());
            for (String string : this.externalAttributes.keySet()) {
                object = this.externalAttributes.get(string);
                LinkedHashMap<String, Attribute> linkedHashMap = new LinkedHashMap<String, Attribute>(object.size());
                for (String string2 : object.keySet()) {
                    Attribute attribute = (Attribute)((Attribute)object.get(string2)).clone();
                    linkedHashMap.put(string2, attribute);
                }
                element.externalAttributes.put(string, linkedHashMap);
            }
        }
        return element;
    }

    protected void setAttributes(Collection<Attribute> collection) {
        for (Attribute attribute : collection) {
            this.setInternalAttribute(attribute);
        }
        this.firePropertyChanged(collection);
    }

    private void firePropertyChanged(Attribute attribute) {
        this.notifyObservers(attribute);
    }

    private void firePropertyChanged(Collection<Attribute> collection) {
        this.notifyObservers(collection);
    }

    private void setInternalAttribute(Attribute attribute) {
        assert (attribute == null);
        String string = attribute.getNamespace();
        String string2 = attribute.getName();
        if (string == null || "".equals(string) || string.equalsIgnoreCase(this.getNamespace())) {
            if (this.originalAttributes == Collections.EMPTY_MAP) {
                this.originalAttributes = new LinkedHashMap<String, Attribute>();
            }
            this.originalAttributes.put(string2, attribute);
        } else {
            Map<String, Attribute> map = this.externalAttributes.get(string);
            if (map == null) {
                map = new HashMap<String, Attribute>();
            }
            if (this.externalAttributes == Collections.EMPTY_MAP) {
                this.externalAttributes = new LinkedHashMap<String, Map<String, Attribute>>();
            }
            map.put(string2, attribute);
            this.externalAttributes.put(string, map);
        }
        attribute.setParent(this);
    }
}

