/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.xml;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.e4.xwt.xml.Attribute;
import org.eclipse.e4.xwt.xml.DocumentObject;
import org.eclipse.e4.xwt.xml.Element;
import org.eclipse.e4.xwt.xml.ElementManager;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

class ElementHandler
extends DefaultHandler
implements ContentHandler {
    private Stack<StringBuffer> bufferStack;
    private Stack<DocumentObject> elementStack;
    private Stack<Boolean> switchStack;
    private StringBuffer textBuffer;
    private Locator locator;
    private boolean ignoreSystemProcession;
    private boolean hasSetDefaultEncoding;
    private ElementManager elementManager;
    private String defaultNamespace;
    private ExtensionParser extensionParser = new ExtensionParser();
    protected HashMap<String, String> namespaceMapping = new HashMap();
    private boolean needNormalizeName = true;

    public ElementHandler(ElementManager elementManager) {
        this.bufferStack = new Stack();
        this.elementStack = new Stack();
        this.ignoreSystemProcession = false;
        this.hasSetDefaultEncoding = false;
        this.elementManager = elementManager;
    }

    public ElementHandler(DocumentObject documentObject, ElementManager elementManager) {
        if (documentObject != null) {
            this.elementStack.push(documentObject);
            this.bufferStack.push(this.textBuffer);
        }
        this.ignoreSystemProcession = true;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.switchStack = new Stack();
        this.defaultNamespace = "http://www.eclipse.org/xwt/presentation";
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (string.length() == 0 && !this.ignoreSystemProcession) {
            this.defaultNamespace = string2;
        }
        this.namespaceMapping.put(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.namespaceMapping.remove(string);
    }

    public void endDocument() throws SAXException {
        this.elementStack.clear();
        this.bufferStack.clear();
        this.switchStack.clear();
        this.switchStack = null;
        this.defaultNamespace = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.switchStack.isEmpty() && !this.switchStack.peek().booleanValue()) {
            return;
        }
        String string = new String(cArray, n, n2);
        if (string.length() > 0) {
            if (this.textBuffer == null) {
                this.textBuffer = new StringBuffer(string);
            } else {
                this.textBuffer.append(string);
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!this.ignoreSystemProcession && !this.hasSetDefaultEncoding) {
            Locator2 locator2;
            String string4;
            if (this.locator instanceof Locator2 && (string4 = (locator2 = (Locator2)this.locator).getEncoding()) != null && string4.length() > 0) {
                this.elementManager.setEncoding(string4);
            }
            this.hasSetDefaultEncoding = true;
        }
        string = this.normalizeNamespace(string);
        if (!this.switchStack.isEmpty() && !this.switchStack.peek().booleanValue()) {
            if (string.equalsIgnoreCase("http://www.eclipse.org/xwt/presentation") && "Switch".equals(string2)) {
                this.switchStack.push(false);
            }
            return;
        }
        if (string2.indexOf(46) > 0) {
            this.preProperty(string, string2, attributes);
        } else {
            this.preElement(string, string2, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        string = this.normalizeNamespace(string);
        if (!this.switchStack.isEmpty() && !this.switchStack.peek().booleanValue()) {
            if (string.equalsIgnoreCase("http://www.eclipse.org/xwt/presentation") && "Switch".equals(string2)) {
                this.switchStack.pop();
            }
            return;
        }
        if (!this.elementStack.isEmpty()) {
            DocumentObject documentObject = this.elementStack.peek();
            if (documentObject instanceof Attribute) {
                this.postProperty(string, string2);
            } else {
                this.postElement(string, string2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void preElement(String var1_1, String var2_2, Attributes var3_3) throws SAXException {
        var1_1 = this.normalizeNamespace(var1_1);
        if ((var2_2 = this.normalizeName(var2_2)).equalsIgnoreCase("xdata")) {
            this.needNormalizeName = false;
        }
        var4_4 = this.getDefaultAttribute(var3_3, "id");
        var5_5 = null;
        if (var4_4 == null) {
            var4_4 = ElementManager.generateID(var2_2);
        }
        if (this.elementManager.hasElement(var4_4)) {
            throw new SAXException(this.getFormattedMessage("Element already exists: ", new Object[]{var4_4}));
        }
        var6_6 = new HashSet<Attribute>();
        var7_7 = 0;
        var8_9 = var3_3.getLength();
        while (var7_7 < var8_9) {
            var9_11 = this.normalizeNamespace(var3_3.getURI(var7_7));
            var10_12 = var3_3.getLocalName(var7_7);
            if (!"http://www.eclipse.org/xwt/presentation".equalsIgnoreCase(var9_11)) ** GOTO lbl-1000
            if ("id".equals(var10_12)) {
                var4_4 = var3_3.getValue(var7_7);
            } else if ("ref".equals(var10_12)) {
                var5_5 = var3_3.getValue(var7_7);
            } else lbl-1000:
            // 2 sources

            {
                if ((var12_14 = var10_12.indexOf(46)) != -1) {
                    var13_15 = this.normalizeName(var10_12.substring(0, var10_12.indexOf(46)));
                    var14_16 = this.normalizeName(var10_12.substring(var10_12.indexOf(46) + 1));
                    var11_13 = new Attribute(var9_11, var14_16, var4_4);
                    var11_13.setPrefix(var13_15);
                } else {
                    var11_13 = new Attribute(var9_11, this.normalizeName(var10_12), var4_4);
                }
                this.handleContent(var11_13, var3_3.getValue(var7_7));
                var6_6.add(var11_13);
            }
            ++var7_7;
        }
        if (var5_5 == null) {
            var7_8 = new Element(var1_1, var2_2, var6_6);
        } else {
            var8_10 = this.elementManager.getElement(var5_5);
            if (var8_10 != null) {
                if (!var8_10.getName().equals(var2_2)) {
                    throw new SAXException(this.getFormattedMessage("Elements named \"%s\" and \"%s\" are not same: %s", new Object[]{var4_4, var8_10.getId(), var2_2}));
                }
                if (!var8_10.getNamespace().equals(var1_1)) {
                    throw new SAXException(this.getFormattedMessage("Elements named \"%s\" and \"%s\" are not same: %s", new Object[]{var4_4, var8_10.getId(), var1_1}));
                }
                var7_8 = (Element)var8_10.clone();
            } else {
                throw new SAXException(this.getFormattedMessage("Element reference not found: %s", new Object[]{var5_5}));
            }
        }
        var7_8.setId(var4_4);
        if (var5_5 != null) {
            var7_8.setAttributes(var6_6);
        }
        if (!this.elementStack.isEmpty()) {
            this.elementStack.peek().addChild(var7_8);
        }
        this.elementStack.push(var7_8);
        this.bufferStack.push(this.textBuffer);
        this.textBuffer = null;
        this.elementManager.preElement(var7_8);
    }

    private void postElement(String string, String string2) throws SAXException {
        if (!this.elementStack.isEmpty()) {
            String string3;
            DocumentObject documentObject = this.elementStack.pop();
            if (this.textBuffer != null && (string3 = this.textBuffer.toString().trim()).length() > 0) {
                this.handleContent(documentObject, string3);
            }
            this.textBuffer = this.bufferStack.pop();
            this.elementManager.postElement((Element)documentObject);
        }
        if (string2.equalsIgnoreCase("xdata")) {
            this.needNormalizeName = true;
        }
    }

    protected void handleContent(DocumentObject documentObject, String string) {
        int n;
        if (string.startsWith("{") && string.endsWith("}")) {
            this.extensionParser.parse(documentObject, string);
            return;
        }
        if (("Type".equals(documentObject.getName()) || "Static".equals(documentObject.getName())) && (n = string.indexOf(58)) != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = this.namespaceMapping.get(string2);
            if (string4 != null) {
                Element element = new Element(string4, string3);
                element.setId(ElementManager.generateID(documentObject.getName()));
                documentObject.addChild(element);
                return;
            }
        }
        documentObject.setContent(string);
    }

    private void preProperty(String string, String string2, Attributes attributes) throws SAXException {
        String string3 = this.normalizeName(string2.substring(0, string2.indexOf(46)));
        String string4 = this.normalizeName(string2.substring(string2.indexOf(46) + 1));
        String string5 = null;
        int n = this.elementStack.size() - 1;
        while (n >= 0) {
            DocumentObject documentObject = (DocumentObject)this.elementStack.get(n);
            if (documentObject instanceof Element && documentObject.getName().equals(string3)) {
                string5 = documentObject.getId();
                break;
            }
            --n;
        }
        if (string5 == null) {
            this.preElement(string, string2, attributes);
        } else {
            string = this.normalizeNamespace(string);
            string2 = this.normalizeName(string2);
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            int n2 = 0;
            int n3 = attributes.getLength();
            while (n2 < n3) {
                Attribute attribute;
                String string6 = this.normalizeNamespace(attributes.getURI(n2));
                String string7 = attributes.getLocalName(n2);
                int n4 = string7.indexOf(46);
                if (n4 != -1) {
                    String string8 = this.normalizeName(string7.substring(0, string7.indexOf(46)));
                    String string9 = this.normalizeName(string7.substring(string7.indexOf(46) + 1));
                    attribute = new Attribute(string6, string9, string5);
                    attribute.setPrefix(string8);
                } else {
                    attribute = new Attribute(string6, this.normalizeName(string7), string5);
                }
                this.handleContent(attribute, attributes.getValue(n2));
                arrayList.add(attribute);
                ++n2;
            }
            Attribute attribute = new Attribute(string, string4, string5, arrayList);
            this.elementStack.push(attribute);
            this.bufferStack.push(this.textBuffer);
            this.textBuffer = null;
        }
    }

    private void postProperty(String string, String string2) throws SAXException {
        if (!this.elementStack.isEmpty()) {
            Object object;
            Attribute attribute = (Attribute)this.elementStack.pop();
            if (this.textBuffer != null && ((String)(object = this.textBuffer.toString().trim())).length() > 0) {
                this.handleContent(attribute, (String)object);
            }
            this.textBuffer = this.bufferStack.pop();
            object = this.elementManager.getElement(attribute.getId());
            ((Element)object).setAttribute(attribute);
        }
    }

    private String normalizeNamespace(String string) {
        if (string == null || string.length() == 0) {
            string = this.defaultNamespace;
        }
        if (string.startsWith("clr-namespace:")) {
            return string;
        }
        return string.toLowerCase();
    }

    private String normalizeName(String string) {
        if (!this.needNormalizeName) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (n == 0) {
                stringBuffer.append(Character.toUpperCase(c));
            } else {
                switch (c) {
                    case '-': {
                        bl = true;
                        break;
                    }
                    case '.': {
                        bl = true;
                        stringBuffer.append(c);
                        break;
                    }
                    default: {
                        if (bl) {
                            stringBuffer.append(Character.toUpperCase(c));
                            bl = false;
                            break;
                        }
                        stringBuffer.append(c);
                    }
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getDefaultAttribute(Attributes attributes, String string) {
        String string2 = attributes.getValue("http://www.eclipse.org/xwt/presentation", string);
        if (string2 == null || string2.length() == 0) {
            string2 = attributes.getValue(string);
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return string2;
    }

    private String getFormattedMessage(String string, Object ... objectArray) {
        StringBuffer stringBuffer = new StringBuffer("[" + this.locator.getLineNumber() + "," + this.locator.getColumnNumber() + "] ");
        stringBuffer.append(string);
        return MessageFormat.format(stringBuffer.toString(), objectArray);
    }

    static /* synthetic */ ElementManager access$1(ElementHandler elementHandler) {
        return elementHandler.elementManager;
    }

    class ExtensionParser {
        private Element root;
        private DocumentObject current;

        ExtensionParser() {
        }

        public void parse(DocumentObject documentObject, String string) {
            if (this.root != null) {
                ExtensionParser extensionParser = new ExtensionParser();
                extensionParser.parse(documentObject, string);
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", true);
            String string2 = null;
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string2 != null) {
                    if (string2.equals("{")) {
                        if (string4.equals("}")) {
                            if (stringTokenizer.hasMoreTokens()) {
                                this.handleBlock(stringTokenizer.nextToken(" \t\n\r\f"), false);
                            }
                        } else {
                            this.startBlock();
                        }
                    } else if (string2.equals("}")) {
                        this.endBlock();
                    } else {
                        String string5 = string2;
                        if (string4.equals("{")) {
                            int n = 1;
                            string5 = String.valueOf(string5) + string4;
                            while (stringTokenizer.hasMoreTokens() && n >= 0) {
                                String string6 = stringTokenizer.nextToken();
                                if (string6.equals("{")) {
                                    ++n;
                                } else if (string6.equals("}")) {
                                    --n;
                                }
                                if (n < 0) continue;
                                string5 = String.valueOf(string5) + string6;
                            }
                        }
                        this.handleBlock(string5, string3 == null || !string3.equals("}"));
                    }
                }
                string3 = string2;
                string2 = string4;
            }
            documentObject.addChild(this.root);
            this.root = null;
            this.current = null;
        }

        protected void startBlock() {
        }

        protected void endBlock() {
            if (this.current != null) {
                this.current = this.current.getParent().getParent();
            }
        }

        protected Element createElement(String string) {
            Object object;
            int n = string.indexOf(58);
            String string2 = null;
            String string3 = string;
            if (n != -1) {
                object = string.substring(0, n);
                string3 = string.substring(n + 1);
                string2 = ElementHandler.this.namespaceMapping.get(object);
            }
            if (string2 == null) {
                string2 = ElementHandler.this.defaultNamespace;
            }
            object = new Element(string2, string3);
            ((DocumentObject)object).setId(ElementManager.generateID(string3));
            if (this.current != null) {
                this.current.addChild((DocumentObject)object);
            } else if (this.root == null) {
                this.root = object;
            }
            this.current = object;
            return object;
        }

        protected void handleBlock(String string, boolean bl) {
            Object object;
            String string2 = " \t\n\r\f=,";
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
            String string3 = null;
            Object object2 = null;
            boolean bl2 = false;
            Element element = null;
            if (!bl && this.current instanceof Element) {
                element = (Element)this.current;
            }
            boolean bl3 = false;
            String string4 = null;
            while (bl3 || stringTokenizer.hasMoreTokens()) {
                if (!bl3) {
                    string4 = stringTokenizer.nextToken(string2).trim();
                }
                bl3 = false;
                if (string4.length() == 0) continue;
                if (element == null) {
                    element = this.createElement(string4);
                } else {
                    if (string4.equals("=")) {
                        bl2 = true;
                        if (!"xpath".equalsIgnoreCase(string3)) continue;
                        object2 = stringTokenizer.nextToken(",");
                        continue;
                    }
                    if (string4.equals(",")) {
                        if (string3 != null) {
                            if (object2 != null) {
                                object = new Attribute(this.current.getNamespace(), string3, ElementManager.generateID(this.current.getName()));
                                ElementHandler.this.handleContent((DocumentObject)object, (String)object2);
                                element.setAttribute((Attribute)object);
                                this.current = object;
                            } else {
                                element.setContent(string3);
                            }
                            string3 = null;
                            object2 = null;
                            bl2 = false;
                        }
                    } else if (string3 == null) {
                        string3 = string4;
                    } else {
                        object = string4;
                        if (string4.startsWith("{")) {
                            int n = 1;
                            while (stringTokenizer.hasMoreTokens() && n > 0) {
                                String string5 = stringTokenizer.nextToken("{}");
                                if (string5.equals("{")) {
                                    ++n;
                                } else if (string5.equals("}")) {
                                    --n;
                                }
                                object = String.valueOf(object) + string5;
                            }
                        }
                        object2 = object;
                        try {
                            string4 = stringTokenizer.nextToken(string2).trim();
                            bl3 = true;
                            continue;
                        }
                        catch (NoSuchElementException noSuchElementException) {}
                    }
                }
                bl3 = false;
            }
            if (bl2) {
                object = new Attribute(this.current.getNamespace(), string3, ElementManager.generateID(this.current.getName()));
                if (object2 != null) {
                    ElementHandler.this.handleContent((DocumentObject)object, (String)object2);
                    element.setAttribute((Attribute)object);
                } else {
                    element.setAttribute((Attribute)object);
                    this.current = object;
                }
            } else if (string3 != null) {
                int n = string3.indexOf(":");
                if (n != -1) {
                    element = this.createElement(string3);
                    this.current = this.current.getParent();
                } else {
                    this.current.setContent(string3);
                }
            }
        }
    }
}

