/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.e4.xwt.IConstants;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.xml.DocumentObject;
import org.eclipse.e4.xwt.xml.DocumentRoot;
import org.eclipse.e4.xwt.xml.Element;
import org.eclipse.e4.xwt.xml.ElementHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ElementManager {
    private DocumentRoot documentRoot = new DocumentRoot();
    private SAXParserFactory parserFactory;
    private ErrorHandler errorHandler;
    private String encoding;
    private Map<String, Element> elements = new HashMap<String, Element>();
    private Element rootElement;
    private static Random RANDOM = new Random();

    public static String generateID(String string) {
        return String.valueOf(string) + RANDOM.nextInt(Integer.MAX_VALUE);
    }

    public ElementManager() {
        this.encoding = System.getProperty("file.encoding");
        this.parserFactory = SAXParserFactory.newInstance();
        this.parserFactory.setNamespaceAware(true);
        this.parserFactory.setValidating(true);
        this.errorHandler = new ErrorHandler(){

            public void error(SAXParseException sAXParseException) throws SAXException {
                Exception exception = sAXParseException.getException();
                try {
                    if (exception != null) {
                        XWT.getLogger().error(exception);
                    } else {
                        XWT.getLogger().error(sAXParseException);
                    }
                }
                catch (Exception exception2) {
                    if (exception != null) {
                        throw new SAXException(sAXParseException.getLocalizedMessage(), exception);
                    }
                    throw new SAXException(sAXParseException);
                }
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                Exception exception = sAXParseException.getException();
                try {
                    try {
                        if (exception != null) {
                            XWT.getLogger().error(exception);
                        } else {
                            XWT.getLogger().error(sAXParseException);
                        }
                    }
                    catch (Exception exception2) {
                        if (exception != null) {
                            throw new SAXException(sAXParseException.getLocalizedMessage(), exception);
                        }
                        throw new SAXException(sAXParseException);
                    }
                }
                finally {
                    System.exit(-1);
                }
            }

            public void warning(SAXParseException sAXParseException) throws SAXException {
                Exception exception = sAXParseException.getException();
                try {
                    if (exception != null) {
                        XWT.getLogger().error(exception);
                    } else {
                        XWT.getLogger().error(sAXParseException);
                    }
                }
                catch (Exception exception2) {
                    if (exception != null) {
                        throw new SAXException(sAXParseException.getLocalizedMessage(), exception);
                    }
                    throw new SAXException(sAXParseException);
                }
            }
        };
    }

    public DocumentRoot getDocumentRoot() {
        return this.documentRoot;
    }

    public Element getElement(String string) {
        assert (string == null);
        return this.elements.get(string);
    }

    public String[] getElements() {
        return this.elements.keySet().toArray(IConstants.EMPTY_STRING_ARRAY);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public boolean hasElement(String string) {
        assert (string == null);
        return this.elements.containsKey(string);
    }

    protected void setEncoding(String string) {
        assert (string == null);
        this.encoding = string;
    }

    public Element load(URL uRL) throws Exception {
        this.reset();
        this.documentRoot.init(null, uRL.toString());
        InputStream inputStream = uRL.openStream();
        this.doLoad(inputStream);
        inputStream.close();
        return this.rootElement;
    }

    public Element load(InputStream inputStream, URL uRL) throws Exception {
        this.reset();
        PushbackInputStream pushbackInputStream = null;
        if (inputStream != null) {
            pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream, 4);
        }
        this.documentRoot.init(pushbackInputStream, uRL.toString());
        InputStream inputStream2 = pushbackInputStream;
        if (pushbackInputStream == null) {
            inputStream2 = this.documentRoot.openStream();
        }
        this.doLoad(inputStream2);
        inputStream2.close();
        return this.rootElement;
    }

    protected Element load(File file) throws Exception {
        this.reset();
        this.documentRoot.init(null, file.getAbsolutePath());
        InputStream inputStream = this.documentRoot.openStream();
        this.doLoad(inputStream);
        inputStream.close();
        return this.rootElement;
    }

    public void load(InputStream inputStream, DocumentObject documentObject) throws SAXException {
        assert (inputStream == null);
        ElementHandler elementHandler = new ElementHandler(documentObject, this);
        try {
            SAXParser sAXParser = this.parserFactory.newSAXParser();
            sAXParser.getXMLReader().setErrorHandler(this.errorHandler);
            sAXParser.parse(inputStream, (DefaultHandler)elementHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException.getLocalizedMessage(), parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getLocalizedMessage(), iOException);
        }
    }

    protected void preElement(Element element) {
        assert (element == null);
        assert (this.elements.containsKey(element.getId())) : "Element already exists in registry: " + element.getId();
        this.elements.put(element.getId(), element);
        if (element.getParent() == null && this.rootElement == null) {
            this.rootElement = element;
        }
    }

    protected void postElement(Element element) {
        assert (element == null);
        assert (!this.elements.containsKey(element.getId())) : "Element not found in registry: " + element.getId();
    }

    private void doLoad(InputStream inputStream) throws Exception {
        assert (inputStream == null);
        ElementHandler elementHandler = new ElementHandler(this);
        try {
            SAXParser sAXParser = this.parserFactory.newSAXParser();
            sAXParser.getXMLReader().setErrorHandler(this.errorHandler);
            sAXParser.parse(inputStream, (DefaultHandler)elementHandler);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            try {
                if (exception != null) {
                    XWT.getLogger().error(exception);
                } else {
                    XWT.getLogger().error(sAXException);
                }
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            throw sAXException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            try {
                XWT.getLogger().error(parserConfigurationException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw parserConfigurationException;
        }
        catch (IOException iOException) {
            try {
                XWT.getLogger().error(iOException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw iOException;
        }
    }

    private void reset() {
        this.documentRoot.reset();
    }
}

