/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.utils.ClassUtils;
import org.eclipse.e4.ui.css.core.utils.NumberUtils;
import org.eclipse.e4.ui.css.swt.helpers.SWTStyleHelpers;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SWTElement
extends ElementAdapter
implements NodeList {
    protected String localName = this.computeLocalName();
    protected String namespaceURI = this.computeNamespaceURI();
    protected String swtStyles;

    public static String getCSSClass(Widget widget) {
        return (String)widget.getData("org.eclipse.e4.ui.css.CssClassName");
    }

    public static String getID(Widget widget) {
        return (String)widget.getData("org.eclipse.e4.ui.css.id");
    }

    public static void setCSSClass(Widget widget, String string) {
        widget.setData("org.eclipse.e4.ui.css.CssClassName", (Object)string);
    }

    public static void setID(Widget widget, String string) {
        widget.setData("org.eclipse.e4.ui.css.id", (Object)string);
    }

    public SWTElement(Widget widget, CSSEngine cSSEngine) {
        super((Object)widget, cSSEngine);
        this.computeStaticPseudoInstances();
        this.swtStyles = this.computeAttributeSWTStyle();
    }

    protected String computeLocalName() {
        Widget widget = this.getWidget();
        Class<?> clazz = widget.getClass();
        return ClassUtils.getSimpleName(clazz);
    }

    protected String computeNamespaceURI() {
        Widget widget = this.getWidget();
        Class<?> clazz = widget.getClass();
        return ClassUtils.getPackageName(clazz);
    }

    protected void computeStaticPseudoInstances() {
        Widget widget = this.getWidget();
        if (widget instanceof CTabFolder) {
            super.addStaticPseudoInstance("selected");
        }
    }

    protected String computeAttributeSWTStyle() {
        return SWTStyleHelpers.getSWTWidgetStyleAsString(this.getWidget());
    }

    public String getAttribute(String string) {
        Widget widget = this.getWidget();
        if (string.equals("style")) {
            return this.swtStyles;
        }
        Object object = widget.getData(string.toLowerCase());
        if (object != null) {
            return object.toString();
        }
        try {
            object = PropertyUtils.getProperty((Object)widget, (String)string);
            if (object != null) {
                return object.toString();
            }
        }
        catch (Exception exception) {}
        return "";
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public Node getParentNode() {
        Control control;
        Composite composite;
        Widget widget = this.getWidget();
        if (widget instanceof Control && (composite = (control = (Control)widget).getParent()) != null) {
            Element element = this.getElement(composite);
            return element;
        }
        return null;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public int getLength() {
        Widget widget = this.getWidget();
        if (widget instanceof Composite) {
            return ((Composite)widget).getChildren().length;
        }
        return 0;
    }

    public Node item(int n) {
        Widget widget = this.getWidget();
        if (widget instanceof Composite) {
            Control control = ((Composite)widget).getChildren()[n];
            return this.getElement(control);
        }
        return null;
    }

    protected Widget getWidget() {
        return (Widget)this.getNativeWidget();
    }

    public String getCSSId() {
        Widget widget = this.getWidget();
        String string = SWTElement.getID(widget);
        if (string != null) {
            return string.toString();
        }
        return null;
    }

    public String getCSSClass() {
        Widget widget = this.getWidget();
        String string = SWTElement.getCSSClass(widget);
        if (string != null) {
            return string.toString();
        }
        return null;
    }

    public String getCSSStyle() {
        Widget widget = this.getWidget();
        Object object = widget.getData("style");
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public boolean isPseudoInstanceOf(String string) {
        Object object;
        if ("enabled".equals(string)) {
            Control control = (Control)this.getNativeWidget();
            return control.isEnabled();
        }
        if ("disabled".equals(string)) {
            Control control = (Control)this.getNativeWidget();
            return !control.isEnabled();
        }
        if ("checked".equals(string)) {
            if (this.getNativeWidget() instanceof Button) {
                Button button = (Button)this.getNativeWidget();
                return button.getSelection();
            }
            return false;
        }
        if ("visible".equals(string)) {
            Control control = (Control)this.getNativeWidget();
            return !control.isVisible();
        }
        if ("focus".equals(string) && (object = (Control)this.getNativeWidget()).isFocusControl()) {
            return object.getData("focusLost") == null;
        }
        if ("active".equals(string) && this.getNativeWidget() instanceof Shell && (object = (Control)this.getNativeWidget()).isEnabled()) {
            return object.getData("activeLost") == null;
        }
        if ("hover".equals(string)) {
            object = (Control)this.getNativeWidget();
            return object.getData("mouseHover") != null;
        }
        if ("odd".equals(string) && (object = this.getNativeWidget()) instanceof TableItem) {
            TableItem tableItem = (TableItem)object;
            int n = tableItem.getParent().indexOf(tableItem);
            return NumberUtils.isOdd((int)n);
        }
        if ("even".equals(string) && (object = this.getNativeWidget()) instanceof TableItem) {
            TableItem tableItem = (TableItem)object;
            int n = tableItem.getParent().indexOf(tableItem);
            return NumberUtils.isEven((int)n);
        }
        return super.isPseudoInstanceOf(string);
    }
}

