/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom.html;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.SWTElement;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class SWTHTMLElement
extends SWTElement {
    protected String attributeType = this.computeAttributeType();

    public SWTHTMLElement(Widget widget, CSSEngine cSSEngine) {
        super(widget, cSSEngine);
    }

    public String getAttribute(String string) {
        if ("type".equals(string)) {
            return this.attributeType;
        }
        return super.getAttribute(string);
    }

    protected String computeLocalName() {
        Widget widget = this.getWidget();
        if (widget instanceof Text) {
            int n = widget.getStyle();
            if ((n | 2) == n) {
                return "textarea";
            }
            return "input";
        }
        if (widget instanceof Button) {
            return "input";
        }
        if (widget instanceof Combo) {
            return "select";
        }
        if (widget instanceof CCombo) {
            return "select";
        }
        if (widget instanceof Label) {
            return "label";
        }
        if (widget instanceof Shell) {
            return "body";
        }
        if (widget instanceof Canvas) {
            return "canvas";
        }
        if (widget instanceof Scrollable) {
            return "div";
        }
        if (widget instanceof List) {
            return "body";
        }
        if (widget instanceof Group) {
            return "div";
        }
        if (widget instanceof Link) {
            return "a";
        }
        if (widget instanceof Composite) {
            return "div";
        }
        if (widget instanceof Tree) {
            return "tree";
        }
        if (widget instanceof Table) {
            return "listbox";
        }
        return super.computeLocalName();
    }

    protected String computeAttributeType() {
        Widget widget = this.getWidget();
        if (widget instanceof Button) {
            Button button = (Button)widget;
            int n = button.getStyle();
            if ((n | 0x10) == n) {
                return "radio";
            }
            if ((n | 0x20) == n) {
                return "checkbox";
            }
            return "button";
        }
        if (widget instanceof Text) {
            Text text = (Text)widget;
            if ((text.getStyle() & 0x400000) != 0) {
                return "password";
            }
            if ((text.getStyle() & 2) != 0) {
                return "";
            }
            return "text";
        }
        return "";
    }
}

