/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.e4.ui.css.core.css2.CSS2RGBColorImpl;
import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.RGBColor;

public class CSSSWTColorHelper {
    public static Color getSWTColor(RGBColor rGBColor, Display display) {
        RGB rGB = CSSSWTColorHelper.getRGB(rGBColor);
        return new Color((Device)display, rGB);
    }

    public static Color getSWTColor(CSSValue cSSValue, Display display) {
        if (cSSValue.getCssValueType() != 1) {
            return null;
        }
        RGB rGB = CSSSWTColorHelper.getRGB((CSSPrimitiveValue)cSSValue);
        if (rGB == null) {
            return null;
        }
        Color color = new Color((Device)display, rGB.red, rGB.green, rGB.blue);
        return color;
    }

    public static RGB getRGB(String string) {
        RGBColor rGBColor = CSS2ColorHelper.getRGBColor((String)string);
        if (rGBColor != null) {
            return CSSSWTColorHelper.getRGB(rGBColor);
        }
        return null;
    }

    public static RGB getRGB(RGBColor rGBColor) {
        return new RGB((int)rGBColor.getRed().getFloatValue((short)1), (int)rGBColor.getGreen().getFloatValue((short)1), (int)rGBColor.getBlue().getFloatValue((short)1));
    }

    public static RGB getRGB(CSSValue cSSValue) {
        if (cSSValue.getCssValueType() != 1) {
            return null;
        }
        return CSSSWTColorHelper.getRGB((CSSPrimitiveValue)cSSValue);
    }

    public static RGB getRGB(CSSPrimitiveValue cSSPrimitiveValue) {
        RGB rGB = null;
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 19: 
            case 21: {
                String string = cSSPrimitiveValue.getStringValue();
                rGB = CSSSWTColorHelper.getRGB(string);
                break;
            }
            case 25: {
                RGBColor rGBColor = cSSPrimitiveValue.getRGBColorValue();
                rGB = CSSSWTColorHelper.getRGB(rGBColor);
            }
        }
        return rGB;
    }

    public static Integer getPercent(CSSPrimitiveValue cSSPrimitiveValue) {
        int n = 0;
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 2: {
                n = (int)cSSPrimitiveValue.getFloatValue((short)2);
            }
        }
        return new Integer(n);
    }

    public static Gradient getGradient(CSSValueList cSSValueList) {
        Gradient gradient = new Gradient();
        int n = 0;
        while (n < cSSValueList.getLength()) {
            CSSValue cSSValue = cSSValueList.item(n);
            if (!cSSValue.getCssText().equals("gradient") && cSSValue.getCssValueType() == 1) {
                switch (((CSSPrimitiveValue)cSSValue).getPrimitiveType()) {
                    case 19: 
                    case 21: 
                    case 25: {
                        RGB rGB = CSSSWTColorHelper.getRGB((CSSPrimitiveValue)cSSValue);
                        if (rGB == null) break;
                        gradient.addRGB((Object)rGB);
                        break;
                    }
                    case 2: {
                        gradient.addPercent(CSSSWTColorHelper.getPercent((CSSPrimitiveValue)cSSValue));
                    }
                }
            }
            ++n;
        }
        return gradient;
    }

    public static RGBColor getRGBColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return new CSS2RGBColorImpl(n, n2, n3);
    }

    public static RGBColor getRGBColor(RGB rGB) {
        int n = rGB.red;
        int n2 = rGB.green;
        int n3 = rGB.blue;
        return new CSS2RGBColorImpl(n, n2, n3);
    }
}

