/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.core.css2.CSS2FontHelper;
import org.eclipse.e4.ui.css.core.css2.CSS2FontPropertiesHelpers;
import org.eclipse.e4.ui.css.core.css2.CSS2PrimitiveValueImpl;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontPropertiesImpl;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSPrimitiveValue;

public class CSSSWTFontHelper {
    public static CSS2FontProperties getCSS2FontProperties(Widget widget, Font font, CSSElementContext cSSElementContext) {
        CSS2FontProperties cSS2FontProperties = CSS2FontPropertiesHelpers.getCSS2FontProperties((CSSElementContext)cSSElementContext);
        if (cSS2FontProperties == null) {
            cSS2FontProperties = CSSSWTFontHelper.getCSS2FontProperties(font);
            CSS2FontPropertiesHelpers.setCSS2FontProperties((CSS2FontProperties)cSS2FontProperties, (CSSElementContext)cSSElementContext);
        }
        return cSS2FontProperties;
    }

    public static CSS2FontProperties getCSS2FontProperties(Control control, CSSElementContext cSSElementContext) {
        CSS2FontProperties cSS2FontProperties = CSS2FontPropertiesHelpers.getCSS2FontProperties((CSSElementContext)cSSElementContext);
        if (cSS2FontProperties == null) {
            Font font = control.getFont();
            cSS2FontProperties = CSSSWTFontHelper.getCSS2FontProperties(font);
            CSS2FontPropertiesHelpers.setCSS2FontProperties((CSS2FontProperties)cSS2FontProperties, (CSSElementContext)cSSElementContext);
        }
        return cSS2FontProperties;
    }

    public static CSS2FontProperties getCSS2FontProperties(Font font) {
        CSS2FontPropertiesImpl cSS2FontPropertiesImpl = new CSS2FontPropertiesImpl();
        if (font != null) {
            FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
            String string = CSSSWTFontHelper.getFontFamily(font);
            cSS2FontPropertiesImpl.setFamily((CSSPrimitiveValue)new CSS2PrimitiveValueImpl(string));
            int n = fontData.getHeight();
            cSS2FontPropertiesImpl.setSize((CSSPrimitiveValue)new CSS2PrimitiveValueImpl(n));
            String string2 = CSSSWTFontHelper.getFontWeight(font);
            cSS2FontPropertiesImpl.setWeight((CSSPrimitiveValue)new CSS2PrimitiveValueImpl(string2));
            String string3 = CSSSWTFontHelper.getFontStyle(font);
            cSS2FontPropertiesImpl.setStyle((CSSPrimitiveValue)new CSS2PrimitiveValueImpl(string3));
        }
        return cSS2FontPropertiesImpl;
    }

    public static Font getFont(CSS2FontProperties cSS2FontProperties, Control control) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(control.getFont());
        return CSSSWTFontHelper.getFont(cSS2FontProperties, fontData, control.getDisplay());
    }

    public static Font getFont(CSS2FontProperties cSS2FontProperties, FontData fontData, Display display) {
        FontData fontData2 = CSSSWTFontHelper.getFontData(cSS2FontProperties, fontData);
        return new Font((Device)display, fontData2);
    }

    public static FontData getFontData(CSS2FontProperties cSS2FontProperties, FontData fontData) {
        FontData fontData2 = new FontData();
        int n = CSSSWTFontHelper.getSWTStyle(cSS2FontProperties, fontData);
        fontData2.setStyle(n);
        CSSPrimitiveValue cSSPrimitiveValue = cSS2FontProperties.getSize();
        if (cSSPrimitiveValue != null) {
            fontData2.setHeight((int)cSSPrimitiveValue.getFloatValue((short)9));
        } else if (fontData != null) {
            fontData2.setHeight(fontData.getHeight());
        }
        CSSPrimitiveValue cSSPrimitiveValue2 = cSS2FontProperties.getFamily();
        if (cSSPrimitiveValue2 != null) {
            fontData2.setName(cSSPrimitiveValue2.getStringValue());
        } else if (fontData != null) {
            fontData2.setName(fontData.getName());
        }
        return fontData2;
    }

    public static int getSWTStyle(CSS2FontProperties cSS2FontProperties, FontData fontData) {
        Object object;
        if (fontData == null) {
            return 0;
        }
        int n = fontData.getStyle();
        CSSPrimitiveValue cSSPrimitiveValue = cSS2FontProperties.getStyle();
        if (cSSPrimitiveValue != null) {
            object = cSSPrimitiveValue.getStringValue();
            if ("italic".equals(object)) {
                n |= 2;
            } else if (n == (n | 2)) {
                n ^= 2;
            }
        }
        if ((object = cSS2FontProperties.getWeight()) != null) {
            String string = object.getStringValue();
            if ("bold".equals(string.toLowerCase())) {
                n |= 1;
            } else if (n == (n | 1)) {
                n ^= 1;
            }
        }
        return n;
    }

    public static String getFontFamily(Control control) {
        return CSSSWTFontHelper.getFontFamily(control.getFont());
    }

    public static String getFontFamily(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontFamily(fontData);
    }

    public static String getFontFamily(FontData fontData) {
        if (fontData != null) {
            String string = fontData.getName();
            return CSS2FontHelper.getFontFamily((String)string);
        }
        return null;
    }

    public static String getFontSize(Control control) {
        return CSSSWTFontHelper.getFontSize(control.getFont());
    }

    public static String getFontSize(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontSize(fontData);
    }

    public static String getFontSize(FontData fontData) {
        if (fontData != null) {
            return CSS2FontHelper.getFontSize((int)fontData.getHeight());
        }
        return null;
    }

    public static String getFontStyle(Control control) {
        return CSSSWTFontHelper.getFontStyle(control.getFont());
    }

    public static String getFontStyle(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontStyle(fontData);
    }

    public static String getFontStyle(FontData fontData) {
        boolean bl = false;
        if (fontData != null) {
            bl = CSSSWTFontHelper.isItalic(fontData);
        }
        return CSS2FontHelper.getFontStyle((boolean)bl);
    }

    public static boolean isItalic(FontData fontData) {
        int n = fontData.getStyle();
        return (n | 2) == n;
    }

    public static String getFontWeight(Control control) {
        return CSSSWTFontHelper.getFontWeight(control.getFont());
    }

    public static String getFontWeight(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontWeight(fontData);
    }

    public static String getFontWeight(FontData fontData) {
        boolean bl = false;
        if (fontData != null) {
            bl = CSSSWTFontHelper.isBold(fontData);
        }
        return CSS2FontHelper.getFontWeight((boolean)bl);
    }

    public static boolean isBold(FontData fontData) {
        int n = fontData.getStyle();
        return (n | 1) == n;
    }

    public static String getFontComposite(Control control) {
        return CSSSWTFontHelper.getFontComposite(control.getFont());
    }

    public static String getFontComposite(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontComposite(fontData);
    }

    public static String getFontComposite(FontData fontData) {
        if (fontData != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(CSSSWTFontHelper.getFontFamily(fontData));
            stringBuffer.append(" ");
            stringBuffer.append(CSSSWTFontHelper.getFontSize(fontData));
            stringBuffer.append(" ");
            stringBuffer.append(CSSSWTFontHelper.getFontWeight(fontData));
            stringBuffer.append(" ");
            stringBuffer.append(CSSSWTFontHelper.getFontStyle(fontData));
            return stringBuffer.toString();
        }
        return null;
    }

    public static FontData getFirstFontData(Control control) {
        Font font = control.getFont();
        if (font == null) {
            return null;
        }
        return CSSSWTFontHelper.getFirstFontData(font);
    }

    public static FontData getFirstFontData(Font font) {
        FontData[] fontDataArray = font.getFontData();
        if (fontDataArray == null || fontDataArray.length < 1) {
            return null;
        }
        return fontDataArray[0];
    }
}

