/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.core.dom.properties.CSSBorderProperties;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.css.CSSPrimitiveValue;

public class CSSSWTHelpers {
    public static PaintListener createBorderPaintListener(final Control control, IResourcesRegistry iResourcesRegistry) {
        return new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                CSSBorderProperties cSSBorderProperties = (CSSBorderProperties)control.getData("org.eclipse.e4.ui.core.css.swt.CONTROL_CSS2BORDER_KEY");
                if (cSSBorderProperties == null) {
                    return;
                }
                int n = cSSBorderProperties.getWidth();
                GC gC = paintEvent.gc;
                CSSPrimitiveValue cSSPrimitiveValue = cSSBorderProperties.getColor();
                if (cSSPrimitiveValue == null) {
                    return;
                }
                Color color = CSSSWTColorHelper.getSWTColor(cSSPrimitiveValue, control.getDisplay());
                if (color != null) {
                    gC.setForeground(color);
                }
                Rectangle rectangle = control.getBounds();
                if (n == 0) {
                    Rectangle rectangle2 = new Rectangle(rectangle.x - n, rectangle.y - n, rectangle.width + 2 * n, rectangle.height + 2 * n);
                    gC.fillRectangle(rectangle2);
                } else {
                    String string = cSSBorderProperties.getStyle();
                    gC.setLineStyle(CSSSWTHelpers.getLineStyle(string));
                    gC.setLineWidth(n);
                    gC.drawLine(rectangle.x, rectangle.y - 1, rectangle.width + 2 * n, rectangle.y - 1);
                    gC.setLineStyle(CSSSWTHelpers.getLineStyle(string));
                    gC.setLineWidth(n);
                    gC.drawLine(rectangle.x, rectangle.y + rectangle.height + 1, rectangle.width + 2 * n, rectangle.y + rectangle.height + 1);
                    gC.setLineStyle(CSSSWTHelpers.getLineStyle(string));
                    gC.setLineWidth(n);
                    gC.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.x - 1, rectangle.y + rectangle.height + 1);
                    gC.setLineStyle(CSSSWTHelpers.getLineStyle(string));
                    gC.setLineWidth(n);
                    gC.drawLine(rectangle.width + 2 * n, rectangle.y - 1, rectangle.width + 2 * n, rectangle.y + rectangle.height + 1);
                }
            }
        };
    }

    public static int getLineStyle(String string) {
        if (string == null) {
            return 1;
        }
        if ("dashed".equals(string)) {
            return 2;
        }
        if ("dotted".equals(string)) {
            return 3;
        }
        return 1;
    }
}

