/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GradientBackgroundListener
implements Listener {
    private Gradient grad;
    private Control control;
    private static Map handlers = new HashMap();

    private GradientBackgroundListener(Control control, Gradient gradient) {
        this.grad = gradient;
        this.control = control;
        control.addListener(11, (Listener)this);
    }

    public static void handle(Control control, Gradient gradient) {
        GradientBackgroundListener gradientBackgroundListener = (GradientBackgroundListener)handlers.get(control);
        if (gradientBackgroundListener == null) {
            gradientBackgroundListener = new GradientBackgroundListener(control, gradient);
            handlers.put(control, gradientBackgroundListener);
        } else {
            gradientBackgroundListener.grad = gradient;
            gradientBackgroundListener.handleEvent(null);
        }
    }

    public void handleEvent(Event event) {
        Point point = this.control.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return;
        }
        Image image = this.control.getBackgroundImage();
        if (image != null && !image.isDisposed()) {
            image.dispose();
            image = null;
        }
        Image image2 = new Image((Device)this.control.getDisplay(), point.x, point.y);
        GC gC = new GC((Drawable)image2);
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (RGB rGB : this.grad.getRGBs()) {
            Color color = new Color((Device)this.control.getDisplay(), rGB.red, rGB.green, rGB.blue);
            arrayList.add(color);
        }
        GradientBackgroundListener.fillGradient(gC, new Rectangle(0, 0, point.x, point.y), arrayList, this.grad.getPercents(), true);
        gC.dispose();
        for (Color color : arrayList) {
            color.dispose();
        }
        this.control.setBackgroundImage(image2);
    }

    private static void fillGradient(GC gC, Rectangle rectangle, List list, List list2, boolean bl) {
        Color color = (Color)list.get(list.size() - 1);
        if (list.size() == 1) {
            if (list.get(0) != null) {
                gC.setBackground((Color)list.get(0));
            }
            gC.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            Color color2 = (Color)list.get(0);
            int n = bl ? rectangle.y : rectangle.x;
            int n2 = Math.min(list.size() - 1, list2.size());
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                gC.setForeground(color2);
                color2 = (Color)list.get(n3 + 1);
                if (color2 == null) {
                    color2 = color;
                }
                gC.setBackground(color2);
                int n5 = (Integer)list2.get(n3);
                if (bl) {
                    n4 = n5 * rectangle.height / 100 - (n - rectangle.y);
                    gC.fillGradientRectangle(rectangle.x, n, rectangle.width, n4, true);
                    n += n4;
                } else {
                    n4 = n5 * rectangle.width / 100 - (n - rectangle.x);
                    gC.fillGradientRectangle(n, rectangle.y, n4, rectangle.height, false);
                    n += n4;
                }
                ++n3;
            }
            if (bl && n < rectangle.height) {
                gC.setBackground(color);
                gC.fillRectangle(rectangle.x, n, rectangle.width, rectangle.height - n);
            }
            if (!bl && n < rectangle.width) {
                gC.setBackground(color);
                gC.fillRectangle(n, rectangle.y, rectangle.width - n, rectangle.height);
            }
        }
    }
}

