/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.converters;

import org.eclipse.e4.ui.css.core.dom.properties.converters.AbstractCSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverterConfig;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTFontHelper;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.CSSValue;

public class CSSValueSWTFontDataConverterImpl
extends AbstractCSSValueConverter {
    public static final ICSSValueConverter INSTANCE = new CSSValueSWTFontDataConverterImpl();

    public CSSValueSWTFontDataConverterImpl(Object object) {
        super(object);
    }

    public CSSValueSWTFontDataConverterImpl() {
        super(FontData.class);
    }

    public Object convert(CSSValue cSSValue, CSSEngine cSSEngine, Object object) throws Exception {
        FontData fontData = null;
        if (object != null) {
            Font font;
            Display display;
            if (object instanceof Display) {
                display = (Display)object;
                font = display.getSystemFont();
                fontData = CSSSWTFontHelper.getFirstFontData(font);
            }
            if (object instanceof Control) {
                display = (Control)object;
                font = display.getFont();
                fontData = CSSSWTFontHelper.getFirstFontData(font);
            }
            if (object instanceof Font) {
                display = (Font)object;
                fontData = CSSSWTFontHelper.getFirstFontData((Font)display);
            }
        }
        if (fontData != null && cSSValue instanceof CSS2FontProperties) {
            return CSSSWTFontHelper.getFontData((CSS2FontProperties)cSSValue, fontData);
        }
        return null;
    }

    public String convert(Object object, CSSEngine cSSEngine, Object object2, ICSSValueConverterConfig iCSSValueConverterConfig) throws Exception {
        FontData fontData = (FontData)object;
        if (object2 instanceof String) {
            String string = (String)object2;
            if ("font-family".equals(string)) {
                return CSSSWTFontHelper.getFontFamily(fontData);
            }
            if ("font-size".equals(string)) {
                return CSSSWTFontHelper.getFontSize(fontData);
            }
            if ("font-style".equals(string)) {
                return CSSSWTFontHelper.getFontStyle(fontData);
            }
            if ("font-weight".equals(string)) {
                return CSSSWTFontHelper.getFontWeight(fontData);
            }
            if ("font".equals(string)) {
                return CSSSWTFontHelper.getFontComposite(fontData);
            }
        }
        return null;
    }

    protected Display getDisplay(Object object) {
        if (object instanceof Display) {
            return (Display)object;
        }
        if (object instanceof Control) {
            return ((Control)object).getDisplay();
        }
        return null;
    }
}

