/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.css2;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyBackgroundHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyBackgroundHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.e4.ui.css.swt.properties.GradientBackgroundListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyBackgroundSWTHandler
extends AbstractCSSPropertyBackgroundHandler {
    private static Log logger = LogFactory.getLog(CSSPropertyBackgroundSWTHandler.class);
    public static final ICSSPropertyBackgroundHandler INSTANCE = new CSSPropertyBackgroundSWTHandler();

    public boolean applyCSSProperty(Object object, String string, CSSValue cSSValue, String string2, CSSEngine cSSEngine) throws Exception {
        Control control = SWTElementHelpers.getControl(object);
        if (control != null) {
            super.applyCSSProperty((Object)control, string, cSSValue, string2, cSSEngine);
            return true;
        }
        return false;
    }

    public String retrieveCSSProperty(Object object, String string, String string2, CSSEngine cSSEngine) throws Exception {
        Control control = SWTElementHelpers.getControl(object);
        if (control != null) {
            return super.retrieveCSSProperty((Object)control, string, string2, cSSEngine);
        }
        return null;
    }

    public void applyCSSPropertyBackgroundColor(Object object, CSSValue cSSValue, String string, CSSEngine cSSEngine) throws Exception {
        Control control = (Control)object;
        if (cSSValue.getCssValueType() == 1) {
            Color color = (Color)cSSEngine.convert(cSSValue, Color.class, (Object)control.getDisplay());
            if (control instanceof CTabFolder && "selected".equals(string)) {
                ((CTabFolder)control).setSelectionBackground(color);
            } else {
                control.setBackground(color);
            }
        } else if (cSSValue.getCssValueType() == 2) {
            Gradient gradient = (Gradient)cSSEngine.convert(cSSValue, Gradient.class, (Object)control.getDisplay());
            GradientBackgroundListener.handle(control, gradient);
        }
    }

    public void applyCSSPropertyBackgroundImage(Object object, CSSValue cSSValue, String string, CSSEngine cSSEngine) throws Exception {
        block6: {
            Control control = (Control)object;
            Image image = (Image)cSSEngine.convert(cSSValue, Image.class, (Object)control.getDisplay());
            if (control instanceof CTabFolder && "selected".equals(string)) {
                ((CTabFolder)control).setSelectionBackground(image);
            } else if (control instanceof Button) {
                Button button = (Button)control;
                button.setImage(image);
            } else {
                try {
                    control.setBackgroundImage(image);
                }
                catch (Throwable throwable) {
                    if (!logger.isWarnEnabled()) break block6;
                    logger.warn((Object)"Impossible to manage backround-image, This SWT version doesn't support control.setBackgroundImage(Image image) Method");
                }
            }
        }
    }

    public String retrieveCSSPropertyBackgroundAttachment(Object object, String string, CSSEngine cSSEngine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyBackgroundColor(Object object, String string, CSSEngine cSSEngine) throws Exception {
        Control control = (Control)object;
        Color color = control.getBackground();
        return cSSEngine.convert((Object)color, Color.class, null);
    }

    public String retrieveCSSPropertyBackgroundImage(Object object, String string, CSSEngine cSSEngine) throws Exception {
        return "none";
    }

    public String retrieveCSSPropertyBackgroundPosition(Object object, String string, CSSEngine cSSEngine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyBackgroundRepeat(Object object, String string, CSSEngine cSSEngine) throws Exception {
        return null;
    }
}

