/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.compiler.as.tests;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.BatchCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.batch.Main;

public class ActionScriptGenerationBatchTest
extends BatchCompilerTest {
    private static Normalizer outputDirNormalizer = File.separatorChar == '/' ? new StringNormalizer(null, OUTPUT_DIR, "---OUTPUT_DIR_PLACEHOLDER---") : new StringNormalizer(new StringNormalizer(null, File.separator, "/"), OUTPUT_DIR, "---OUTPUT_DIR_PLACEHOLDER---");
    static final String JRE_HOME_DIR = Util.getJREDirectory();
    static /* synthetic */ Class class$0;

    public ActionScriptGenerationBatchTest(String string) {
        super(string);
    }

    public static Test suite() {
        return ActionScriptGenerationBatchTest.buildUniqueComplianceTestSuite((Class)ActionScriptGenerationBatchTest.testClass(), (long)0x310000L);
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.compiler.as.tests.ActionScriptGenerationBatchTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private void runTest(String[] stringArray, String[] stringArray2, boolean bl, String string, String string2, String string3, boolean bl2) {
        int n;
        boolean bl3;
        Object object;
        Object object2;
        Object object3;
        File file;
        String string4;
        File file2 = new File(OUTPUT_DIR);
        if (bl2) {
            Util.flushDirectoryContent((File)file2);
        }
        try {
            if (!file2.isDirectory()) {
                file2.mkdirs();
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                string4 = String.valueOf(OUTPUT_DIR) + File.separator + stringArray[n2];
                file = new File(string4);
                object3 = file.getParentFile();
                if (!((File)object3).isDirectory()) {
                    ((File)object3).mkdirs();
                }
                object2 = new PrintWriter(new FileOutputStream(file));
                ((PrintWriter)object2).write(stringArray[n2 + 1]);
                ((PrintWriter)object2).close();
                n2 += 2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new RuntimeException(fileNotFoundException);
        }
        object2 = String.valueOf(OUTPUT_DIR) + File.separator + this.testName();
        String string5 = String.valueOf(object2) + "out.txt";
        string4 = String.valueOf(object2) + "err.txt";
        object3 = null;
        PrintWriter printWriter = null;
        try {
            try {
                object3 = new PrintWriter(new FileOutputStream(string5));
                printWriter = new PrintWriter(new FileOutputStream(string4));
                file = new org.eclipse.jdt.internal.compiler.as.Main((PrintWriter)object3, printWriter, false, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + '#' + this.getName());
                fileNotFoundException.printStackTrace();
                throw new RuntimeException(fileNotFoundException);
            }
            try {
                object = Main.tokenize((String)string);
                bl3 = file.compile((String[])object);
            }
            catch (RuntimeException runtimeException) {
                boolean bl4 = false;
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + '#' + this.getName());
                runtimeException.printStackTrace();
                throw runtimeException;
            }
        }
        finally {
            if (object3 != null) {
                ((PrintWriter)object3).close();
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
        object = Util.fileContent((String)string5);
        String string6 = Util.fileContent((String)string4);
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (bl3 != bl) {
            bl6 = this.semiNormalizedComparison(string2, (String)object, outputDirNormalizer);
            boolean bl8 = bl5 = bl6 && (bl7 = this.semiNormalizedComparison(string3, string6, outputDirNormalizer));
        }
        if (bl3 == bl || !bl5) {
            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + '#' + this.getName());
            n = 0;
            while (n < stringArray.length) {
                System.out.print(stringArray[n]);
                System.out.println(" [");
                System.out.println(stringArray[n + 1]);
                System.out.println("]");
                n += 2;
            }
        }
        if (bl3 == bl) {
            System.out.println(string6);
        }
        if (bl3 != bl && !bl5) {
            System.out.println("------------ [START OUT] ------------\n------------- Expected: -------------\n" + string2 + "\n------------- but was:  -------------\n" + (String)object + "\n--------- (cut and paste:) ----------\n" + Util.displayString((String)outputDirNormalizer.normalized((String)object)) + "\n------------- [END OUT] -------------\n" + "------------ [START ERR] ------------\n" + "------------- Expected: -------------\n" + string3 + "\n------------- but was:  -------------\n" + string6 + "\n--------- (cut and paste:) ----------\n" + Util.displayString((String)outputDirNormalizer.normalized(string6)) + "\n------------- [END ERR] -------------\n");
        }
        if (!bl) {
            ActionScriptGenerationBatchTest.assertTrue((String)("Unexpected problems: " + string6), (boolean)bl3);
        } else {
            ActionScriptGenerationBatchTest.assertTrue((String)("Unexpected success: " + string6), (!bl3 ? 1 : 0) != 0);
        }
        if (!bl6) {
            ActionScriptGenerationBatchTest.assertEquals((String)("Unexpected standard output for invocation with arguments [" + string + "]"), (String)string2, (String)object);
        }
        if (!bl7) {
            ActionScriptGenerationBatchTest.assertEquals((String)("Unexpected error output for invocation with arguments [" + string + "]"), (String)string3, (String)string6);
        }
        if (!bl) {
            n = 0;
            int n3 = stringArray2 == null ? 0 : stringArray2.length;
            while (n < n3) {
                String string7 = (String.valueOf(OUTPUT_DIR) + File.separator + stringArray2[n++]).replace('/', File.separatorChar);
                String string8 = Util.convertToIndependantLineDelimiter((String)stringArray2[n++]);
                File file3 = new File(string7);
                ActionScriptGenerationBatchTest.assertTrue((String)("missing Action Script file: " + string7), (boolean)file3.exists());
                String string9 = Util.convertToIndependantLineDelimiter((String)Util.fileContent((String)string7));
                if (string8.equals(string9)) continue;
                System.out.println(Util.displayString((String)string9, (int)INDENT, (boolean)SHIFT));
                ActionScriptGenerationBatchTest.assertEquals((String)("unexpected Action Script file contents for " + string7), (String)string8, (String)string9);
            }
        }
    }

    private boolean semiNormalizedComparison(String string, String string2, Normalizer normalizer) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return ActionScriptGenerationBatchTest.equals(string, normalizer.normalized(string2));
    }

    private static boolean equals(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer(string2);
        int n = stringBuffer.length();
        boolean bl = true;
        int n2 = stringBuffer2.length();
        if (n != n2) {
            System.err.println("a and b lengths differ");
            if (n > n2) {
                n = n2;
            }
            bl = false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (stringBuffer.charAt(n3) != stringBuffer2.charAt(n3)) {
                int n4 = n3 - 5;
                int n5 = n3 - 1;
                int n6 = n3 + 1;
                int n7 = n3 + 5;
                if (n4 < 0) {
                    n4 = 0;
                    if (n5 < 0) {
                        n5 = 0;
                    }
                }
                if (n7 >= n) {
                    n7 = n - 1;
                    if (n6 >= n) {
                        n6 = n - 1;
                    }
                }
                System.err.println("a and b differ at rank: " + n3 + "\na: ..." + stringBuffer.substring(n4, n5) + "<" + stringBuffer.charAt(n3) + ">" + stringBuffer.substring(n6, n7) + "..." + "\nb: ..." + stringBuffer2.substring(n4, n5) + "<" + stringBuffer2.charAt(n3) + ">" + stringBuffer2.substring(n6, n7) + "...");
                return false;
            }
            ++n3;
        }
        return bl;
    }

    private String getLibraryClasses() {
        String[] stringArray = Util.getJavaClassLibs();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (n != 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return String.valueOf(stringBuffer);
    }

    private String getJCEJar() {
        if (Util.isMacOS()) {
            return String.valueOf(JRE_HOME_DIR) + "/../Classes/jce.jar";
        }
        return String.valueOf(JRE_HOME_DIR) + "/lib/jce.jar";
    }

    public void test001() {
        this.runTest(new String[]{"p/X.java", "package p;\npublic class X {\n}"}, new String[]{"p/X.as", "package p {\ndynamic public class X {\n}\n}\n"}, false, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClasses() + " -cp " + this.getJCEJar() + " -proceedOnError", "", "", true);
    }

    public void test002() {
        this.runTest(new String[]{"p/X.java", "package p;\npublic class X {\n}"}, new String[]{"p/X.as", "package p {\ndynamic public class X {\n}\n}\n"}, false, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClasses() + " -cp " + this.getJCEJar() + " -proceedOnError -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test003() {
        this.runTest(new String[]{"p/X.java", "package p;\npublic class X {\n}"}, new String[]{"bin/p/X.as", "package p {\ndynamic public class X {\n}\n}\n"}, false, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClasses() + " -cp " + this.getJCEJar() + " -proceedOnError -d \"" + OUTPUT_DIR + File.separator + "bin\"", "", "", true);
    }

    public void test004() {
        this.runTest(new String[]{"p/X.java", "package p;\npublic class X {\n}"}, new String[0], false, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClasses() + " -cp " + this.getJCEJar() + " -proceedOnError -d none", "", "", true);
        ActionScriptGenerationBatchTest.assertFalse((String)"X.as should not be generated", (boolean)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.as").exists());
    }

    public void test005() {
        this.runTest(new String[]{"src/p/X.java", "package p;\npublic class X {\n}"}, new String[]{"bin/p/X.as", "package p {\ndynamic public class X {\n}\n}\n"}, false, "\"" + OUTPUT_DIR + File.separator + "src" + File.separator + "p" + File.separator + "X.java\"" + " -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClasses() + " -cp " + this.getJCEJar() + " -proceedOnError -d \"" + OUTPUT_DIR + File.separator + "bin\"", "", "", true);
    }

    public void test006() {
        this.runTest(new String[]{"src/p/X.java", "package p;\npublic class X {\n}"}, new String[]{"bin/p/X.as", "package p {\ndynamic public class X {\n}\n}\n"}, false, "\"" + OUTPUT_DIR + File.separator + "src" + File.separator + "p" + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClasses() + " -cp " + this.getJCEJar() + " -proceedOnError -d \"" + OUTPUT_DIR + File.separator + "bin\"", "", "", true);
    }

    public void _test007() {
        this.runTest(new String[]{"src/p/X.java", "package p;\npublic class X<T> {\n}"}, null, true, "\"" + OUTPUT_DIR + File.separator + "src" + File.separator + "p" + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClasses() + " -cp " + this.getJCEJar() + " -d \"" + OUTPUT_DIR + File.separator + "bin\"", "", "", true);
    }

    private static abstract class Normalizer {
        private Normalizer nextInChain;

        Normalizer(Normalizer normalizer) {
            this.nextInChain = normalizer;
        }

        String normalized(String string) {
            String string2 = this.nextInChain == null ? Util.convertToIndependantLineDelimiter((String)string) : this.nextInChain.normalized(string);
            return string2;
        }
    }

    private static class StringNormalizer
    extends Normalizer {
        private String match;
        private int matchLength;
        private String placeholder;

        StringNormalizer(Normalizer normalizer, String string, String string2) {
            super(normalizer);
            this.match = string;
            this.matchLength = string.length();
            this.placeholder = string2;
        }

        String normalized(String string) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(string);
            while ((n = stringBuffer.indexOf(this.match)) != -1) {
                stringBuffer.replace(n, n + this.matchLength, this.placeholder);
            }
            String string2 = super.normalized(stringBuffer.toString());
            return string2;
        }
    }
}

