/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.css2;

import org.eclipse.e4.ui.css.core.css2.CSS2FontHelper;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontPropertiesImpl;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class CSS2FontPropertiesHelpers {
    public static final String CSS2FONT_KEY = "org.eclipse.e4.ui.css.core.css2.CSS2FONT_KEY";

    public static CSS2FontProperties getCSS2FontProperties(CSSElementContext cSSElementContext) {
        return (CSS2FontProperties)cSSElementContext.getData(CSS2FONT_KEY);
    }

    public static void setCSS2FontProperties(CSS2FontProperties cSS2FontProperties, CSSElementContext cSSElementContext) {
        if (cSS2FontProperties == null) {
            return;
        }
        cSSElementContext.setData(CSS2FONT_KEY, cSS2FontProperties);
    }

    public static CSS2FontProperties createCSS2FontProperties(CSSValue cSSValue, String string) {
        CSS2FontPropertiesImpl cSS2FontPropertiesImpl = new CSS2FontPropertiesImpl();
        CSS2FontPropertiesHelpers.updateCSSPropertyFont(cSS2FontPropertiesImpl, string, cSSValue);
        return cSS2FontPropertiesImpl;
    }

    public static void updateCSSPropertyFont(CSS2FontProperties cSS2FontProperties, String string, CSSValue cSSValue) {
        if ("font-family".equals(string)) {
            CSS2FontPropertiesHelpers.updateCSSPropertyFontFamily(cSS2FontProperties, cSSValue);
        } else if ("font-size".equals(string)) {
            CSS2FontPropertiesHelpers.updateCSSPropertyFontSize(cSS2FontProperties, cSSValue);
        } else if ("font-style".equals(string)) {
            CSS2FontPropertiesHelpers.updateCSSPropertyFontStyle(cSS2FontProperties, cSSValue);
        } else if ("font-weight".equals(string)) {
            CSS2FontPropertiesHelpers.updateCSSPropertyFontWeight(cSS2FontProperties, cSSValue);
        } else if ("font".equals(string)) {
            CSS2FontPropertiesHelpers.updateCSSPropertyFontComposite(cSS2FontProperties, cSSValue);
        }
    }

    public static void updateCSSPropertyFontComposite(CSS2FontProperties cSS2FontProperties, CSSValue cSSValue) {
        if (cSSValue.getCssValueType() == 2) {
            CSSValueList cSSValueList = (CSSValueList)cSSValue;
            int n = cSSValueList.getLength();
            int n2 = 0;
            while (n2 < n) {
                CSSValue cSSValue2 = cSSValueList.item(n2);
                CSS2FontPropertiesHelpers.updateCSSPropertyFontComposite(cSS2FontProperties, cSSValue2);
                ++n2;
            }
        } else if (cSSValue.getCssValueType() == 1) {
            String string = CSS2FontHelper.getCSSFontPropertyName((CSSPrimitiveValue)cSSValue);
            CSS2FontPropertiesHelpers.updateCSSPropertyFont(cSS2FontProperties, string, cSSValue);
        }
    }

    public static void updateCSSPropertyFontFamily(CSS2FontProperties cSS2FontProperties, CSSValue cSSValue) {
        if (cSSValue.getCssValueType() == 1) {
            cSS2FontProperties.setFamily((CSSPrimitiveValue)cSSValue);
        }
    }

    public static void updateCSSPropertyFontSize(CSS2FontProperties cSS2FontProperties, CSSValue cSSValue) {
        if (cSSValue.getCssValueType() == 1) {
            cSS2FontProperties.setSize((CSSPrimitiveValue)cSSValue);
        }
    }

    public static void updateCSSPropertyFontStyle(CSS2FontProperties cSS2FontProperties, CSSValue cSSValue) {
        if (cSSValue.getCssValueType() == 1) {
            cSS2FontProperties.setStyle((CSSPrimitiveValue)cSSValue);
        }
    }

    public static void updateCSSPropertyFontWeight(CSS2FontProperties cSS2FontProperties, CSSValue cSSValue) {
        if (cSSValue.getCssValueType() == 1) {
            cSS2FontProperties.setWeight((CSSPrimitiveValue)cSSValue);
        }
    }
}

